/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.figures.core;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jwt.we.editors.preferences.PreferenceReader;
import org.eclipse.jwt.we.figures.core.NamedElementFigure;
import org.eclipse.swt.graphics.Image;

public class NamedIconFigure
extends NamedElementFigure {
    public NamedIconFigure() {
        ToolbarLayout layout = new ToolbarLayout(false);
        layout.setStretchMinorAxis(true);
        this.setLayoutManager((LayoutManager)layout);
        this.getLabel().setIconAlignment(2);
        this.getLabel().setTextPlacement(4);
        this.checkBorder();
    }

    protected void checkBorder() {
        if (this.getLabel().getIcon() == null && this.getLabel().getText().length() == 0) {
            this.getLabel().setBorder((Border)new LineBorder(PreferenceReader.appearanceBorderColor.get(), PreferenceReader.appearanceLineWidth.get()));
        } else {
            this.getLabel().setBorder(null);
        }
    }

    public void setName(String name) {
        super.setName(name);
        this.checkBorder();
    }

    public void setIcon(Image newIcon) {
        Image oldIcon = this.getLabel().getIcon();
        if (oldIcon == newIcon) {
            return;
        }
        this.getLabel().setIcon(newIcon);
        this.checkBorder();
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return this.getPreferredChildrenSize(wHint, hHint);
    }

    public Rectangle getCellEditorArea() {
        Rectangle result = this.getClientArea().getCopy();
        Rectangle iconBounds = this.getLabel().getIconBounds();
        return result.crop(new Insets(iconBounds.height, 0, 0, 0));
    }
}

