/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.plugins.viewepc.editor;

import org.eclipse.emf.common.ui.EclipseUIPlugin;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jwt.we.IFactoryRegistry;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.editors.palette.IPaletteFactory;
import org.eclipse.jwt.we.figures.IFigureFactory;
import org.eclipse.jwt.we.figures.IImageFactory;
import org.eclipse.jwt.we.figures.StandardFigureFactory;
import org.eclipse.jwt.we.figures.internal.CompositeFigureFactory;
import org.eclipse.jwt.we.figures.internal.CompositeImageFactory;
import org.eclipse.jwt.we.figures.internal.ImageFactory;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.parts.CompositeEditPartFactory;
import org.eclipse.jwt.we.parts.JWTEditPartFactory;
import org.eclipse.jwt.we.plugins.viewepc.Activator;
import org.eclipse.jwt.we.plugins.viewepc.editor.palette.EpcPaletteFactory;
import org.eclipse.jwt.we.plugins.viewepc.figures.EpcFigureFactory;
import org.eclipse.jwt.we.plugins.viewepc.parts.EpcEditPartFactory;

public class EpcFactoryRegistry
implements IFactoryRegistry {
    private static final Logger logger = Logger.getLogger(EpcFactoryRegistry.class);
    private static final String ICONS_BASE_PATH = "icons/";
    protected IImageFactory imageFactory;
    protected IFigureFactory figureFactory;
    protected EditPartFactory editPartFactory;
    protected IPaletteFactory paletteFactory;

    public IImageFactory getImageFactory(Object ... objects) {
        if (this.imageFactory == null) {
            ImageRegistry imageRegistry = Plugin.getInstance().getImageRegistry();
            CompositeImageFactory compositeImageFactory = new CompositeImageFactory();
            this.imageFactory = new ImageFactory(imageRegistry, (EclipseUIPlugin)Activator.getDefault(), ICONS_BASE_PATH);
            compositeImageFactory.addImageFactory(this.imageFactory);
            this.imageFactory = new ImageFactory(imageRegistry, (EclipseUIPlugin)Plugin.getDefault(), ICONS_BASE_PATH);
            compositeImageFactory.addImageFactory(this.imageFactory);
            this.imageFactory = compositeImageFactory;
            return compositeImageFactory;
        }
        return this.imageFactory;
    }

    public IPaletteFactory getPaletteFactory() {
        if (this.paletteFactory == null) {
            this.paletteFactory = new EpcPaletteFactory();
        }
        return this.paletteFactory;
    }

    public IFigureFactory getFigureFactory() {
        if (this.figureFactory == null) {
            CompositeFigureFactory compositeFigureFactory = new CompositeFigureFactory();
            EpcFigureFactory figureFactory = new EpcFigureFactory();
            compositeFigureFactory.addFigureFactory((IFigureFactory)figureFactory);
            figureFactory = new StandardFigureFactory();
            compositeFigureFactory.addFigureFactory((IFigureFactory)figureFactory);
            this.figureFactory = compositeFigureFactory;
        }
        return this.figureFactory;
    }

    public EditPartFactory getEditPartFactory() {
        if (this.editPartFactory == null) {
            CompositeEditPartFactory compositeEditPartFactory = new CompositeEditPartFactory();
            EpcEditPartFactory editPartFactory = new EpcEditPartFactory();
            compositeEditPartFactory.addEditPartFactory((EditPartFactory)editPartFactory);
            editPartFactory = new JWTEditPartFactory();
            compositeEditPartFactory.addEditPartFactory((EditPartFactory)editPartFactory);
            this.editPartFactory = compositeEditPartFactory;
        }
        return this.editPartFactory;
    }
}

