/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.selection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jwt.we.editors.selection.AbstractSelectionProvider;
import org.eclipse.jwt.we.editors.selection.SelectionConverter;
import org.eclipse.jwt.we.model.view.Reference;

public class SelectionSynchronizer
extends AbstractSelectionProvider
implements ISelectionChangedListener {
    private HashMap<ISelectionProvider, SelectionConverter> selectionProviders = new HashMap();
    private ISelection currentSelection = StructuredSelection.EMPTY;
    private boolean isDispatching = false;

    public SelectionSynchronizer() {
        this.addSelectionChangedListener(this);
        this.addSelectionProvider(this);
    }

    public void addSelectionProvider(ISelectionProvider selectionProvider) {
        this.addSelectionProvider(selectionProvider, null);
    }

    public void addSelectionProvider(ISelectionProvider selectionProvider, SelectionConverter selectionConverter) {
        selectionProvider.setSelection(this.getSelection());
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        this.selectionProviders.put(selectionProvider, selectionConverter);
    }

    public void removeSelectionProvider(ISelectionProvider selectionProvider) {
        selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.selectionProviders.remove(selectionProvider);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.isDispatching) {
            return;
        }
        ISelectionProvider source = event.getSelectionProvider();
        ISelection selection = event.getSelection();
        SelectionConverter sourceConverter = this.selectionProviders.get(source);
        if (sourceConverter != null) {
            selection = sourceConverter.convertFromTargetSelection(selection);
        }
        this.dispatchSelection(selection, source);
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    public void setSelection(ISelection selection) {
        assert (selection != null);
        if (this.currentSelection == selection) {
            return;
        }
        this.currentSelection = selection;
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
    }

    private void dispatchSelection(ISelection selection, ISelectionProvider source) {
        if (this.isDispatching) {
            return;
        }
        this.isDispatching = true;
        for (Map.Entry<ISelectionProvider, SelectionConverter> entry : this.selectionProviders.entrySet()) {
            if (entry.getKey() == source) continue;
            ISelection targetSelection = entry.getValue() == null ? selection : entry.getValue().convertToTargetSelection(selection);
            if (!(entry.getKey() instanceof SelectionSynchronizer) && targetSelection instanceof StructuredSelection) {
                ArrayList<Object> newSelection = new ArrayList<Object>();
                Object[] objectArray = ((StructuredSelection)targetSelection).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selected = objectArray[n2];
                    if (selected instanceof Reference) {
                        newSelection.add(((Reference)selected).getReference());
                    } else {
                        newSelection.add(selected);
                    }
                    ++n2;
                }
                targetSelection = new StructuredSelection(newSelection);
            }
            entry.getKey().setSelection(targetSelection);
        }
        this.isDispatching = false;
    }
}

