/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.menu.legend;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.Resources;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.SeriesLabelProvider;
import org.eclipse.swtchart.extensions.core.SeriesListUI;
import org.eclipse.swtchart.extensions.menu.legend.AbstractMenuListener;
import org.eclipse.swtchart.extensions.menu.legend.Messages;

public class SetColorAction
extends AbstractMenuListener {
    public SetColorAction(SeriesListUI seriesListUI) {
        super(seriesListUI);
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        menuManager.add((IAction)new Action(){

            public String getText() {
                return Messages.getString("SET_COLOR");
            }

            public String getToolTipText() {
                return Messages.getString("ADJUST_COLOR_OF_SELECTED_SERIES");
            }

            public void run() {
                BaseChart baseChart = SetColorAction.this.getBaseChart();
                SeriesListUI seriesListUI = SetColorAction.this.getSeriesListUI();
                Table table = seriesListUI.getTable();
                List<ISeries<?>> selectedSeries = SetColorAction.this.getSelectedSeries();
                if (!selectedSeries.isEmpty()) {
                    ColorDialog colorDialog = new ColorDialog(table.getShell());
                    colorDialog.setText(Messages.getString("setSeriesColor"));
                    RGB rgbNew = colorDialog.open();
                    if (rgbNew != null) {
                        for (ISeries<?> series : selectedSeries) {
                            ISeriesSettings seriesSettings = baseChart.getSeriesSettings(series.getId());
                            Color color = Resources.getColor((RGB)rgbNew);
                            SeriesLabelProvider.setColor(seriesSettings, color);
                            baseChart.applySeriesSettings(series, seriesSettings, true);
                        }
                        SetColorAction.this.refresh();
                    }
                }
            }
        });
    }
}

