/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.internal.marker;

import java.text.DecimalFormat;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swtchart.ICircularSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IAxisSettings;
import org.eclipse.swtchart.extensions.marker.AbstractPositionPaintListener;
import org.eclipse.swtchart.extensions.marker.IPositionPaintListener;
import org.eclipse.swtchart.internal.series.CircularSeries;
import org.eclipse.swtchart.model.Node;

public class LegendMarker
extends AbstractPositionPaintListener
implements IPositionPaintListener {
    private StringBuilder stringBuilder = new StringBuilder();
    private String[] axisLabelsX;
    private DecimalFormat decimalFormatX;
    private String[] axisLabelsY;
    private DecimalFormat decimalFormatY;

    public LegendMarker(BaseChart baseChart) {
        super(baseChart);
        this.axisLabelsX = baseChart.getAxisLabels("X_AXIS");
        this.decimalFormatX = baseChart.getDecimalFormat("X_AXIS", 0);
        this.axisLabelsY = baseChart.getAxisLabels("Y_AXIS");
        this.decimalFormatY = baseChart.getDecimalFormat("Y_AXIS", 0);
    }

    public void paintControl(PaintEvent e) {
        if (this.isDraw()) {
            this.stringBuilder.delete(0, this.stringBuilder.length());
            e.gc.setForeground(this.getForegroundColor());
            e.gc.setBackground(this.getBackgroundColor());
            BaseChart baseChart = this.getBaseChart();
            double primaryValueX = baseChart.getSelectedPrimaryAxisValue(this.getX(), "X_AXIS");
            double primaryValueY = baseChart.getSelectedPrimaryAxisValue(this.getY(), "Y_AXIS");
            boolean isCircularChart = false;
            ISeries[] iSeriesArray = baseChart.getSeriesSet().getSeries();
            int n = iSeriesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries series = iSeriesArray[n2];
                if (series instanceof ICircularSeries) {
                    isCircularChart = true;
                    this.drawNodes(primaryValueX, primaryValueY, (CircularSeries)series);
                }
                ++n2;
            }
            if (!isCircularChart) {
                this.drawXAxes(primaryValueX);
                this.drawYAxes(primaryValueY);
            }
            e.gc.drawText(this.stringBuilder.toString(), 10, 10);
        }
    }

    private void drawNodes(double primaryValueX, double primaryValueY, CircularSeries series) {
        String id = "---";
        String value = "---";
        String percentage = "---";
        Node node = series.getPieSliceFromPosition(primaryValueX, primaryValueY);
        if (node != null) {
            id = node.getDescription().isEmpty() ? node.getId() : node.getDescription();
            double percent = node.getValue() * 100.0 / node.getDataModel().getRootPointer().getValue();
            DecimalFormat decimalFormat = new DecimalFormat();
            value = decimalFormat.format(node.getValue());
            percentage = decimalFormat.format(percent);
        }
        String nodeClass = this.getBaseChart().getAxisSet().getXAxis(0).getTitle().getText();
        String valueClass = this.getBaseChart().getAxisSet().getYAxis(0).getTitle().getText();
        this.stringBuilder.append(nodeClass + " : " + id + "\n");
        this.stringBuilder.append(valueClass + " : " + value + "\n");
        if (node != null) {
            this.stringBuilder.append("Percent of " + node.getDataModel().getRootPointer().getId() + " : " + percentage + "%\n");
        }
    }

    private void drawXAxes(double primaryValueX) {
        BaseChart baseChart = this.getBaseChart();
        IAxisSettings axisSettingsX = baseChart.getXAxisSettings(0);
        if (axisSettingsX != null && axisSettingsX.isVisible()) {
            this.stringBuilder.append(this.axisLabelsX[0]);
            this.stringBuilder.append(": ");
            this.stringBuilder.append(this.decimalFormatX.format(primaryValueX));
        }
        int[] nArray = baseChart.getAxisSet().getXAxisIds();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAxisSettings axisSettings;
            int id = nArray[n2];
            if (id != 0 && (axisSettings = baseChart.getXAxisSettings(id)) != null) {
                IAxisScaleConverter axisScaleConverter = baseChart.getAxisScaleConverter("X_AXIS", id);
                if (axisSettings.isVisible() && axisScaleConverter != null) {
                    if (this.stringBuilder.length() > 0) {
                        this.stringBuilder.append("\n");
                    }
                    this.stringBuilder.append(this.axisLabelsX[id]);
                    this.stringBuilder.append(": ");
                    this.stringBuilder.append(axisSettings.getDecimalFormat().format(axisScaleConverter.convertToSecondaryUnit(primaryValueX)));
                }
            }
            ++n2;
        }
    }

    private void drawYAxes(double primaryValueY) {
        BaseChart baseChart = this.getBaseChart();
        IAxisSettings axisSettingsY = baseChart.getYAxisSettings(0);
        if (axisSettingsY != null && axisSettingsY.isVisible()) {
            if (this.stringBuilder.length() > 0) {
                this.stringBuilder.append("\n");
            }
            this.stringBuilder.append(this.axisLabelsY[0]);
            this.stringBuilder.append(": ");
            this.stringBuilder.append(this.decimalFormatY.format(primaryValueY));
        }
        int[] nArray = baseChart.getAxisSet().getYAxisIds();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAxisSettings axisSettings;
            int id = nArray[n2];
            if (id != 0 && (axisSettings = baseChart.getYAxisSettings(id)) != null) {
                IAxisScaleConverter axisScaleConverter = baseChart.getAxisScaleConverter("Y_AXIS", id);
                if (axisSettings.isVisible() && axisScaleConverter != null) {
                    if (this.stringBuilder.length() > 0) {
                        this.stringBuilder.append("\n");
                    }
                    this.stringBuilder.append(this.axisLabelsY[id]);
                    this.stringBuilder.append(": ");
                    this.stringBuilder.append(axisSettings.getDecimalFormat().format(axisScaleConverter.convertToSecondaryUnit(primaryValueY)));
                }
            }
            ++n2;
        }
    }
}

