package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link DnsConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDnsConfig.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableDnsConfig implements DnsConfig {
  private final @Nullable List<String> nameServers;
  private final @Nullable List<String> search;
  private final @Nullable List<String> options;

  private ImmutableDnsConfig(
      @Nullable List<String> nameServers,
      @Nullable List<String> search,
      @Nullable List<String> options) {
    this.nameServers = nameServers;
    this.search = search;
    this.options = options;
  }

  /**
   * @return The value of the {@code nameServers} attribute
   */
  @JsonProperty("Nameservers")
  @Override
  public @Nullable List<String> nameServers() {
    return nameServers;
  }

  /**
   * @return The value of the {@code search} attribute
   */
  @JsonProperty("Search")
  @Override
  public @Nullable List<String> search() {
    return search;
  }

  /**
   * @return The value of the {@code options} attribute
   */
  @JsonProperty("Options")
  @Override
  public @Nullable List<String> options() {
    return options;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DnsConfig#nameServers() nameServers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDnsConfig withNameServers(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutableDnsConfig(null, this.search, this.options);
    }
    @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableDnsConfig(newValue, this.search, this.options);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DnsConfig#nameServers() nameServers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of nameServers elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDnsConfig withNameServers(@Nullable Iterable<String> elements) {
    if (this.nameServers == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableDnsConfig(newValue, this.search, this.options);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DnsConfig#search() search}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDnsConfig withSearch(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutableDnsConfig(this.nameServers, null, this.options);
    }
    @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableDnsConfig(this.nameServers, newValue, this.options);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DnsConfig#search() search}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of search elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDnsConfig withSearch(@Nullable Iterable<String> elements) {
    if (this.search == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableDnsConfig(this.nameServers, newValue, this.options);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DnsConfig#options() options}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDnsConfig withOptions(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutableDnsConfig(this.nameServers, this.search, null);
    }
    @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableDnsConfig(this.nameServers, this.search, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DnsConfig#options() options}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of options elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDnsConfig withOptions(@Nullable Iterable<String> elements) {
    if (this.options == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableDnsConfig(this.nameServers, this.search, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDnsConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDnsConfig
        && equalTo(0, (ImmutableDnsConfig) another);
  }

  private boolean equalTo(int synthetic, ImmutableDnsConfig another) {
    return Objects.equals(nameServers, another.nameServers)
        && Objects.equals(search, another.search)
        && Objects.equals(options, another.options);
  }

  /**
   * Computes a hash code from attributes: {@code nameServers}, {@code search}, {@code options}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(nameServers);
    h += (h << 5) + Objects.hashCode(search);
    h += (h << 5) + Objects.hashCode(options);
    return h;
  }

  /**
   * Prints the immutable value {@code DnsConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DnsConfig{"
        + "nameServers=" + nameServers
        + ", search=" + search
        + ", options=" + options
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link DnsConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DnsConfig instance
   */
  public static ImmutableDnsConfig copyOf(DnsConfig instance) {
    if (instance instanceof ImmutableDnsConfig) {
      return (ImmutableDnsConfig) instance;
    }
    return ImmutableDnsConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDnsConfig ImmutableDnsConfig}.
   * <pre>
   * ImmutableDnsConfig.builder()
   *    .nameServers(List&amp;lt;String&amp;gt; | null) // nullable {@link DnsConfig#nameServers() nameServers}
   *    .search(List&amp;lt;String&amp;gt; | null) // nullable {@link DnsConfig#search() search}
   *    .options(List&amp;lt;String&amp;gt; | null) // nullable {@link DnsConfig#options() options}
   *    .build();
   * </pre>
   * @return A new ImmutableDnsConfig builder
   */
  public static ImmutableDnsConfig.Builder builder() {
    return new ImmutableDnsConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDnsConfig ImmutableDnsConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder implements DnsConfig.Builder {
    private List<String> nameServers = null;
    private List<String> search = null;
    private List<String> options = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DnsConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DnsConfig instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable List<String> nameServersValue = instance.nameServers();
      if (nameServersValue != null) {
        addAllNameServers(nameServersValue);
      }
      @Nullable List<String> searchValue = instance.search();
      if (searchValue != null) {
        addAllSearch(searchValue);
      }
      @Nullable List<String> optionsValue = instance.options();
      if (optionsValue != null) {
        addAllOptions(optionsValue);
      }
      return this;
    }

    /**
     * Adds one element to {@link DnsConfig#nameServers() nameServers} list.
     * @param element A nameServers element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder nameServer(String element) {
      if (this.nameServers == null) {
        this.nameServers = new ArrayList<String>();
      }
      this.nameServers.add(Objects.requireNonNull(element, "nameServers element"));
      return this;
    }

    /**
     * Adds elements to {@link DnsConfig#nameServers() nameServers} list.
     * @param elements An array of nameServers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder nameServers(String... elements) {
      if (this.nameServers == null) {
        this.nameServers = new ArrayList<String>();
      }
      for (String element : elements) {
        this.nameServers.add(Objects.requireNonNull(element, "nameServers element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DnsConfig#nameServers() nameServers} list.
     * @param elements An iterable of nameServers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Nameservers")
    public final Builder nameServers(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.nameServers = null;
        return this;
      }
      this.nameServers = new ArrayList<String>();
      return addAllNameServers(elements);
    }

    /**
     * Adds elements to {@link DnsConfig#nameServers() nameServers} list.
     * @param elements An iterable of nameServers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNameServers(Iterable<String> elements) {
      Objects.requireNonNull(elements, "nameServers element");
      if (this.nameServers == null) {
        this.nameServers = new ArrayList<String>();
      }
      for (String element : elements) {
        this.nameServers.add(Objects.requireNonNull(element, "nameServers element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link DnsConfig#search() search} list.
     * @param element A search element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder search(String element) {
      if (this.search == null) {
        this.search = new ArrayList<String>();
      }
      this.search.add(Objects.requireNonNull(element, "search element"));
      return this;
    }

    /**
     * Adds elements to {@link DnsConfig#search() search} list.
     * @param elements An array of search elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder search(String... elements) {
      if (this.search == null) {
        this.search = new ArrayList<String>();
      }
      for (String element : elements) {
        this.search.add(Objects.requireNonNull(element, "search element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DnsConfig#search() search} list.
     * @param elements An iterable of search elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Search")
    public final Builder search(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.search = null;
        return this;
      }
      this.search = new ArrayList<String>();
      return addAllSearch(elements);
    }

    /**
     * Adds elements to {@link DnsConfig#search() search} list.
     * @param elements An iterable of search elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSearch(Iterable<String> elements) {
      Objects.requireNonNull(elements, "search element");
      if (this.search == null) {
        this.search = new ArrayList<String>();
      }
      for (String element : elements) {
        this.search.add(Objects.requireNonNull(element, "search element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link DnsConfig#options() options} list.
     * @param element A options element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder option(String element) {
      if (this.options == null) {
        this.options = new ArrayList<String>();
      }
      this.options.add(Objects.requireNonNull(element, "options element"));
      return this;
    }

    /**
     * Adds elements to {@link DnsConfig#options() options} list.
     * @param elements An array of options elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder options(String... elements) {
      if (this.options == null) {
        this.options = new ArrayList<String>();
      }
      for (String element : elements) {
        this.options.add(Objects.requireNonNull(element, "options element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DnsConfig#options() options} list.
     * @param elements An iterable of options elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Options")
    public final Builder options(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.options = null;
        return this;
      }
      this.options = new ArrayList<String>();
      return addAllOptions(elements);
    }

    /**
     * Adds elements to {@link DnsConfig#options() options} list.
     * @param elements An iterable of options elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOptions(Iterable<String> elements) {
      Objects.requireNonNull(elements, "options element");
      if (this.options == null) {
        this.options = new ArrayList<String>();
      }
      for (String element : elements) {
        this.options.add(Objects.requireNonNull(element, "options element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableDnsConfig ImmutableDnsConfig}.
     * @return An immutable instance of DnsConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDnsConfig build() {
      return new ImmutableDnsConfig(
          nameServers == null ? null : createUnmodifiableList(true, nameServers),
          search == null ? null : createUnmodifiableList(true, search),
          options == null ? null : createUnmodifiableList(true, options));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
