/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.properties.internal.sections;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.mdht.uml.common.util.NamedElementUtil;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.mdht.uml.ui.properties.sections.WrapperAwareModelerPropertySection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;

public class NamedElementSection
extends WrapperAwareModelerPropertySection {
    private TabbedPropertySheetPage tabbedPropertySheetPage;
    protected NamedElement namedElement;
    private Text localNameText;
    private boolean localNameModified = false;
    private Text businessNameText;
    private boolean businessNameModified = false;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            if (NamedElementSection.this.localNameText == event.getSource()) {
                NamedElementSection.this.localNameModified = true;
            }
            if (NamedElementSection.this.businessNameText == event.getSource()) {
                NamedElementSection.this.businessNameModified = true;
            }
        }
    };
    private KeyListener keyListener = new KeyListener(){

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if ('\r' == e.character || '\u1000050' == e.character) {
                NamedElementSection.this.modifyFields();
            }
        }
    };
    private FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent event) {
            NamedElementSection.this.modifyFields();
        }
    };

    private void modifyFields() {
        if (!this.localNameModified && !this.businessNameModified) {
            return;
        }
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.namedElement);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){
                URI propertiesURI;
                String properties;
                {
                    this.propertiesURI = null;
                    this.properties = null;
                }

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    if (!NamedElementSection.this.localNameModified && !NamedElementSection.this.businessNameModified) {
                        return Status.CANCEL_STATUS;
                    }
                    this.propertiesURI = UMLUtil.getPropertiesURI((Resource)NamedElementSection.this.namedElement.eResource());
                    this.properties = UMLUtil.readProperties((URI)this.propertiesURI);
                    if (NamedElementSection.this.localNameModified) {
                        NamedElementSection.this.localNameModified = false;
                        this.setLabel("Set Name");
                        String oldPropertyKey = NamedElementUtil.getLabelPropertyKey((NamedElement)NamedElementSection.this.namedElement);
                        Map<String, String> parsedProperties = this.properties != null ? UMLUtil.parseProperties((String)this.properties) : new LinkedHashMap();
                        String oldProperty = (String)parsedProperties.remove(oldPropertyKey);
                        NamedElementSection.this.namedElement.setName(NamedElementSection.this.localNameText.getText());
                        if (oldProperty != null) {
                            String newPropertyKey = NamedElementUtil.getLabelPropertyKey((NamedElement)NamedElementSection.this.namedElement);
                            parsedProperties.put(newPropertyKey, oldProperty.replace(oldPropertyKey, newPropertyKey));
                            UMLUtil.writeProperties((URI)this.propertiesURI, parsedProperties);
                        }
                        NamedElementSection.this.refreshBusinessNameText();
                    } else if (NamedElementSection.this.businessNameModified) {
                        NamedElementSection.this.businessNameModified = false;
                        this.setLabel("Set Business Name");
                        if (!NamedElementUtil.setBusinessName((NamedElement)NamedElementSection.this.namedElement, (String)NamedElementSection.this.businessNameText.getText())) {
                            NamedElementSection.this.refreshBusinessNameText();
                            return Status.CANCEL_STATUS;
                        }
                    }
                    return Status.OK_STATUS;
                }

                protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    IStatus result = super.doUndo(monitor, info);
                    if (result.isOK()) {
                        URIConverter uriConverter = this.getEditingDomain().getResourceSet().getURIConverter();
                        if (uriConverter.exists(this.propertiesURI, null)) {
                            if (this.properties == null) {
                                this.properties = UMLUtil.readProperties((URI)this.propertiesURI);
                                try {
                                    uriConverter.delete(this.propertiesURI, null);
                                }
                                catch (IOException ioe) {
                                    return Status.CANCEL_STATUS;
                                }
                            } else {
                                Map parsedProperties = UMLUtil.parseProperties((String)this.properties);
                                this.properties = UMLUtil.readProperties((URI)this.propertiesURI);
                                UMLUtil.writeProperties((URI)this.propertiesURI, (Map)parsedProperties);
                            }
                        }
                        if (!NamedElementSection.this.businessNameText.isDisposed()) {
                            NamedElementSection.this.refreshBusinessNameText();
                        }
                    }
                    return result;
                }

                protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    IStatus result = super.doRedo(monitor, info);
                    if (result.isOK()) {
                        if (this.properties != null) {
                            Map parsedProperties = UMLUtil.parseProperties((String)this.properties);
                            this.properties = UMLUtil.readProperties((URI)this.propertiesURI);
                            UMLUtil.writeProperties((URI)this.propertiesURI, (Map)parsedProperties);
                        }
                        if (!NamedElementSection.this.businessNameText.isDisposed()) {
                            NamedElementSection.this.refreshBusinessNameText();
                        }
                    }
                    return result;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.tabbedPropertySheetPage = aTabbedPropertySheetPage;
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        FormData data = null;
        this.localNameText = this.getWidgetFactory().createText(composite, "");
        data = new FormData();
        data.left = new FormAttachment(0, 105);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 2, 6);
        this.localNameText.setLayoutData((Object)data);
        CLabel localNameLabel = this.getWidgetFactory().createCLabel(composite, "Name:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.localNameText, -5);
        data.top = new FormAttachment((Control)this.localNameText, 0, 0x1000000);
        localNameLabel.setLayoutData((Object)data);
        this.businessNameText = this.getWidgetFactory().createText(composite, "");
        data = new FormData();
        data.left = new FormAttachment(0, 105);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(1, 2, 6);
        this.businessNameText.setLayoutData((Object)data);
        CLabel businessNameLabel = this.getWidgetFactory().createCLabel(composite, "Business Name:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.businessNameText, -5);
        data.top = new FormAttachment((Control)this.businessNameText, 0, 0x1000000);
        businessNameLabel.setLayoutData((Object)data);
    }

    @Override
    protected boolean isReadOnly() {
        TransactionalEditingDomain editingDomain;
        if (this.namedElement != null && (editingDomain = TransactionUtil.getEditingDomain((EObject)this.namedElement)) != null && editingDomain.isReadOnly(this.namedElement.eResource())) {
            return true;
        }
        return super.isReadOnly();
    }

    protected boolean addToEObjectList(Object object) {
        boolean added = super.addToEObjectList(object);
        if (!added && object instanceof Element) {
            this.getEObjectList().add(object);
            added = true;
        }
        return added;
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        EObject element = this.getEObject();
        if (element instanceof View) {
            element = ((View)element).getElement();
        }
        Assert.isTrue((boolean)(element instanceof NamedElement));
        this.namedElement = (NamedElement)element;
    }

    public void dispose() {
        super.dispose();
        this.namedElement = null;
    }

    protected void refreshBusinessNameText() {
        this.businessNameText.removeModifyListener(this.modifyListener);
        this.businessNameText.removeKeyListener(this.keyListener);
        this.businessNameText.removeFocusListener(this.focusListener);
        if (this.namedElement.getName() != null) {
            this.businessNameText.setText(NamedElementUtil.getBusinessName((NamedElement)this.namedElement));
        } else {
            this.businessNameText.setText("");
        }
        this.businessNameText.addModifyListener(this.modifyListener);
        this.businessNameText.addKeyListener(this.keyListener);
        this.businessNameText.addFocusListener(this.focusListener);
        this.businessNameText.setEnabled(!this.isReadOnly());
    }

    public void refresh() {
        this.localNameText.removeModifyListener(this.modifyListener);
        this.localNameText.removeKeyListener(this.keyListener);
        this.localNameText.removeFocusListener(this.focusListener);
        if (this.namedElement.getName() != null) {
            this.localNameText.setText(this.namedElement.getName());
        } else {
            this.localNameText.setText("");
        }
        this.localNameText.addModifyListener(this.modifyListener);
        this.localNameText.addKeyListener(this.keyListener);
        this.localNameText.addFocusListener(this.focusListener);
        this.localNameText.setEnabled(!this.isReadOnly());
        this.refreshBusinessNameText();
        this.tabbedPropertySheetPage.labelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)new LabelProvider()));
    }
}

