/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.common.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.mdht.uml.common.internal.Logger;
import org.eclipse.mdht.uml.common.util.NamedElementUtil;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Artifact;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ClassifierTemplateParameter;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class UMLUtil {
    private static final String UML2REFLECTIONERROR = "UML2 Reflection Error";
    protected static final String PROPERTIES_ENCODING = "ISO-8859-1";
    protected static Pattern PROPERTY_LINE = Pattern.compile("\\s*(\\S+)\\s*=.*", 8);

    public static void addAliasName(Element element, String alias) {
        if (alias != null && alias.length() > 0) {
            EAnnotation annotation = element.createEAnnotation("uml2.alias");
            annotation.getDetails().put((Object)alias, null);
        }
    }

    public static void cloneStereotypes(Class first, Class second) {
        UMLUtil.cloneStereotypes((Element)first, (Element)second);
        for (Property p1 : first.getOwnedAttributes()) {
            Property p2 = second.getOwnedAttribute(p1.getName(), p1.getType());
            if (p2 == null) continue;
            UMLUtil.cloneStereotypes((Element)p1, (Element)p2);
        }
        for (Constraint constraint1 : first.getOwnedRules()) {
            Constraint constraint2 = second.getOwnedRule(constraint1.getName());
            if (constraint2 == null) continue;
            UMLUtil.cloneStereotypes((Element)constraint1, (Element)constraint2);
        }
        for (Classifier nested1 : first.getNestedClassifiers()) {
            Classifier nested2 = second.getNestedClassifier(nested1.getName());
            if (nested2 == null) continue;
            if (nested1 instanceof Class && nested2 instanceof Class) {
                UMLUtil.cloneStereotypes((Class)nested1, (Class)nested2);
                continue;
            }
            UMLUtil.cloneStereotypes((Element)nested1, (Element)nested2);
        }
    }

    public static void cloneStereotypes(Element first, Element second) {
        for (Stereotype s : first.getAppliedStereotypes()) {
            if (!second.isStereotypeApplicable(s) || second.isStereotypeApplied(s)) continue;
            second.applyStereotype(s);
            for (Property sProperty : s.getAllAttributes()) {
                if (sProperty.getName().startsWith("base_")) continue;
                try {
                    Object value = first.getValue(s, sProperty.getName());
                    if (value == null) continue;
                    second.setValue(s, sProperty.getName(), value);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    public static void cloneStereotypes(Enumeration first, Enumeration second) {
        UMLUtil.cloneStereotypes((Element)first, (Element)second);
        for (EnumerationLiteral literal1 : first.getOwnedLiterals()) {
            EnumerationLiteral literal2 = second.getOwnedLiteral(literal1.getName());
            if (literal2 == null) continue;
            UMLUtil.cloneStereotypes((Element)literal1, (Element)literal2);
        }
    }

    public static List<Classifier> getAllGeneralizations(Classifier classifier) {
        ArrayList<Classifier> parents = new ArrayList<Classifier>();
        parents.add(classifier);
        for (Classifier parent : classifier.getGenerals()) {
            parents.addAll(UMLUtil.getAllGeneralizations(parent));
        }
        return parents;
    }

    public static List<String> getAllParentNames(Classifier classifier) {
        ArrayList<String> parentNames = new ArrayList<String>();
        parentNames.add(classifier.getName());
        for (Classifier parent : classifier.getGenerals()) {
            parentNames.addAll(UMLUtil.getAllParentNames(parent));
        }
        return parentNames;
    }

    public static List<Classifier> getSpecializations(Classifier classifier) {
        ArrayList<Classifier> subclasses = new ArrayList<Classifier>();
        EList specializations = classifier.getTargetDirectedRelationships(UMLPackage.Literals.GENERALIZATION);
        for (DirectedRelationship relationship : specializations) {
            Classifier specific = ((Generalization)relationship).getSpecific();
            if (specific == null) continue;
            subclasses.add(specific);
        }
        return subclasses;
    }

    public static List<Classifier> getAllSpecializations(Classifier classifier) {
        ArrayList<Classifier> allSpecializations = new ArrayList<Classifier>();
        EList specializations = classifier.getTargetDirectedRelationships(UMLPackage.Literals.GENERALIZATION);
        for (DirectedRelationship relationship : specializations) {
            Classifier specific = ((Generalization)relationship).getSpecific();
            if (specific == null) continue;
            allSpecializations.add(specific);
            allSpecializations.addAll(UMLUtil.getAllSpecializations(specific));
        }
        return allSpecializations;
    }

    public static Profile getAppliedProfile(String profileURI, Element element) {
        block8: {
            Profile profile;
            block9: {
                if (element == null) {
                    return null;
                }
                ResourceSet resourceSet = element.eResource().getResourceSet();
                Resource profileResource = resourceSet.getResource(URI.createURI((String)profileURI), true);
                if (profileResource == null) break block8;
                profile = (Profile)EcoreUtil.getObjectByType((Collection)profileResource.getContents(), (EClassifier)UMLPackage.eINSTANCE.getProfile());
                if (profile != null) break block9;
                return null;
            }
            try {
                try {
                    Package pkg = element.getNearestPackage();
                    while (pkg != null) {
                        if (pkg.isProfileApplied(profile)) {
                            return profile;
                        }
                        pkg = pkg.getNestingPackage();
                    }
                }
                catch (IllegalArgumentException e) {
                    Logger.logException(e);
                }
            }
            catch (WrappedException we) {
                Logger.logException(we);
            }
        }
        return null;
    }

    public static Class getClassByName(Package basePackage, String localName) {
        return (Class)UMLUtil.getClassifierByName(basePackage, localName, UMLPackage.Literals.CLASS);
    }

    public static Classifier getClassifierByName(Package basePackage, String localName) {
        return UMLUtil.getClassifierByName(basePackage, localName, null);
    }

    public static Classifier getClassifierByName(Package basePackage, final String localName, final EClass eClass) {
        if (basePackage == null || localName == null) {
            return null;
        }
        Classifier classifier = null;
        UMLSwitch<Object> umlSwitch = new UMLSwitch<Object>(){

            public Object caseClassifier(Classifier classifier) {
                if (localName.equals(classifier.getName())) {
                    if (eClass == null) {
                        return classifier;
                    }
                    return eClass == classifier.eClass() ? classifier : null;
                }
                return null;
            }

            public Object casePackage(Package pkg) {
                Object result = null;
                for (NamedElement namedElement : pkg.getOwnedMembers()) {
                    result = this.doSwitch((EObject)namedElement);
                    if (result != null) break;
                }
                return result;
            }
        };
        classifier = (Classifier)umlSwitch.doSwitch((EObject)basePackage);
        return classifier;
    }

    public static Classifier getConstrainingClassifier(ClassifierTemplateParameter classifierTemplateParameter) {
        Classifier classifier = null;
        boolean reflectionCompleted = false;
        try {
            Method getConstrainingClassifier = ClassifierTemplateParameter.class.getMethod("getConstrainingClassifier", null);
            classifier = (Classifier)getConstrainingClassifier.invoke((Object)classifierTemplateParameter, null);
            reflectionCompleted = true;
        }
        catch (IllegalArgumentException getConstrainingClassifier) {
        }
        catch (IllegalAccessException getConstrainingClassifier) {
        }
        catch (InvocationTargetException getConstrainingClassifier) {
        }
        catch (SecurityException getConstrainingClassifier) {
        }
        catch (NoSuchMethodException getConstrainingClassifier) {
            // empty catch block
        }
        if (!reflectionCompleted) {
            try {
                Method getConstrainingClassifiers = ClassifierTemplateParameter.class.getMethod("getConstrainingClassifiers", null);
                EList classifiers = (EList)getConstrainingClassifiers.invoke((Object)classifierTemplateParameter, null);
                if (classifiers.size() > 0) {
                    classifier = (Classifier)classifiers.get(0);
                }
                reflectionCompleted = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (!reflectionCompleted) {
            throw new RuntimeException(UML2REFLECTIONERROR);
        }
        return classifier;
    }

    public static List<Resource> getControlledResources(Resource resource) {
        UniqueEList.FastCompare controlledResources = new UniqueEList.FastCompare();
        if (resource != null) {
            TreeIterator allContents = resource.getAllContents();
            while (allContents.hasNext()) {
                Resource.Internal directResource = ((InternalEObject)allContents.next()).eDirectResource();
                if (directResource == null || directResource == resource) continue;
                controlledResources.add(directResource);
            }
        }
        return controlledResources;
    }

    public static DataType getDataTypeByName(Package basePackage, String localName) {
        return (DataType)UMLUtil.getClassifierByName(basePackage, localName, UMLPackage.Literals.DATA_TYPE);
    }

    public static Enumeration getEnumerationByName(Package basePackage, String localName) {
        return (Enumeration)UMLUtil.getClassifierByName(basePackage, localName, UMLPackage.Literals.ENUMERATION);
    }

    public static Namespace getNearestNamespace(Element element) {
        if (element.eIsProxy()) {
            return null;
        }
        Element eObject = element;
        while (!(eObject instanceof Namespace)) {
            eObject = eObject.eContainer();
        }
        return eObject instanceof Namespace ? (Namespace)eObject : null;
    }

    public static List<Property> getOwnedAttributes(Type type) {
        return new UMLSwitch<List<Property>>(){

            public List<Property> caseArtifact(Artifact artifact) {
                return artifact.getOwnedAttributes();
            }

            public List<Property> caseDataType(DataType dataType) {
                return dataType.getOwnedAttributes();
            }

            public List<Property> caseInterface(Interface interface_) {
                return interface_.getOwnedAttributes();
            }

            public List<Property> caseSignal(Signal signal) {
                return signal.getOwnedAttributes();
            }

            public List<Property> caseStructuredClassifier(StructuredClassifier structuredClassifier) {
                return structuredClassifier.getOwnedAttributes();
            }

            public List<Property> doSwitch(EObject eObject) {
                return eObject == null ? null : (List)super.doSwitch(eObject);
            }
        }.doSwitch((EObject)type);
    }

    public static List<Operation> getOwnedOperations(Type type) {
        return new UMLSwitch<List<Operation>>(){

            public List<Operation> caseArtifact(Artifact artifact) {
                return artifact.getOwnedOperations();
            }

            public List<Operation> caseDataType(DataType dataType) {
                return dataType.getOwnedOperations();
            }

            public List<Operation> caseInterface(Interface interface_) {
                return interface_.getOwnedOperations();
            }

            public List<Operation> caseClass(Class clazz) {
                return clazz.getOwnedOperations();
            }

            public List<Operation> doSwitch(EObject eObject) {
                return eObject == null ? null : (List)super.doSwitch(eObject);
            }
        }.doSwitch((EObject)type);
    }

    public static String getClassQualifiedName(Property property) {
        if (property.eIsProxy() || property.getName() == null) {
            return null;
        }
        StringBuffer qname = new StringBuffer();
        qname.append(property.getClass_().getName());
        qname.append("::");
        qname.append(property.getName());
        return qname.toString();
    }

    public static String getPackageQualifiedName(NamedElement namedElement) {
        if (namedElement.eIsProxy() || namedElement.getName() == null) {
            return null;
        }
        StringBuffer qname = new StringBuffer(namedElement.getName());
        Element container = namedElement.getOwner();
        while (container instanceof NamedElement) {
            qname.insert(0, "::");
            qname.insert(0, ((NamedElement)container).getName());
            if (container instanceof Package) break;
            container = container.getOwner();
        }
        return qname.toString();
    }

    public static ParameterableElement getParameterableElement(TemplateParameterSubstitution substitution) {
        ParameterableElement parameterableElement = null;
        boolean reflectionCompleted = false;
        try {
            Method getAcuals = TemplateParameterSubstitution.class.getMethod("getActuals", null);
            EList actuals = (EList)getAcuals.invoke((Object)substitution, null);
            reflectionCompleted = true;
            if (actuals.size() > 0) {
                parameterableElement = (ParameterableElement)actuals.get(0);
            }
        }
        catch (IllegalArgumentException getAcuals) {
        }
        catch (IllegalAccessException getAcuals) {
        }
        catch (InvocationTargetException getAcuals) {
        }
        catch (SecurityException getAcuals) {
        }
        catch (NoSuchMethodException getAcuals) {
            // empty catch block
        }
        if (!reflectionCompleted) {
            try {
                Method getAcual = TemplateParameterSubstitution.class.getMethod("getActual", null);
                parameterableElement = (ParameterableElement)getAcual.invoke((Object)substitution, null);
                reflectionCompleted = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (!reflectionCompleted) {
            throw new RuntimeException(UML2REFLECTIONERROR);
        }
        return parameterableElement;
    }

    public static URI getPropertiesURI(Resource resource) {
        if (resource != null && resource.getURI() != null) {
            return resource.getURI().trimFileExtension().appendFileExtension("properties");
        }
        return null;
    }

    public static Property getNavigableEnd(Association association) {
        Property navigableEnd = null;
        for (Property end : association.getMemberEnds()) {
            if (!end.isNavigable()) continue;
            if (navigableEnd != null) {
                return null;
            }
            navigableEnd = end;
        }
        return navigableEnd;
    }

    public static List<Property> getRedefinedProperties(Property property) {
        ArrayList<Property> redefinedProperties = new ArrayList<Property>();
        if (!property.getRedefinedProperties().isEmpty()) {
            redefinedProperties.addAll((Collection<Property>)property.getRedefinedProperties());
        } else {
            for (Classifier parent : property.getClass_().allParents()) {
                Property p = parent.getAttribute(property.getName(), null);
                if (p == null) continue;
                redefinedProperties.add(p);
            }
        }
        return redefinedProperties;
    }

    public static Classifier getTemplate(Classifier classifier) {
        Classifier template = null;
        for (TemplateBinding binding : classifier.getTemplateBindings()) {
            if (!(binding.getSignature().getTemplate() instanceof Classifier)) continue;
            template = (Classifier)binding.getSignature().getTemplate();
        }
        return template;
    }

    public static List<Classifier> getTemplateBindingParameters(Classifier classifier) {
        TemplateBinding binding;
        ArrayList<Classifier> params = new ArrayList<Classifier>();
        Iterator iterator = classifier.getTemplateBindings().iterator();
        if (iterator.hasNext() && (binding = (TemplateBinding)iterator.next()).getSignature().getTemplate() instanceof Classifier) {
            for (TemplateParameterSubstitution substitution : binding.getParameterSubstitutions()) {
                ParameterableElement element = UMLUtil.getParameterableElement(substitution);
                if (!(element instanceof Classifier)) continue;
                params.add((Classifier)element);
            }
        }
        return params;
    }

    public static Package getTopPackage(Element element) {
        return element == null || element.eIsProxy() ? null : UMLUtil.getTopPackage(element.getNearestPackage());
    }

    public static Package getTopPackage(Package pkg) {
        if (pkg == null || pkg.eIsProxy()) {
            return null;
        }
        EList allOwningPackages = pkg.allOwningPackages();
        int size = allOwningPackages.size();
        return size > 0 ? (Package)allOwningPackages.get(size - 1) : pkg;
    }

    public static String getUniqueNestedClassifierName(Class owner, String name) {
        int seqNo = 1;
        String uniqueName = name;
        while (owner.getNestedClassifier(uniqueName) != null) {
            uniqueName = String.valueOf(name) + String.valueOf(seqNo++);
        }
        return uniqueName;
    }

    public static String getUniqueTypeName(Package owner, String name) {
        int seqNo = 1;
        String uniqueName = name;
        while (owner.getOwnedType(uniqueName) != null) {
            uniqueName = String.valueOf(name) + String.valueOf(seqNo++);
        }
        return uniqueName;
    }

    public static Package importLibrary(Package basePackage, String libraryURI) {
        Package library = null;
        try {
            ResourceSet resourceSet = basePackage.eResource().getResourceSet();
            Resource libraryResource = resourceSet.getResource(URI.createURI((String)libraryURI), true);
            if (libraryResource != null && (library = (Package)EcoreUtil.getObjectByType((Collection)libraryResource.getContents(), (EClassifier)UMLPackage.eINSTANCE.getPackage())) != null) {
                PackageImport packageImport = null;
                Package topPackage = UMLUtil.getTopPackage(basePackage);
                for (PackageImport pkgImport : topPackage.getPackageImports()) {
                    if (!library.equals(pkgImport.getImportedPackage())) continue;
                    packageImport = pkgImport;
                    break;
                }
                if (packageImport == null) {
                    packageImport = topPackage.createPackageImport(library);
                }
            }
        }
        catch (WrappedException we) {
            Logger.logException(we);
        }
        return library;
    }

    public static boolean isSameModel(Element first, Element second) {
        if (first == null || second == null) {
            return false;
        }
        Package firstPackage = UMLUtil.getTopPackage(first);
        Package secondPackage = UMLUtil.getTopPackage(second);
        if (firstPackage != null || secondPackage != null) {
            if (firstPackage != null) {
                return firstPackage.equals(secondPackage);
            }
        } else if (first.eResource() != null && second.eResource() != null) {
            return first.eResource().getURI().equals(second.eResource().getURI());
        }
        return false;
    }

    public static boolean isSameProject(Element first, Element second) {
        if (first == null || first.eResource() == null || second == null || second.eResource() == null) {
            return false;
        }
        try {
            FindResourcesByNameVisitor firstVisitor = new FindResourcesByNameVisitor(first.eResource().getURI().lastSegment());
            IWorkspace iw = ResourcesPlugin.getWorkspace();
            iw.getRoot().accept((IResourceVisitor)firstVisitor);
            FindResourcesByNameVisitor secondVisitor = new FindResourcesByNameVisitor(second.eResource().getURI().lastSegment());
            iw.getRoot().accept((IResourceVisitor)secondVisitor);
            if (!firstVisitor.getResources().isEmpty() && firstVisitor.getResources().size() == 1 && !secondVisitor.getResources().isEmpty() && secondVisitor.getResources().size() == 1) {
                IProject secondProject;
                IProject firstProject = firstVisitor.getResources().get(0).getProject();
                return firstProject.equals((Object)(secondProject = secondVisitor.getResources().get(0).getProject()));
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isTemplateBinding(Classifier classifier) {
        return classifier != null && classifier.getTemplateBindings().size() > 0;
    }

    public static Map<String, String> parseProperties(String properties) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        int i = 0;
        while (i < properties.length()) {
            int eol;
            int start = i;
            while (true) {
                if ((eol = properties.indexOf("\n", start)) != -1) {
                    if (eol + 1 < properties.length() && properties.charAt(eol + 1) == '\r') {
                        if (eol > start && properties.charAt(eol - 1) == '\\') {
                            start = eol + 2;
                            continue;
                        }
                        ++eol;
                        break;
                    }
                    if ((eol <= start || properties.charAt(eol - 1) != '\\') && (eol - 1 <= start || properties.charAt(eol - 1) != '\r' || properties.charAt(eol - 2) != '\\')) break;
                    start = eol + 1;
                    continue;
                }
                eol = properties.indexOf("\r", start);
                if (eol == -1) {
                    eol = properties.length() - 1;
                    break;
                }
                if (eol <= start || properties.charAt(eol - 1) != '\\') break;
                start = eol + 1;
            }
            String property = properties.substring(i, eol + 1);
            Matcher matcher = PROPERTY_LINE.matcher(property);
            if (matcher.find() && matcher.groupCount() >= 1) {
                int end;
                int begin = matcher.start(1);
                String propertyName = property.substring(begin, end = matcher.end(1));
                if (propertyName.indexOf("#") == -1) {
                    result.put(propertyName, property);
                } else if (propertyName.startsWith("#")) {
                    result.put(propertyName.substring(1), property);
                }
            }
            i = eol + 1;
        }
        return result;
    }

    public static String readProperties(URI uri) {
        if (uri != null) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new ExtensibleURIConverterImpl().createInputStream(uri));
                byte[] input = new byte[bufferedInputStream.available()];
                bufferedInputStream.read(input);
                bufferedInputStream.close();
                return new String(input, PROPERTIES_ENCODING);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void setConstrainingClassifier(ClassifierTemplateParameter classifierTemplateParameter, Classifier constraint) {
        boolean reflectionCompleted = false;
        try {
            Method setConstrainingClassifier = ClassifierTemplateParameter.class.getMethod("setConstrainingClassifier", Classifier.class);
            setConstrainingClassifier.invoke((Object)classifierTemplateParameter, constraint);
            reflectionCompleted = true;
        }
        catch (IllegalArgumentException setConstrainingClassifier) {
        }
        catch (IllegalAccessException setConstrainingClassifier) {
        }
        catch (InvocationTargetException setConstrainingClassifier) {
        }
        catch (SecurityException setConstrainingClassifier) {
        }
        catch (NoSuchMethodException setConstrainingClassifier) {
            // empty catch block
        }
        if (!reflectionCompleted) {
            try {
                Method getConstrainingClassifiers = ClassifierTemplateParameter.class.getMethod("getConstrainingClassifiers", null);
                EList classifiers = (EList)getConstrainingClassifiers.invoke((Object)classifierTemplateParameter, null);
                classifiers.add((Object)constraint);
                reflectionCompleted = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (!reflectionCompleted) {
            throw new RuntimeException(UML2REFLECTIONERROR);
        }
    }

    public static String setEObjectID(Association association) {
        return UMLUtil.setEObjectID((Element)association);
    }

    public static String setEObjectID(Element element) {
        String xmiId = UML2Util.getXMIIdentifier((InternalEObject)((InternalEObject)element));
        return UMLUtil.setEObjectID(element, xmiId);
    }

    public static String setEObjectID(Element element, String xmiId) {
        XMLResource resource = (XMLResource)element.eResource();
        if (xmiId != null && xmiId.length() > 0) {
            int suffix = 1;
            String firstId = xmiId;
            while (resource.getEObject(xmiId) != null) {
                xmiId = String.valueOf(firstId) + "." + suffix++;
            }
            resource.setID((EObject)element, xmiId);
        }
        return xmiId;
    }

    public static String setEObjectID(Generalization generalization) {
        XMLResource resource = (XMLResource)generalization.eResource();
        StringBuffer xmiId = new StringBuffer();
        xmiId.append(resource.getID((EObject)generalization.getGeneral()));
        xmiId.append("_");
        xmiId.append(resource.getID((EObject)generalization.getSpecific()));
        xmiId.append("_generalization");
        return UMLUtil.setEObjectID((Element)generalization, xmiId.toString());
    }

    public static void setParameterableElement(TemplateParameterSubstitution substitution, ParameterableElement parameterableElement) {
        boolean reflectionCompleted = false;
        try {
            Method getAcuals = TemplateParameterSubstitution.class.getMethod("getActuals", null);
            EList actuals = (EList)getAcuals.invoke((Object)substitution, null);
            reflectionCompleted = true;
            actuals.add((Object)parameterableElement);
        }
        catch (IllegalArgumentException getAcuals) {
        }
        catch (IllegalAccessException getAcuals) {
        }
        catch (InvocationTargetException getAcuals) {
        }
        catch (SecurityException getAcuals) {
        }
        catch (NoSuchMethodException getAcuals) {
            // empty catch block
        }
        if (!reflectionCompleted) {
            try {
                Method setAcual = TemplateParameterSubstitution.class.getMethod("setActual", ParameterableElement.class);
                setAcual.invoke((Object)substitution, parameterableElement);
                reflectionCompleted = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (!reflectionCompleted) {
            throw new RuntimeException(UML2REFLECTIONERROR);
        }
    }

    public static String getAnchorText(NamedElement element) {
        String businessName = NamedElementUtil.getBusinessName(element);
        if (businessName != null && !businessName.isEmpty() && !businessName.equals(element.getName())) {
            return businessName;
        }
        return UMLUtil.splitName(element);
    }

    public static String splitName(NamedElement element) {
        String modelName = element.getName();
        if (modelName != null && modelName.indexOf(32) > 0) {
            return modelName;
        }
        StringBuffer buffer = new StringBuffer();
        for (String token : UMLUtil.splitName(modelName)) {
            buffer.append(buffer.length() > 0 ? " " : "");
            buffer.append(token);
        }
        return buffer.toString();
    }

    public static List<String> splitName(String sourceName) {
        ArrayList<String> result = new ArrayList<String>();
        if (sourceName != null) {
            StringBuilder currentWord = new StringBuilder();
            boolean lastIsLower = false;
            int index = 0;
            int length = sourceName.length();
            while (index < length) {
                char curChar = sourceName.charAt(index);
                if (curChar == '_') {
                    result.add(currentWord.toString());
                    currentWord = new StringBuilder();
                    lastIsLower = false;
                } else if (Character.isUpperCase(curChar) || !lastIsLower && Character.isDigit(curChar)) {
                    if (lastIsLower && currentWord.length() > 1) {
                        result.add(currentWord.toString());
                        currentWord = new StringBuilder();
                    }
                    lastIsLower = false;
                } else {
                    int currentWordLength;
                    if (!lastIsLower && (currentWordLength = currentWord.length()) > 1) {
                        char lastChar = currentWord.charAt(--currentWordLength);
                        currentWord.setLength(currentWordLength);
                        result.add(currentWord.toString());
                        currentWord = new StringBuilder();
                        currentWord.append(lastChar);
                    }
                    lastIsLower = true;
                }
                if (curChar != '_') {
                    currentWord.append(curChar);
                }
                ++index;
            }
            result.add(currentWord.toString());
        }
        return result;
    }

    public static boolean writeProperties(URI uri, Map<String, String> properties) {
        StringBuilder result = new StringBuilder();
        for (String property : properties.values()) {
            result.append(property);
        }
        try {
            OutputStream output = new ExtensibleURIConverterImpl().createOutputStream(uri);
            output.write(result.toString().getBytes(PROPERTIES_ENCODING));
            output.close();
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public static boolean isTypeString(Type type) {
        return type instanceof PrimitiveType && ("EString".equals(type.getName()) || "String".equals(type.getName()));
    }

    public static Property getInheritedProperty(Property property) {
        if (!(property.getOwner() instanceof Classifier)) {
            return null;
        }
        Classifier owner = (Classifier)property.getOwner();
        for (Classifier parent : owner.allParents()) {
            for (Property inherited : parent.getAttributes()) {
                if (!inherited.getName().equals(property.getName())) continue;
                return inherited;
            }
        }
        if (property.getRedefinedProperties().size() == 1) {
            return (Property)property.getRedefinedProperties().get(0);
        }
        if (property.getSubsettedProperties().size() == 1) {
            return (Property)property.getSubsettedProperties().get(0);
        }
        return null;
    }

    public static Property getInheritedProperty(Class childClass, String propertyName) {
        for (Classifier parent : childClass.allParents()) {
            for (Property inherited : parent.getAttributes()) {
                if (!inherited.getName().equals(propertyName)) continue;
                return inherited;
            }
        }
        return null;
    }

    public static class FindResourcesByNameVisitor
    implements IResourceVisitor {
        private String resourceName;
        private ArrayList<IResource> resources = new ArrayList();

        public ArrayList<IResource> getResources() {
            return this.resources;
        }

        public FindResourcesByNameVisitor(String resourceName) {
            this.resourceName = resourceName;
        }

        public boolean visit(IResource arg0) throws CoreException {
            if (this.resourceName != null && this.resourceName.equals(arg0.getName())) {
                this.resources.add(arg0);
            }
            return true;
        }
    }
}

