/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.cda.xml.ui.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mdht.cda.xml.ui.handlers.AnalyzeCDAHandler;
import org.eclipse.mdht.cda.xml.ui.internal.Logger;
import org.eclipse.mdht.cda.xml.ui.views.EntriesView;
import org.eclipse.mdht.cda.xml.ui.views.MetricsView;
import org.eclipse.mdht.cda.xml.ui.views.NarrativeView;
import org.eclipse.mdht.cda.xml.ui.views.ValidationsView;
import org.eclipse.mdht.uml.cda.Act;
import org.eclipse.mdht.uml.cda.ClinicalDocument;
import org.eclipse.mdht.uml.cda.ClinicalStatement;
import org.eclipse.mdht.uml.cda.Component2;
import org.eclipse.mdht.uml.cda.Component3;
import org.eclipse.mdht.uml.cda.Component5;
import org.eclipse.mdht.uml.cda.Encounter;
import org.eclipse.mdht.uml.cda.Entry;
import org.eclipse.mdht.uml.cda.EntryRelationship;
import org.eclipse.mdht.uml.cda.Observation;
import org.eclipse.mdht.uml.cda.Procedure;
import org.eclipse.mdht.uml.cda.RecordTarget;
import org.eclipse.mdht.uml.cda.Section;
import org.eclipse.mdht.uml.cda.StructuredBody;
import org.eclipse.mdht.uml.cda.SubstanceAdministration;
import org.eclipse.mdht.uml.cda.Supply;
import org.eclipse.mdht.uml.cda.util.CDASwitch;
import org.eclipse.mdht.uml.cda.util.CDAUtil;
import org.eclipse.mdht.uml.hl7.datatypes.CD;
import org.eclipse.mdht.uml.hl7.datatypes.ED;
import org.eclipse.mdht.uml.hl7.datatypes.II;
import org.eclipse.mdht.uml.hl7.datatypes.util.DatatypesSwitch;
import org.eclipse.mdht.uml.hl7.datatypes.util.DatatypesUtil;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class CDAAnalyzer2
extends EditorPart {
    public static final String ID = "org.eclipse.mdht.cda.xml.ui.editors.CDAAnalyzer";
    private TableViewer viewer;
    private Table table;
    private final String COMPLETED_COLUMN = "completed";
    private final String DESCRIPTION_COLUMN = "description";
    private final String TOTAL_COLUMN = "total";
    private final String ERRORS_COLUMN = "errors";
    private final String WARNINGS_COLUMN = "warnings";
    private final String INFORMATIONAL_COLUMN = "infos";
    private final String ENTRIES_COLUMN = "entries";
    private String[] columnNames = new String[]{"completed", "description", "entries", "total", "errors", "warnings", "infos"};
    HashMap<Section, CountValidations> validations = new HashMap();
    AnalyzeCDAHandler.CDAAnalaysisInput cdaAnalaysisInput;
    ContentOutlinePage contentOutlinePage = null;
    TreeViewer contentOutlineViewer = null;

    public Table getTable() {
        return this.table;
    }

    private static void handleDiagnostic(Diagnostic diagnostic, CDAUtil.ValidationHandler handler) {
        switch (diagnostic.getSeverity()) {
            case 4: {
                handler.handleError(diagnostic);
                break;
            }
            case 2: {
                handler.handleWarning(diagnostic);
                break;
            }
            case 1: {
                handler.handleInfo(diagnostic);
            }
        }
    }

    private static boolean shouldHandle(Diagnostic diagnostic) {
        return diagnostic.getMessage() != null && !diagnostic.getMessage().startsWith("Diagnosis of");
    }

    private static void processDiagnostic(Diagnostic diagnostic, CDAUtil.ValidationHandler handler) {
        LinkedList<Diagnostic> queue = new LinkedList<Diagnostic>();
        queue.add(diagnostic);
        while (!queue.isEmpty()) {
            Diagnostic d = (Diagnostic)queue.remove();
            if (CDAAnalyzer2.shouldHandle(d)) {
                CDAAnalyzer2.handleDiagnostic(d, handler);
            }
            for (Diagnostic childDiagnostic : d.getChildren()) {
                queue.add(childDiagnostic);
            }
        }
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public void createPartControl(Composite parent) {
        int style = 101124;
        this.table = new Table(parent, style);
        MouseListener listener = new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                int[] selectedIndexes;
                int[] nArray = selectedIndexes = CDAAnalyzer2.this.table.getSelectionIndices();
                int n = selectedIndexes.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    TableItem ti = CDAAnalyzer2.this.table.getItem(i);
                    if (ti.getData() instanceof AnalyzeCDAHandler.CDAAnalaysisInput.CDAMetrics) {
                        AnalyzeCDAHandler.CDAAnalaysisInput.CDAMetrics cdaMetrics = (AnalyzeCDAHandler.CDAAnalaysisInput.CDAMetrics)ti.getData();
                        IWorkbench wb = PlatformUI.getWorkbench();
                        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
                        IWorkbenchPage page = win.getActivePage();
                        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().findEditor(CDAAnalyzer2.ID);
                        try {
                            page.openEditor((IEditorInput)new FileEditorInput(cdaMetrics.file), desc.getId());
                        }
                        catch (PartInitException partInitException) {
                            // empty catch block
                        }
                    }
                    ++n2;
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        };
        this.table.addMouseListener(listener);
        this.viewer = new TableViewer(this.table);
        this.viewer.setUseHashlookup(true);
        this.viewer.setColumnProperties(this.columnNames);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.table, 0x1000000, 0);
        column.setText("!");
        column.setWidth(20);
        column = new TableColumn(this.table, 16384, 1);
        column.setText("File Name");
        column.setWidth(400);
        column = new TableColumn(this.table, 0x1000000, 2);
        column.setText("Errors");
        column.setWidth(100);
        column = new TableColumn(this.table, 0x1000000, 3);
        column.setText("Sections");
        column.setWidth(80);
        column = new TableColumn(this.table, 0x1000000, 4);
        column.setText("Entries");
        column.setWidth(80);
        column = new TableColumn(this.table, 0x1000000, 5);
        column.setText("Clinical Statements");
        column.setWidth(80);
        column = new TableColumn(this.table, 0x1000000, 6);
        column.setText("Coded Elements");
        column.setWidth(80);
        column = new TableColumn(this.table, 0x1000000, 7);
        column.setText("Code Metrics");
        column.setWidth(80);
        CellEditor[] editors = new CellEditor[this.columnNames.length];
        editors[0] = new CheckboxCellEditor((Composite)this.table);
        TextCellEditor textEditor = new TextCellEditor((Composite)this.table, 8);
        ((Text)textEditor.getControl()).setTextLimit(60);
        editors[1] = textEditor;
        textEditor = new TextCellEditor((Composite)this.table);
        editors[3] = textEditor;
        this.viewer.setCellEditors(editors);
        this.viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return false;
            }

            public Object getValue(Object element, String property) {
                return null;
            }

            public void modify(Object element, String property, Object value) {
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setInput((Object)this.getSite());
        try {
            MetricsView metricsView;
            if (this.getSite().getPage().getPerspective() != null && (metricsView = (MetricsView)this.getSite().getPage().showView("org.eclipse.mdht.cda.xml.ui.views.metricsview")) != null) {
                metricsView.addTableListener(this.table);
            }
        }
        catch (PartInitException e) {
            Logger.logException(e);
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
        if (this.table.getSelectionIndex() > -1) {
            Listener[] listenerArray = this.table.getListeners(13);
            int n = listenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Listener listener = listenerArray[n2];
                Event event = new Event();
                event.type = 13;
                event.item = this.table.getItem(this.table.getSelectionIndex());
                event.widget = this.table;
                listener.handleEvent(event);
                ++n2;
            }
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (input instanceof AnalyzeCDAHandler.CDAAnalaysisInput) {
            this.cdaAnalaysisInput = (AnalyzeCDAHandler.CDAAnalaysisInput)input;
        }
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            AnalyzeCDAHandler ach = new AnalyzeCDAHandler();
            if (fileInput.getFile().getParent() instanceof IFolder) {
                IFolder folder = (IFolder)fileInput.getFile().getParent();
                ach.codeMetricsFile = folder.getFile("codemetrics.cfg");
            } else {
                ach.codeMetricsFile = null;
            }
            this.cdaAnalaysisInput = new AnalyzeCDAHandler.CDAAnalaysisInput();
            this.cdaAnalaysisInput.getMetrics().add(ach.analyzePluginMode(fileInput.getFile()));
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.getContentOutlinePage();
        }
        return super.getAdapter(key);
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                GetChildrenSwitch gcs;
                HasChildrenSwitch hcs;
                DataTypeHasChildren dcs;
                DatatypesGetChildrenSwitch dgcs;

                MyContentOutlinePage() {
                    this.gcs = new GetChildrenSwitch();
                    this.hcs = new HasChildrenSwitch();
                    this.dcs = new DataTypeHasChildren();
                    this.dgcs = new DatatypesGetChildrenSwitch();
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    CDAAnalyzer2.this.contentOutlineViewer = this.getTreeViewer();
                    CDAAnalyzer2.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    ITreeContentProvider xxx = new ITreeContentProvider(){

                        public void dispose() {
                        }

                        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                        }

                        public Object[] getElements(Object inputElement) {
                            ArrayList<EObject> elements = new ArrayList<EObject>();
                            if (inputElement instanceof ClinicalDocument) {
                                ClinicalDocument doc = (ClinicalDocument)inputElement;
                                elements.addAll(EcoreUtil.copyAll((Collection)doc.getRecordTargets()));
                                elements.addAll(EcoreUtil.copyAll((Collection)doc.getAuthors()));
                                elements.add(EcoreUtil.copy((EObject)doc.getComponent()));
                            }
                            return elements.toArray();
                        }

                        public Object[] getChildren(Object parentElement) {
                            if (parentElement instanceof EObject) {
                                EObject eObject = (EObject)parentElement;
                                if ("http://www.openhealthtools.org/mdht/uml/hl7/datatypes".equals(eObject.eClass().getEPackage().getNsURI())) {
                                    return ((ArrayList)dgcs.doSwitch(eObject)).toArray();
                                }
                                return ((ArrayList)gcs.doSwitch(eObject)).toArray();
                            }
                            return null;
                        }

                        public Object getParent(Object element) {
                            return null;
                        }

                        public boolean hasChildren(Object element) {
                            if (element instanceof EObject) {
                                EObject eObject = (EObject)element;
                                if ("http://www.openhealthtools.org/mdht/uml/hl7/datatypes".equals(eObject.eClass().getEPackage().getNsURI())) {
                                    return (Boolean)dcs.doSwitch(eObject);
                                }
                                return (Boolean)hcs.doSwitch((EObject)element);
                            }
                            return false;
                        }
                    };
                    CDAAnalyzer2.this.contentOutlineViewer.setContentProvider((IContentProvider)xxx);
                    ILabelProvider yyy = new ILabelProvider(){

                        public void addListener(ILabelProviderListener listener) {
                        }

                        public void dispose() {
                        }

                        public boolean isLabelProperty(Object element, String property) {
                            return false;
                        }

                        public void removeListener(ILabelProviderListener listener) {
                        }

                        public Image getImage(Object element) {
                            return null;
                        }

                        public String getText(Object element) {
                            if (element instanceof EObject) {
                                EObject eObject = (EObject)element;
                                if (eObject.eContainingFeature() != null) {
                                    return ((EObject)element).eContainingFeature().getName();
                                }
                                return ((EObject)element).eClass().getName();
                            }
                            return element.toString();
                        }
                    };
                    CDAAnalyzer2.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)yyy);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
        }
        return this.contentOutlinePage;
    }

    public void dispose() {
        NarrativeView narrativeView;
        ValidationsView validationsView;
        super.dispose();
        EntriesView entriesView = (EntriesView)this.getSite().getPage().findView("org.eclipse.mdht.cda.xml.ui.views.entriesview");
        if (entriesView != null) {
            entriesView.clearView();
        }
        if ((validationsView = (ValidationsView)this.getSite().getPage().findView("org.eclipse.mdht.cda.xml.ui.views.validationsview")) != null) {
            validationsView.clearView();
        }
        if ((narrativeView = (NarrativeView)this.getSite().getPage().findView("org.eclipse.mdht.cda.xml.ui.views.narrativeview")) != null) {
            narrativeView.clearView();
        }
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor() != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().setFocus();
        }
    }

    class CountValidations
    implements CDAUtil.ValidationHandler {
        private int errors = 0;
        private int warnings = 0;
        private int informational = 0;

        CountValidations() {
        }

        public int getTotal() {
            return this.errors + this.warnings + this.informational;
        }

        public int getErrors() {
            return this.errors;
        }

        public int getWarnings() {
            return this.warnings;
        }

        public int getInformational() {
            return this.informational;
        }

        public void handleError(Diagnostic diagnostic) {
            ++this.errors;
        }

        public void handleWarning(Diagnostic diagnostic) {
            ++this.warnings;
        }

        public void handleInfo(Diagnostic diagnostic) {
            ++this.informational;
        }

        public boolean isCaptureValidationStatistics() {
            return false;
        }

        public DatatypesUtil.ValidationStatistics getValidationStatistics() {
            return null;
        }

        public void setValidationStatistics(DatatypesUtil.ValidationStatistics validationStatistics) {
        }
    }

    public class DataTypeHasChildren
    extends DatatypesSwitch<Boolean> {
        public Boolean caseII(II object) {
            return Boolean.TRUE;
        }

        public Boolean caseCD(CD object) {
            return Boolean.TRUE;
        }

        public Boolean defaultCase(EObject object) {
            return Boolean.FALSE;
        }
    }

    public class DatatypesGetChildrenSwitch
    extends DatatypesSwitch<ArrayList<Object>> {
        public ArrayList<Object> caseED(ED object) {
            return (ArrayList)super.caseED(object);
        }

        public ArrayList<Object> caseCD(CD object) {
            ArrayList<Object> elements = new ArrayList<Object>();
            if (object.getCode() != null) {
                elements.add(object.getCode());
            }
            if (object.getDisplayName() != null) {
                elements.add(object.getDisplayName());
            }
            if (object.getOriginalText() != null) {
                elements.add(object.getOriginalText());
            }
            if (object.getCodeSystemName() != null) {
                elements.add(object.getCodeSystemName());
            }
            if (object.getCodeSystem() != null) {
                elements.add(object.getCodeSystem());
            }
            if (object.getQualifiers() != null) {
                elements.addAll((Collection<Object>)object.getQualifiers());
            }
            if (object.getTranslations() != null) {
                elements.addAll((Collection<Object>)object.getTranslations());
            }
            return elements;
        }

        public ArrayList<Object> caseII(II object) {
            ArrayList<Object> elements = new ArrayList<Object>();
            if (object.getExtension() != null) {
                elements.add(object.getExtension());
            }
            if (object.getRoot() != null) {
                elements.add(object.getRoot());
            }
            return elements;
        }

        public ArrayList<Object> defaultCase(EObject object) {
            return new ArrayList<Object>();
        }
    }

    public class GetChildrenSwitch
    extends CDASwitch<ArrayList<Object>> {
        public ArrayList<Object> caseEntryRelationship(EntryRelationship object) {
            ArrayList<Object> elements = new ArrayList<Object>();
            if (object.getAct() != null) {
                elements.add(EcoreUtil.copy((EObject)object.getAct()));
            }
            if (object.getEncounter() != null) {
                elements.add(EcoreUtil.copy((EObject)object.getEncounter()));
            }
            if (object.getObservation() != null) {
                elements.add(EcoreUtil.copy((EObject)object.getObservation()));
            }
            if (object.getObservationMedia() != null) {
                elements.add(EcoreUtil.copy((EObject)object.getObservationMedia()));
            }
            if (object.getOrganizer() != null) {
                elements.add(EcoreUtil.copy((EObject)object.getOrganizer()));
            }
            if (object.getProcedure() != null) {
                elements.add(EcoreUtil.copy((EObject)object.getProcedure()));
            }
            if (object.getSubstanceAdministration() != null) {
                elements.add(EcoreUtil.copy((EObject)object.getSubstanceAdministration()));
            }
            if (object.getSupply() != null) {
                elements.add(EcoreUtil.copy((EObject)object.getSupply()));
            }
            return elements;
        }

        public ArrayList<Object> caseAct(Act object) {
            ArrayList<Object> elements = new ArrayList<Object>();
            if (object.getRealmCodes() != null) {
                elements.add(object.getRealmCodes());
            }
            if (object.getTypeId() != null) {
                elements.add(object.getTypeId());
            }
            if (object.getTemplateIds() != null) {
                elements.addAll((Collection<Object>)object.getTemplateIds());
            }
            if (object.getIds() != null) {
                elements.addAll((Collection<Object>)object.getIds());
            }
            if (object.getCode() != null) {
                elements.add(object.getCode());
            }
            if (object.getText() != null) {
                elements.add(object.getText());
            }
            if (object.getStatusCode() != null) {
                elements.add(object.getStatusCode());
            }
            if (object.getEffectiveTime() != null) {
                elements.add(object.getEffectiveTime());
            }
            if (object.getPriorityCode() != null) {
                elements.add(object.getPriorityCode());
            }
            if (object.getLanguageCode() != null) {
                elements.add(object.getLanguageCode());
            }
            if (object.getClassCode() != null) {
                elements.add(object.getClassCode());
            }
            if (object.getMoodCode() != null) {
                elements.add(object.getMoodCode());
            }
            if (object.getNegationInd() != null) {
                elements.add(object.getNegationInd());
            }
            if (object.getSubject() != null) {
                elements.add(object.getSubject());
            }
            if (object.getSpecimens() != null) {
                elements.addAll((Collection<Object>)object.getSpecimens());
            }
            if (object.getPerformers() != null) {
                elements.addAll((Collection<Object>)object.getPerformers());
            }
            if (object.getAuthors() != null) {
                elements.addAll((Collection<Object>)object.getAuthors());
            }
            if (object.getInformants() != null) {
                elements.addAll((Collection<Object>)object.getInformants());
            }
            if (object.getParticipants() != null) {
                elements.addAll((Collection<Object>)object.getParticipants());
            }
            if (object.getReferences() != null) {
                elements.addAll((Collection<Object>)object.getReferences());
            }
            if (object.getPreconditions() != null) {
                elements.addAll((Collection<Object>)object.getPreconditions());
            }
            if (object.getEntryRelationships() != null) {
                elements.addAll((Collection<Object>)object.getEntryRelationships());
            }
            return elements;
        }

        public ArrayList<Object> caseEncounter(Encounter object) {
            ArrayList<Object> elements = new ArrayList<Object>();
            if (object.getRealmCodes() != null) {
                elements.add(object.getRealmCodes());
            }
            if (object.getTypeId() != null) {
                elements.add(object.getTypeId());
            }
            if (object.getTemplateIds() != null) {
                elements.addAll((Collection<Object>)object.getTemplateIds());
            }
            if (object.getIds() != null) {
                elements.addAll((Collection<Object>)object.getIds());
            }
            if (object.getCode() != null) {
                elements.add(object.getCode());
            }
            if (object.getText() != null) {
                elements.add(object.getText());
            }
            if (object.getStatusCode() != null) {
                elements.add(object.getStatusCode());
            }
            if (object.getEffectiveTime() != null) {
                elements.add(object.getEffectiveTime());
            }
            if (object.getPriorityCode() != null) {
                elements.add(object.getPriorityCode());
            }
            if (object.getClassCode() != null) {
                elements.add(object.getClassCode());
            }
            if (object.getMoodCode() != null) {
                elements.add(object.getMoodCode());
            }
            if (object.getNegationInd() != null) {
                elements.add(object.getNegationInd());
            }
            if (object.getSubject() != null) {
                elements.add(object.getSubject());
            }
            if (object.getSpecimens() != null) {
                elements.addAll((Collection<Object>)object.getSpecimens());
            }
            if (object.getPerformers() != null) {
                elements.addAll((Collection<Object>)object.getPerformers());
            }
            if (object.getAuthors() != null) {
                elements.addAll((Collection<Object>)object.getAuthors());
            }
            if (object.getInformants() != null) {
                elements.addAll((Collection<Object>)object.getInformants());
            }
            if (object.getParticipants() != null) {
                elements.addAll((Collection<Object>)object.getParticipants());
            }
            if (object.getReferences() != null) {
                elements.addAll((Collection<Object>)object.getReferences());
            }
            if (object.getPreconditions() != null) {
                elements.addAll((Collection<Object>)object.getPreconditions());
            }
            if (object.getEntryRelationships() != null) {
                elements.addAll((Collection<Object>)object.getEntryRelationships());
            }
            return elements;
        }

        public ArrayList<Object> caseSupply(Supply object) {
            ArrayList<Object> elements = new ArrayList<Object>();
            if (object.getRealmCodes() != null) {
                elements.add(object.getRealmCodes());
            }
            if (object.getTypeId() != null) {
                elements.add(object.getTypeId());
            }
            if (object.getTemplateIds() != null) {
                elements.addAll((Collection<Object>)object.getTemplateIds());
            }
            if (object.getIds() != null) {
                elements.addAll((Collection<Object>)object.getIds());
            }
            if (object.getCode() != null) {
                elements.add(object.getCode());
            }
            if (object.getText() != null) {
                elements.add(object.getText());
            }
            if (object.getStatusCode() != null) {
                elements.add(object.getStatusCode());
            }
            if (object.getClassCode() != null) {
                elements.add(object.getClassCode());
            }
            if (object.getMoodCode() != null) {
                elements.add(object.getMoodCode());
            }
            if (object.getNegationInd() != null) {
                elements.add(object.getNegationInd());
            }
            if (object.getSpecimens() != null) {
                elements.addAll((Collection<Object>)object.getSpecimens());
            }
            if (object.getSubject() != null) {
                elements.add(object.getSubject());
            }
            if (object.getSpecimens() != null) {
                elements.addAll((Collection<Object>)object.getSpecimens());
            }
            if (object.getPerformers() != null) {
                elements.addAll((Collection<Object>)object.getPerformers());
            }
            if (object.getAuthors() != null) {
                elements.addAll((Collection<Object>)object.getAuthors());
            }
            if (object.getInformants() != null) {
                elements.addAll((Collection<Object>)object.getInformants());
            }
            if (object.getParticipants() != null) {
                elements.addAll((Collection<Object>)object.getParticipants());
            }
            if (object.getReferences() != null) {
                elements.addAll((Collection<Object>)object.getReferences());
            }
            if (object.getPreconditions() != null) {
                elements.addAll((Collection<Object>)object.getPreconditions());
            }
            if (object.getEntryRelationships() != null) {
                elements.addAll((Collection<Object>)object.getEntryRelationships());
            }
            return elements;
        }

        public ArrayList<Object> caseProcedure(Procedure object) {
            ArrayList<Object> elements = new ArrayList<Object>();
            if (object.getRealmCodes() != null) {
                elements.add(object.getRealmCodes());
            }
            if (object.getTypeId() != null) {
                elements.add(object.getTypeId());
            }
            if (object.getTemplateIds() != null) {
                elements.addAll((Collection<Object>)object.getTemplateIds());
            }
            if (object.getIds() != null) {
                elements.addAll((Collection<Object>)object.getIds());
            }
            if (object.getCode() != null) {
                elements.add(object.getCode());
            }
            if (object.getText() != null) {
                elements.add(object.getText());
            }
            if (object.getStatusCode() != null) {
                elements.add(object.getStatusCode());
            }
            if (object.getClassCode() != null) {
                elements.add(object.getClassCode());
            }
            if (object.getMoodCode() != null) {
                elements.add(object.getMoodCode());
            }
            if (object.getNegationInd() != null) {
                elements.add(object.getNegationInd());
            }
            if (object.getSpecimens() != null) {
                elements.addAll((Collection<Object>)object.getSpecimens());
            }
            if (object.getSubject() != null) {
                elements.add(object.getSubject());
            }
            if (object.getSpecimens() != null) {
                elements.addAll((Collection<Object>)object.getSpecimens());
            }
            if (object.getPerformers() != null) {
                elements.addAll((Collection<Object>)object.getPerformers());
            }
            if (object.getAuthors() != null) {
                elements.addAll((Collection<Object>)object.getAuthors());
            }
            if (object.getInformants() != null) {
                elements.addAll((Collection<Object>)object.getInformants());
            }
            if (object.getParticipants() != null) {
                elements.addAll((Collection<Object>)object.getParticipants());
            }
            if (object.getReferences() != null) {
                elements.addAll((Collection<Object>)object.getReferences());
            }
            if (object.getPreconditions() != null) {
                elements.addAll((Collection<Object>)object.getPreconditions());
            }
            if (object.getEntryRelationships() != null) {
                elements.addAll((Collection<Object>)object.getEntryRelationships());
            }
            return elements;
        }

        public ArrayList<Object> caseSubstanceAdministration(SubstanceAdministration object) {
            ArrayList<Object> elements = new ArrayList<Object>();
            if (object.getRealmCodes() != null) {
                elements.add(object.getRealmCodes());
            }
            if (object.getTypeId() != null) {
                elements.add(object.getTypeId());
            }
            if (object.getTemplateIds() != null) {
                elements.addAll((Collection<Object>)object.getTemplateIds());
            }
            if (object.getIds() != null) {
                elements.addAll((Collection<Object>)object.getIds());
            }
            if (object.getCode() != null) {
                elements.add(object.getCode());
            }
            if (object.getText() != null) {
                elements.add(object.getText());
            }
            if (object.getStatusCode() != null) {
                elements.add(object.getStatusCode());
            }
            if (object.getPriorityCode() != null) {
                elements.add(object.getPriorityCode());
            }
            if (object.getClassCode() != null) {
                elements.add(object.getClassCode());
            }
            if (object.getMoodCode() != null) {
                elements.add(object.getMoodCode());
            }
            if (object.getNegationInd() != null) {
                elements.add(object.getNegationInd());
            }
            if (object.getSpecimens() != null) {
                elements.addAll((Collection<Object>)object.getSpecimens());
            }
            if (object.getConsumable() != null) {
                elements.add(object.getConsumable());
            }
            if (object.getSubject() != null) {
                elements.add(object.getSubject());
            }
            if (object.getSpecimens() != null) {
                elements.addAll((Collection<Object>)object.getSpecimens());
            }
            if (object.getPerformers() != null) {
                elements.addAll((Collection<Object>)object.getPerformers());
            }
            if (object.getAuthors() != null) {
                elements.addAll((Collection<Object>)object.getAuthors());
            }
            if (object.getInformants() != null) {
                elements.addAll((Collection<Object>)object.getInformants());
            }
            if (object.getParticipants() != null) {
                elements.addAll((Collection<Object>)object.getParticipants());
            }
            if (object.getReferences() != null) {
                elements.addAll((Collection<Object>)object.getReferences());
            }
            if (object.getPreconditions() != null) {
                elements.addAll((Collection<Object>)object.getPreconditions());
            }
            if (object.getEntryRelationships() != null) {
                elements.addAll((Collection<Object>)object.getEntryRelationships());
            }
            return elements;
        }

        public ArrayList<Object> caseComponent5(Component5 object) {
            return (ArrayList)super.caseComponent5(object);
        }

        public ArrayList<Object> caseSection(Section object) {
            ArrayList<Object> elements = new ArrayList<Object>();
            elements.addAll(EcoreUtil.copyAll((Collection)object.getEntries()));
            return elements;
        }

        public ArrayList<Object> caseComponent2(Component2 object) {
            ArrayList<Object> elements = new ArrayList<Object>();
            elements.add(EcoreUtil.copy((EObject)object.getStructuredBody()));
            return elements;
        }

        public ArrayList<Object> caseRecordTarget(RecordTarget object) {
            ArrayList<Object> elements = new ArrayList<Object>();
            elements.add(EcoreUtil.copy((EObject)object.getPatientRole()));
            return elements;
        }

        public ArrayList<Object> caseStructuredBody(StructuredBody object) {
            ArrayList<Object> elements = new ArrayList<Object>();
            elements.addAll(EcoreUtil.copyAll((Collection)object.getComponents()));
            return elements;
        }

        public ArrayList<Object> caseComponent3(Component3 object) {
            ArrayList<Object> elements = new ArrayList<Object>();
            elements.add(EcoreUtil.copy((EObject)object.getSection()));
            return elements;
        }

        public ArrayList<Object> caseObservation(Observation object) {
            ArrayList<Object> elements = new ArrayList<Object>();
            if (object.getRealmCodes() != null) {
                elements.add(object.getRealmCodes());
            }
            if (object.getTypeId() != null) {
                elements.add(object.getTypeId());
            }
            if (object.getTemplateIds() != null) {
                elements.addAll((Collection<Object>)object.getTemplateIds());
            }
            if (object.getIds() != null) {
                elements.addAll((Collection<Object>)object.getIds());
            }
            if (object.getCode() != null) {
                elements.add(object.getCode());
            }
            if (object.getText() != null) {
                elements.add(object.getText());
            }
            if (object.getStatusCode() != null) {
                elements.add(object.getStatusCode());
            }
            if (object.getEffectiveTime() != null) {
                elements.add(object.getEffectiveTime());
            }
            if (object.getPriorityCode() != null) {
                elements.add(object.getPriorityCode());
            }
            if (object.getLanguageCode() != null) {
                elements.add(object.getLanguageCode());
            }
            if (object.getClassCode() != null) {
                elements.add(object.getClassCode());
            }
            if (object.getMoodCode() != null) {
                elements.add(object.getMoodCode());
            }
            if (object.getNegationInd() != null) {
                elements.add(object.getNegationInd());
            }
            if (object.getSubject() != null) {
                elements.add(object.getSubject());
            }
            if (object.getSpecimens() != null) {
                elements.addAll((Collection<Object>)object.getSpecimens());
            }
            if (object.getPerformers() != null) {
                elements.addAll((Collection<Object>)object.getPerformers());
            }
            if (object.getAuthors() != null) {
                elements.addAll((Collection<Object>)object.getAuthors());
            }
            if (object.getInformants() != null) {
                elements.addAll((Collection<Object>)object.getInformants());
            }
            if (object.getParticipants() != null) {
                elements.addAll((Collection<Object>)object.getParticipants());
            }
            if (object.getReferences() != null) {
                elements.addAll((Collection<Object>)object.getReferences());
            }
            if (object.getPreconditions() != null) {
                elements.addAll((Collection<Object>)object.getPreconditions());
            }
            if (object.getEntryRelationships() != null) {
                elements.addAll((Collection<Object>)object.getEntryRelationships());
            }
            if (object.getReferenceRanges() != null) {
                elements.addAll((Collection<Object>)object.getReferenceRanges());
            }
            return elements;
        }

        public ArrayList<Object> caseEntry(Entry object) {
            ArrayList<Object> elements = new ArrayList<Object>();
            if (object.getAct() != null) {
                elements.add(EcoreUtil.copy((EObject)object.getAct()));
            }
            if (object.getEncounter() != null) {
                elements.add(EcoreUtil.copy((EObject)object.getEncounter()));
            }
            if (object.getObservation() != null) {
                elements.add(EcoreUtil.copy((EObject)object.getObservation()));
            }
            if (object.getObservationMedia() != null) {
                elements.add(EcoreUtil.copy((EObject)object.getObservationMedia()));
            }
            if (object.getOrganizer() != null) {
                elements.add(EcoreUtil.copy((EObject)object.getOrganizer()));
            }
            if (object.getProcedure() != null) {
                elements.add(EcoreUtil.copy((EObject)object.getProcedure()));
            }
            if (object.getSubstanceAdministration() != null) {
                elements.add(EcoreUtil.copy((EObject)object.getSubstanceAdministration()));
            }
            if (object.getSupply() != null) {
                elements.add(EcoreUtil.copy((EObject)object.getSupply()));
            }
            return elements;
        }

        public ArrayList<Object> defaultCase(EObject object) {
            return new ArrayList<Object>();
        }
    }

    public class HasChildrenSwitch
    extends CDASwitch<Boolean> {
        public Boolean caseComponent3(Component3 object) {
            return Boolean.TRUE;
        }

        public Boolean caseStructuredBody(StructuredBody object) {
            return Boolean.TRUE;
        }

        public Boolean caseClinicalDocument(ClinicalDocument object) {
            return Boolean.TRUE;
        }

        public Boolean caseComponent2(Component2 object) {
            return Boolean.TRUE;
        }

        public Boolean caseRecordTarget(RecordTarget object) {
            return Boolean.TRUE;
        }

        public Boolean caseSection(Section object) {
            return Boolean.TRUE;
        }

        public Boolean defaultCase(EObject object) {
            return Boolean.FALSE;
        }

        public Boolean caseEntry(Entry object) {
            return Boolean.TRUE;
        }

        public Boolean caseClinicalStatement(ClinicalStatement object) {
            return Boolean.TRUE;
        }

        public Boolean caseEntryRelationship(EntryRelationship object) {
            return Boolean.TRUE;
        }
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof String) {
                return -1;
            }
            return super.compare(viewer, e1, e2);
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            ArrayList<AnalyzeCDAHandler.CDAAnalaysisInput.CDAMetrics> r = new ArrayList<AnalyzeCDAHandler.CDAAnalaysisInput.CDAMetrics>();
            r.addAll(CDAAnalyzer2.this.cdaAnalaysisInput.getMetrics());
            return r.toArray();
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof AnalyzeCDAHandler.CDAAnalaysisInput.CDAMetrics) {
                AnalyzeCDAHandler.CDAAnalaysisInput.CDAMetrics cdaMetrics = (AnalyzeCDAHandler.CDAAnalaysisInput.CDAMetrics)obj;
                switch (index) {
                    case 0: {
                        if (cdaMetrics.totalErrors > 0) {
                            return "X";
                        }
                        return "";
                    }
                    case 1: {
                        return cdaMetrics.fileName;
                    }
                    case 2: {
                        return Integer.toString(cdaMetrics.totalErrors);
                    }
                    case 3: {
                        return Integer.toString(cdaMetrics.totalSections);
                    }
                    case 4: {
                        return Integer.toString(cdaMetrics.totalEntries);
                    }
                    case 5: {
                        return Integer.toString(cdaMetrics.totalClinicalStatements);
                    }
                    case 6: {
                        return Integer.toString(cdaMetrics.totalCodedElements);
                    }
                    case 7: {
                        return String.valueOf(Integer.toString(cdaMetrics.totalCodedMetrics)) + " out of " + Integer.toString(cdaMetrics.codedMetricsCount);
                    }
                }
            }
            return "xxx";
        }

        public Image getImage(Object obj) {
            if (obj instanceof Section) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD");
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

