/*
 * Decompiled with CFR 0.152.
 */
package traceability.presentation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import traceability.presentation.ReuseURIEditorInputSupportingLinkWithEditor;

public class ReuseURIEditorInput
extends URIEditorInput {
    private ResourceSet resourceSet;

    public ReuseURIEditorInput(Resource resource) {
        super(resource.getURI());
        this.resourceSet = resource.getResourceSet();
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public static URIEditorInput create(Resource resource) {
        String path = resource.getURI().toPlatformString(true);
        IResource workspaceResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
        if (workspaceResource instanceof IFile) {
            IFile iFile = (IFile)workspaceResource;
            return new ReuseURIEditorInputSupportingLinkWithEditor(resource, iFile);
        }
        return new ReuseURIEditorInput(resource);
    }
}

