/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.operations;

import java.util.Stack;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.mdht.uml.cda.StrucDocText;
import org.eclipse.ocl.ecore.OCL;

public class StrucDocTextOperations {
    protected static final ThreadLocal<OCL> EOCL_ENV = new ThreadLocal<OCL>(){

        @Override
        public OCL initialValue() {
            return OCL.newInstance();
        }
    };

    protected StrucDocTextOperations() {
    }

    public static void addText(StrucDocText strucDocText, String text) {
        if (text == null) {
            throw new IllegalArgumentException("text is null");
        }
        FeatureMapUtil.addText((FeatureMap)strucDocText.getMixed(), (String)text);
    }

    public static String getText(StrucDocText strucDocText) {
        return StrucDocTextOperations.getText(strucDocText.getMixed());
    }

    public static String getText(StrucDocText strucDocText, String id) {
        String attributeValue = strucDocText.getID();
        if (attributeValue != null && attributeValue.equals(id)) {
            return StrucDocTextOperations.getText(strucDocText.getMixed());
        }
        return StrucDocTextOperations.getText(strucDocText.getMixed(), id);
    }

    private static String getText(FeatureMap root, String id) {
        Stack<FeatureMap> stack = new Stack<FeatureMap>();
        stack.push(root);
        while (!stack.isEmpty()) {
            FeatureMap featureMap = (FeatureMap)stack.pop();
            for (FeatureMap.Entry entry : featureMap) {
                if (!(entry.getEStructuralFeature() instanceof EReference)) continue;
                AnyType anyType = (AnyType)entry.getValue();
                String attributeValue = StrucDocTextOperations.getAttributeValue(anyType.getAnyAttribute(), "ID");
                if (attributeValue != null && attributeValue.equals(id)) {
                    return StrucDocTextOperations.getText(anyType.getMixed());
                }
                stack.push(anyType.getMixed());
            }
        }
        return null;
    }

    public static String getAttributeValue(FeatureMap featureMap, String name) {
        for (FeatureMap.Entry entry : featureMap) {
            EStructuralFeature feature = entry.getEStructuralFeature();
            if (!(feature instanceof EAttribute) || !feature.getName().equals(name)) continue;
            return entry.getValue().toString();
        }
        return null;
    }

    public static String getText(FeatureMap featureMap) {
        StringBuffer buffer = new StringBuffer("");
        int i = 0;
        int size = featureMap.size();
        while (i < size) {
            EStructuralFeature feature = featureMap.getEStructuralFeature(i);
            if (FeatureMapUtil.isText((EStructuralFeature)feature)) {
                if (buffer.length() > 0) {
                    buffer.append(" ");
                }
                buffer.append(featureMap.getValue(i).toString());
            } else if (FeatureMapUtil.isComment((EStructuralFeature)feature)) {
                if (buffer.length() > 0) {
                    buffer.append(" ");
                }
                buffer.append(featureMap.getValue(i).toString());
            } else if (FeatureMapUtil.isCDATA((EStructuralFeature)feature)) {
                buffer.append(featureMap.getValue(i).toString());
                if (buffer.length() > 0) {
                    buffer.append(" ");
                }
            } else if (feature instanceof EReference) {
                buffer.append("<" + feature.getName() + ">" + StrucDocTextOperations.getText(((AnyType)featureMap.getValue(i)).getMixed()) + "</" + feature.getName() + ">");
            }
            ++i;
        }
        return buffer.toString();
    }
}

