/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.mdht.uml.cda.ActReference;
import org.eclipse.mdht.uml.cda.CDAFactory;
import org.eclipse.mdht.uml.cda.ClinicalDocument;
import org.eclipse.mdht.uml.cda.Component4;
import org.eclipse.mdht.uml.cda.Encounter;
import org.eclipse.mdht.uml.cda.Entry;
import org.eclipse.mdht.uml.cda.InFulfillmentOf1;
import org.eclipse.mdht.uml.cda.Section;
import org.eclipse.mdht.uml.cda.util.CDAUtil;
import org.eclipse.mdht.uml.hl7.datatypes.CE;
import org.eclipse.mdht.uml.hl7.datatypes.DatatypesFactory;
import org.eclipse.mdht.uml.hl7.vocab.ActRelationshipFulfills;
import org.eclipse.mdht.uml.hl7.vocab.EntityDeterminer;

public class Main2 {
    public static void saveData(String fileName, ClinicalDocument data) throws IOException {
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("*", new XMLResourceFactoryImpl());
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource resource = resSet.createResource(URI.createFileURI((String)fileName));
        resource.getContents().add((Object)data);
        resource.save(Collections.EMPTY_MAP);
    }

    public static ClinicalDocument loadData(String fileName) throws FileNotFoundException, IOException {
        XMLResourceImpl resource = new XMLResourceImpl();
        File source = new File(fileName);
        resource.load((InputStream)new FileInputStream(source), new HashMap());
        ClinicalDocument data = (ClinicalDocument)resource.getContents().get(0);
        return data;
    }

    public static void main(String[] args) throws Exception {
        ClinicalDocument doc = CDAFactory.eINSTANCE.createClinicalDocument();
        Section section = CDAFactory.eINSTANCE.createSection();
        doc.addSection(section);
        Encounter encounter = CDAFactory.eINSTANCE.createEncounter();
        encounter.setEffectiveTime(DatatypesFactory.eINSTANCE.createIVL_TS());
        encounter.getSDTCDischargeDispositionCodes().add((Object)DatatypesFactory.eINSTANCE.createCE("1", "1"));
        encounter.getSDTCDischargeDispositionCodes().add((Object)DatatypesFactory.eINSTANCE.createCE("2", "1"));
        encounter.getSDTCDischargeDispositionCodes().add((Object)DatatypesFactory.eINSTANCE.createCE("3", "1"));
        encounter.getSDTCDischargeDispositionCodes().add((Object)DatatypesFactory.eINSTANCE.createCE("4", "1"));
        encounter.getSDTCDischargeDispositionCodes().add((Object)DatatypesFactory.eINSTANCE.createCE("5", "1"));
        encounter.getSDTCDischargeDispositionCodes().add((Object)DatatypesFactory.eINSTANCE.createCE("6", "1"));
        InFulfillmentOf1 ff = CDAFactory.eINSTANCE.createInFulfillmentOf1();
        ActReference ar = CDAFactory.eINSTANCE.createActReference();
        ar.setDeterminerCode(EntityDeterminer.INSTANCE);
        ar.getIds().add((Object)DatatypesFactory.eINSTANCE.createII("aaa", "bbb"));
        ff.setTypeCode(ActRelationshipFulfills.FLFS);
        ff.setTypeId(CDAFactory.eINSTANCE.createInfrastructureRootTypeId());
        ff.setActReference(ar);
        encounter.getInFulfillmentOf1s().add((Object)ff);
        encounter.getInFulfillmentOf1s().add((Object)CDAFactory.eINSTANCE.createInFulfillmentOf1());
        encounter.getInFulfillmentOf1s().add((Object)CDAFactory.eINSTANCE.createInFulfillmentOf1());
        encounter.getInFulfillmentOf1s().add((Object)CDAFactory.eINSTANCE.createInFulfillmentOf1());
        encounter.getInFulfillmentOf1s().add((Object)CDAFactory.eINSTANCE.createInFulfillmentOf1());
        encounter.setPriorityCode(DatatypesFactory.eINSTANCE.createCE());
        section.addEncounter(encounter);
        CDAUtil.save(doc, new FileOutputStream("samples/foobar2.xml"));
        ClinicalDocument clinicalDocument = CDAUtil.load(new FileInputStream("samples/foobar2.xml"));
        for (Section s : clinicalDocument.getSections()) {
            for (Entry e : s.getEntries()) {
                if (e.getEncounter() == null) continue;
                for (CE ce : e.getEncounter().getSDTCDischargeDispositionCodes()) {
                    System.out.println(ce.getCode());
                }
            }
        }
        CDAUtil.save(clinicalDocument, new FileOutputStream("samples/foobar3.xml"));
        Component4 c4 = CDAFactory.eINSTANCE.createComponent4();
        c4.setPriorityNumber(DatatypesFactory.eINSTANCE.createINT());
        CDAUtil.saveSnippet((EObject)c4, System.out);
    }
}

