/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.action;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.action.CommandActionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ControlAction
extends CommandActionHandler {
    protected IStructuredSelection selection = null;
    protected EObject eObject = null;

    public ControlAction(EditingDomain domain) {
        super(domain, EMFEditUIPlugin.INSTANCE.getString("_UI_Control_menu_item"));
    }

    public ControlAction() {
        this(null);
    }

    public boolean updateSelection(IStructuredSelection selection) {
        this.selection = selection;
        if (selection.size() != 1) {
            return false;
        }
        Object object = AdapterFactoryEditingDomain.unwrap((Object)selection.getFirstElement());
        boolean result = this.domain.isControllable(object);
        EObject eObject = this.eObject = result ? (EObject)object : null;
        if (!AdapterFactoryEditingDomain.isControlled((Object)object)) {
            this.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Control_menu_item"));
            this.setDescription("_UI_Control_menu_item_description");
            this.command = null;
        } else {
            this.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Uncontrol_menu_item"));
            this.setDescription("_UI_Uncontrol_menu_item_description");
            if (result) {
                this.command = new RemoveCommand(this.domain, this.eObject.eResource().getContents(), (Object)this.eObject);
                this.command = new SelfAffectingCommand(EMFEditUIPlugin.INSTANCE.getString("_UI_UncontrolCommand_label"), this.command);
                result = this.command.canExecute();
            }
        }
        return result;
    }

    public void run() {
        if (this.command == null) {
            if (this.eObject == null) {
                return;
            }
            ControlResourceDialog dialog = new ControlResourceDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.domain, this.eObject.eResource());
            dialog.open();
            Resource resource = dialog.getResource();
            if (resource == null) {
                return;
            }
            this.command = new AddCommand(this.domain, resource.getContents(), (Object)this.eObject);
            this.command = new SelfAffectingCommand(EMFEditUIPlugin.INSTANCE.getString("_UI_ControlCommand_label"), this.command);
        }
        EcoreUtil.resolveAll((ResourceSet)this.domain.getResourceSet());
        super.run();
    }

    public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
        if (workbenchPart instanceof IEditingDomainProvider) {
            this.domain = ((IEditingDomainProvider)workbenchPart).getEditingDomain();
        }
    }

    protected class SelfAffectingCommand
    extends CommandWrapper {
        SelfAffectingCommand(String label, Command command) {
            super(label, command);
        }

        public Collection getResult() {
            return ControlAction.this.selection.toList();
        }

        public Collection getAffectedObjects() {
            return ControlAction.this.selection.toList();
        }
    }

    protected static class ControlResourceDialog
    extends ResourceDialog {
        protected EditingDomain domain;
        protected Resource resource;
        protected Resource currentResource;

        public ControlResourceDialog(Shell parent, EditingDomain domain, Resource currentResource) {
            super(parent, EMFEditUIPlugin.INSTANCE.getString("_UI_ControlDialog_title"), 8192);
            this.domain = domain;
            this.currentResource = currentResource;
        }

        protected boolean processResources() {
            boolean resourceInSet;
            List uris = this.getURIs();
            if (uris.isEmpty()) {
                return false;
            }
            URI uri = (URI)uris.get(0);
            ResourceSet resourceSet = this.domain.getResourceSet();
            Resource resource = resourceSet.getResource(uri, false);
            boolean bl = resourceInSet = resource != null;
            if (resource == this.currentResource) {
                MessageDialog.openError((Shell)this.getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_InvalidURI_label"), (String)EMFEditUIPlugin.INSTANCE.getString("_WARN_AlreadyInResource"));
                return false;
            }
            if (this.domain.isReadOnly(resource)) {
                MessageDialog.openError((Shell)this.getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_InvalidURI_label"), (String)EMFEditUIPlugin.INSTANCE.getString("_WARN_ReadOnlyResource"));
                return false;
            }
            boolean resourceExists = false;
            try {
                InputStream stream = resourceSet.getURIConverter().createInputStream(uri);
                if (stream != null) {
                    resourceExists = true;
                    stream.close();
                }
            }
            catch (IOException iOException) {}
            boolean resourceBad = false;
            if (!resourceInSet) {
                resource = resourceSet.createResource(uri);
                if (resource == null) {
                    MessageDialog.openError((Shell)this.getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_InvalidURI_label"), (String)EMFEditUIPlugin.INSTANCE.getString("_WARN_CannotCreateResource"));
                    return false;
                }
                if (resourceExists) {
                    try {
                        resource = resourceSet.getResource(uri, true);
                    }
                    catch (RuntimeException exception) {
                        EMFEditUIPlugin.INSTANCE.log(exception);
                        resourceBad = resource.getContents().isEmpty();
                    }
                }
            }
            boolean result = true;
            if (resourceBad) {
                result = MessageDialog.openQuestion((Shell)this.getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_ExistingResource_label"), (String)EMFEditUIPlugin.INSTANCE.getString("_WARN_ReplaceResource"));
            } else if (resourceExists) {
                result = MessageDialog.openQuestion((Shell)this.getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_ExistingResource_label"), (String)EMFEditUIPlugin.INSTANCE.getString("_WARN_AddToResource"));
            }
            if (!result && !resourceInSet) {
                resource.unload();
                resourceSet.getResources().remove((Object)resource);
            } else {
                this.resource = resource;
            }
            return result;
        }

        public Resource getResource() {
            return this.resource;
        }
    }
}

