/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;

public final class EMFEditPlugin
extends EMFPlugin {
    public static final EMFEditPlugin INSTANCE = new EMFEditPlugin();
    private static Implementation plugin;
    private static ComposedAdapterFactory.Descriptor.Registry.Impl composedAdapterFactoryDescriptorRegistry;

    private EMFEditPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static ComposedAdapterFactory.Descriptor.Registry getComposedAdapterFactoryDescriptorRegistry() {
        if (composedAdapterFactoryDescriptorRegistry == null) {
            composedAdapterFactoryDescriptorRegistry = new ComposedAdapterFactory.Descriptor.Registry.Impl(null){
                private static final long serialVersionUID = 1L;

                @Override
                public ComposedAdapterFactory.Descriptor delegatedGetDescriptor(Collection<?> types) {
                    ArrayList<String> stringTypes = new ArrayList<String>(types.size());
                    for (Object key : types) {
                        if (key instanceof EPackage) {
                            stringTypes.add(((EPackage)key).getNsURI());
                            continue;
                        }
                        if (key instanceof Package) {
                            stringTypes.add(((Package)key).getName());
                            continue;
                        }
                        if (key instanceof Class) {
                            stringTypes.add(((Class)key).getName());
                            continue;
                        }
                        return null;
                    }
                    ComposedAdapterFactory.Descriptor descriptor = (ComposedAdapterFactory.Descriptor)this.get(stringTypes);
                    if (descriptor != null) {
                        this.put(types, descriptor);
                        return descriptor;
                    }
                    return super.delegatedGetDescriptor(types);
                }
            };
            if (INSTANCE.getPluginResourceLocator() instanceof EMFPlugin.EclipsePlugin) {
                RegistryReader registryReader = new RegistryReader(Platform.getExtensionRegistry(), INSTANCE.getSymbolicName(), "itemProviderAdapterFactories"){

                    protected boolean readElement(IConfigurationElement element, boolean add) {
                        if (element.getName().equals("factory")) {
                            String packageURI = element.getAttribute("uri");
                            String className = element.getAttribute("class");
                            String supportedTypes = element.getAttribute("supportedTypes");
                            if (packageURI == null) {
                                this.logMissingAttribute(element, "uri");
                            } else if (className == null) {
                                this.logMissingAttribute(element, "class");
                            } else if (supportedTypes == null) {
                                this.logMissingAttribute(element, "supportedTypes");
                            }
                            StringTokenizer stringTokenizer = new StringTokenizer(supportedTypes);
                            while (stringTokenizer.hasMoreTokens()) {
                                String supportedType = stringTokenizer.nextToken();
                                ArrayList<String> key = new ArrayList<String>();
                                key.add(packageURI);
                                key.add(supportedType);
                                if (add) {
                                    class PluginAdapterFactoryDescriptor
                                    extends RegistryReader.PluginClassDescriptor
                                    implements ComposedAdapterFactory.Descriptor {
                                        public PluginAdapterFactoryDescriptor(IConfigurationElement element, String attributeName) {
                                            super(element, attributeName);
                                        }

                                        public AdapterFactory createAdapterFactory() {
                                            return (AdapterFactory)this.createInstance();
                                        }
                                    }
                                    composedAdapterFactoryDescriptorRegistry.put(key, new PluginAdapterFactoryDescriptor(element, "class"));
                                    continue;
                                }
                                composedAdapterFactoryDescriptorRegistry.remove(key);
                            }
                            return true;
                        }
                        return false;
                    }
                };
                registryReader.readRegistry();
            }
        }
        return composedAdapterFactoryDescriptorRegistry;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public Implementation() {
            plugin = this;
        }
    }
}

