/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.client.impl;

import org.apache.log4j.Logger;
import org.eclipse.emf.cdo.client.CDOPackage;
import org.eclipse.emf.cdo.client.CDOPersistent;
import org.eclipse.emf.cdo.client.CDOResource;
import org.eclipse.emf.cdo.client.ResourceManager;
import org.eclipse.emf.cdo.client.impl.CDOResourceImpl;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.net4j.core.AlreadyRequestingException;

public abstract class CDOPersistentImpl
extends EObjectImpl
implements CDOPersistent {
    private static final Logger logger = Logger.getLogger(CDOPersistentImpl.class);
    private CDOResource cdoResource;
    private long cdoOID;
    private int cdoOCA = -1;

    protected CDOPersistentImpl() {
    }

    protected EClass eStaticClass() {
        return CDOPackage.Literals.CDO_PERSISTENT;
    }

    public Resource eResource() {
        Resource resource = super.eResource();
        if (resource == null) {
            resource = this.cdoResource;
        }
        return resource;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (this.cdoNoSignalling()) {
            return super.eInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        return msgs;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        if (this.cdoNoSignalling()) {
            return super.eInverseAdd(otherEnd, featureID, msgs);
        }
        return msgs;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (this.cdoNoSignalling()) {
            return super.eInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return msgs;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        if (this.cdoNoSignalling()) {
            return super.eInverseRemove(otherEnd, featureID, msgs);
        }
        return msgs;
    }

    public EObject eContainer() {
        this.cdoLoad();
        return super.eContainer();
    }

    public EList eContents() {
        try {
            this.cdoLoad();
            return super.eContents();
        }
        catch (AlreadyRequestingException alreadyRequestingException) {
            return new BasicInternalEList(EObject.class);
        }
    }

    public EList eCrossReferences() {
        ResourceManager resourceManager = this.cdoResource.getResourceManager();
        return resourceManager.queryCrossReferences(this);
    }

    public long cdoGetOID() {
        return this.cdoOID;
    }

    public void cdoSetOID(long oid) {
        this.cdoOID = oid;
    }

    public int cdoGetOCA() {
        return this.cdoOCA;
    }

    public void cdoSetOCA(int oca) {
        this.cdoOCA = oca;
    }

    public void cdoLoad() {
        ResourceManager resourceManager;
        if (this.cdoResource != null && !this.cdoIsNew() && !this.cdoIsLoaded() && (resourceManager = this.cdoResource.getResourceManager()).isRequestingObjects()) {
            resourceManager.requestObject(this);
        }
    }

    public boolean cdoIsNew() {
        return this.cdoOID <= 0L;
    }

    public boolean cdoIsLoaded() {
        return this.cdoOCA != -1;
    }

    public CDOResource cdoGetResource() {
        return this.cdoResource;
    }

    public void cdoSetResource(CDOResource resource) {
        this.cdoResource = resource;
    }

    public long cdoSetNew() {
        if (this.eResource() instanceof CDOResourceImpl) {
            CDOResourceImpl cdoResource = (CDOResourceImpl)this.eResource();
            long oldOID = this.cdoOID;
            this.cdoOID = cdoResource.getNextTempOID();
            this.cdoOCA = -1;
            return oldOID;
        }
        throw new IllegalStateException("Not a CDOResourceImpl:" + this.eResource());
    }

    private boolean cdoNoSignalling() {
        return this.cdoResource == null || this.cdoResource.getResourceManager().isRequestingObjects();
    }
}

