/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.codegen.lite;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.jet.JETCompiler;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.codegen.util.GIFEmitter;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.common.UnexpectedBehaviourException;
import org.eclipse.gmf.internal.codegen.lite.Activator;
import org.eclipse.gmf.internal.common.codegen.BinaryEmitter;
import org.eclipse.gmf.internal.common.codegen.DefaultTextMerger;
import org.eclipse.gmf.internal.common.codegen.JETGIFEmitterAdapter;
import org.eclipse.gmf.internal.common.codegen.TextEmitter;
import org.eclipse.gmf.internal.common.codegen.TextMerger;
import org.eclipse.gmf.internal.common.codegen.XpandTextEmitter;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.util.BundleResourceManager;
import org.osgi.framework.Bundle;

public class CodegenEmitters {
    private static final String CODEGEN_PLUGIN_ID = "org.eclipse.gmf.codegen";
    private final String[] myTemplatePath;
    private final ResourceManager myResourceManager;

    public CodegenEmitters(boolean useBaseTemplatesOnly, String templateDirectory) {
        ArrayList<URL> templatesURI = new ArrayList<URL>(3);
        templatesURI.add(CodegenEmitters.getTemplatesBundle().getEntry("/templates/"));
        templatesURI.add(CodegenEmitters.getCodegenTemplatesBundle().getEntry("/templates/"));
        URL dynamicTemplatesPath = CodegenEmitters.getDynamicTemplatesURL(templateDirectory);
        if (!useBaseTemplatesOnly && dynamicTemplatesPath != null) {
            templatesURI.add(0, dynamicTemplatesPath);
        }
        this.myResourceManager = new BundleResourceManager(templatesURI.toArray(new URL[templatesURI.size()]));
        this.myTemplatePath = new String[templatesURI.size()];
        int i = 0;
        while (i < templatesURI.size()) {
            this.myTemplatePath[i] = ((URL)templatesURI.get(i)).toString();
            ++i;
        }
    }

    private static URL getDynamicTemplatesURL(String templateDirectory) {
        if (templateDirectory != null) {
            URI templatesURI = templateDirectory.indexOf(":") == -1 ? URI.createPlatformResourceURI((String)templateDirectory, (boolean)true) : URI.createURI((String)templateDirectory);
            try {
                return new URL(CommonPlugin.resolve((URI)templatesURI).toString());
            }
            catch (MalformedURLException e) {
                Activator.getInstance().getLog().log((IStatus)new Status(4, Activator.getPluginID(), 0, "Incorrect dynamic templates location", (Throwable)e));
            }
        }
        return null;
    }

    public TextMerger createMergeService() {
        URL controlFile = this.getJMergeControlFile();
        if (controlFile != null) {
            JControlModel controlModel = new JControlModel();
            controlModel.initialize(CodeGenUtil.instantiateFacadeHelper((String)JMerger.DEFAULT_FACADE_HELPER_CLASS), controlFile.toString());
            if (!controlModel.canMerge()) {
                throw new IllegalStateException("Can not initialize JControlModel");
            }
            return new DefaultTextMerger(controlModel);
        }
        return null;
    }

    public TextEmitter getCreateNodeCommandEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::commands::CreateNodeCommand::CreateNodeCommand");
    }

    public TextEmitter getCreateNodeCommandQualifiedClassNameEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::commands::CreateNodeCommand::qualifiedClassName");
    }

    public TextEmitter getAddNodeCommandEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::commands::AddNodeCommand::AddNodeCommand");
    }

    public TextEmitter getAddNodeCommandQualifiedClassNameEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::commands::AddNodeCommand::qualifiedClassName");
    }

    public TextEmitter getCloneNodeCommandEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::commands::CloneNodeCommand::CloneNodeCommand");
    }

    public TextEmitter getCloneNodeCommandQualifiedClassNameEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::commands::CloneNodeCommand::qualifiedClassName");
    }

    public TextEmitter getCreateLinkStartCommandEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::commands::CreateLinkStartCommand::CreateLinkStartCommand");
    }

    public TextEmitter getCreateLinkStartCommandQualifiedClassNameEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::commands::CreateLinkStartCommand::qualifiedClassName");
    }

    public TextEmitter getCreateLinkCompleteCommandEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::commands::CreateLinkCompleteCommand::CreateLinkCompleteCommand");
    }

    public TextEmitter getCreateLinkCompleteCommandQualifiedClassNameEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::commands::CreateLinkCompleteCommand::qualifiedClassName");
    }

    public TextEmitter getReconnectLinkSourceCommandEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::commands::ReconnectLinkSourceCommand::ReconnectLinkSourceCommand");
    }

    public TextEmitter getReconnectLinkSourceCommandQualifiedClassNameEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::commands::ReconnectLinkSourceCommand::qualifiedClassName");
    }

    public TextEmitter getReconnectLinkTargetCommandEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::commands::ReconnectLinkTargetCommand::ReconnectLinkTargetCommand");
    }

    public TextEmitter getReconnectLinkTargetCommandQualifiedClassNameEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::commands::ReconnectLinkTargetCommand::qualifiedClassName");
    }

    public TextEmitter getViewFactoryGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::viewfactories::ViewFactory::ViewFactory");
    }

    public TextEmitter getComponentEditPolicyEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::policies::ComponentEditPolicy::ComponentEditPolicy");
    }

    public TextEmitter getComponentEditPolicyQualifiedClassNameEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::policies::ComponentEditPolicy::qualifiedClassName");
    }

    public TextEmitter getLayoutEditPolicyEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::policies::LayoutEditPolicy::LayoutEditPolicy");
    }

    public TextEmitter getLayoutEditPolicyQualifiedClassNameEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::policies::LayoutEditPolicy::qualifiedClassName");
    }

    public TextEmitter getSideAffixedLayoutEditPolicyEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::policies::LayoutEditPolicy::SideAffixedLayoutEditPolicy");
    }

    public TextEmitter getSideAffixedLayoutEditPolicyQualifiedClassNameEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::policies::LayoutEditPolicy::SideAffixedQualifiedClassName");
    }

    public TextEmitter getGraphicalEditPolicyEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::policies::GraphicalNodeEditPolicy::GraphicalNodeEditPolicy");
    }

    public TextEmitter getGraphicalEditPolicyQualifiedClassNameEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::policies::GraphicalNodeEditPolicy::qualifiedClassName");
    }

    public TextEmitter getConnectionEndpointEditPolicyEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::policies::ConnectionEndpointEditPolicy::ConnectionEndpointEditPolicy");
    }

    public TextEmitter getConnectionEndpointEditPolicyQualifiedClassNameEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::policies::ConnectionEndpointEditPolicy::qualifiedClassName");
    }

    public TextEmitter getValidationProviderGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::providers::ValidationProvider::ValidationProvider");
    }

    public TextEmitter getValidateActionGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::providers::ValidateAction::ValidateAction");
    }

    public TextEmitter getValidateActionQualifiedNameGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::providers::ValidateAction::qualifiedClassName");
    }

    public TextEmitter getMetricProviderEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::providers::MetricProvider::MetricProvider");
    }

    public TextEmitter getMetricsActionEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::providers::MetricsAction::MetricsAction");
    }

    public TextEmitter getMetricsActionQualifiedNameEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::providers::MetricsAction::qualifiedClassName");
    }

    public TextEmitter getDomainElementInitializerGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::providers::DomainElementInitializer::DomainElementInitializer");
    }

    public TextEmitter getDomainElementInitializerQualifiedNameGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::providers::DomainElementInitializer::qualifiedClassName");
    }

    public TextEmitter getCompartmentEditPartGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::parts::CompartmentEditPart::CompartmentEditPart");
    }

    public TextEmitter getDiagramEditPartGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::parts::DiagramEditPart::DiagramEditPart");
    }

    public TextEmitter getEditPartFactoryGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::parts::EditPartFactory::EditPartFactory");
    }

    public TextEmitter getLinkEditPartGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::parts::LinkEditPart::LinkEditPart");
    }

    public TextEmitter getLinkLabelEditPartGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::parts::LinkLabelEditPart::LinkLabelEditPart");
    }

    public TextEmitter getChildNodeEditPartGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::parts::ChildNodeEditPart::ChildNodeEditPart");
    }

    public TextEmitter getNodeEditPartGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::parts::NodeEditPart::NodeEditPart");
    }

    public TextEmitter getNodeLabelEditPartGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::parts::NodeLabelEditPart::NodeLabelEditPart");
    }

    public TextEmitter getPluginGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::Plugin::Plugin");
    }

    public TextEmitter getActionBarContributorGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::ActionBarContributor::ActionBarContributor");
    }

    public TextEmitter getOpenDiagramInViewActionGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::OpenDiagramInViewAction::OpenDiagramInViewAction");
    }

    public TextEmitter getOpenDiagramInViewActionQualifiedClassNameGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::OpenDiagramInViewAction::qualifiedClassName");
    }

    public TextEmitter getEditorGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::Editor::Editor");
    }

    public TextEmitter getMatchingStrategyEmitter() {
        return this.retrieveXpand("xpt::editor::MatchingStrategy::MatchingStrategy");
    }

    public TextEmitter getCreationWizardGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::CreationWizard::CreationWizard");
    }

    public TextEmitter getCreationWizardPageGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::CreationWizardPage::CreationWizardPage");
    }

    public TextEmitter getDiagramEditorUtilGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::DiagramEditorUtil::DiagramEditorUtil");
    }

    public TextEmitter getPaletteFactoryGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::palette::PaletteFactory::Factory");
    }

    public TextEmitter getVisualIDRegistryGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::VisualIDRegistry::VisualIDRegistry");
    }

    public TextEmitter getManifestGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::manifest::manifest");
    }

    public TextEmitter getBuildPropertiesGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::buildProperties::buildProperties");
    }

    public TextEmitter getPluginXML() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::plugin::plugin");
    }

    public TextEmitter getModelElementSelectionPageEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::ModelElementSelectionPage::ModelElementSelectionPage");
    }

    public TextEmitter getModelElementSelectionPageQualifiedNameEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::ModelElementSelectionPage::qualifiedClassName");
    }

    public TextEmitter getInitDiagramFileActionGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::InitDiagramFileAction::InitDiagramFileAction");
    }

    public TextEmitter getNewDiagramFileWizardGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::NewDiagramFileWizard::NewDiagramFileWizard");
    }

    public TextEmitter getURISelectorPageGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::URISelectorPage::URISelectorPage");
    }

    public TextEmitter getURISelectorPageQualifiedClassNameGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::URISelectorPage::qualifiedClassName");
    }

    public TextEmitter getShortcutPropertyTesterEmitter() {
        return this.retrieveXpand("xpt::editor::ShortcutPropertyTester::ShortcutPropertyTester");
    }

    public TextEmitter getShortcutCreationWizardEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::ShortcutCreationWizard::ShortcutCreationWizard");
    }

    public TextEmitter getShortcutCreationWizardQualifiedClassNameEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::ShortcutCreationWizard::qualifiedClassName");
    }

    public TextEmitter getCreateShortcutActionEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::CreateShortcutAction::CreateShortcutAction");
    }

    public TextEmitter getShortcutProviderEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::providers::ShortcutProvider::ShortcutProvider");
    }

    public TextEmitter getShortcutProviderQualifiedClassNameEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::providers::ShortcutProvider::qualifiedClassName");
    }

    public TextEmitter getCreateShortcutNodeCommandEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::commands::CreateShortcutNodeCommand::CreateShortcutNodeCommand");
    }

    public TextEmitter getCreateShortcutNodeCommandQualifiedClassNameEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::commands::CreateShortcutNodeCommand::qualifiedClassName");
    }

    public TextEmitter getCreateShortcutEdgeCommandEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::commands::CreateShortcutEdgeCommand::CreateShortcutEdgeCommand");
    }

    public TextEmitter getCreateShortcutEdgeCommandQualifiedClassNameEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::commands::CreateShortcutEdgeCommand::qualifiedClassName");
    }

    public TextEmitter getElementChooserEmitter() {
        return this.retrieveXpand("xpt::editor::ElementChooser::ElementChooser");
    }

    public TextEmitter getLoadResourceActionGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::LoadResourceAction::LoadResourceAction");
    }

    public TextEmitter getElementTypesGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::providers::ElementTypes::ElementTypes");
    }

    public TextEmitter getPluginPropertiesGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::properties::properties");
    }

    public TextEmitter getAbstractExpressionEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::expressions::AbstractExpression::AbstractExpression");
    }

    public TextEmitter getOCLExpressionFactoryEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::expressions::OCLExpressionFactory::OCLExpressionFactory");
    }

    public TextEmitter getRegexpExpressionFactoryEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::expressions::RegexpExpressionFactory::RegexpExpressionFactory");
    }

    public TextEmitter getOpenDiagramEditPolicyEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::policies::OpenDiagramEditPolicy::OpenDiagramEditPolicy");
    }

    public TextEmitter getAppearancePreferencePageEmitter() {
        return this.retrieveXpand("xpt::diagram::preferences::AppearancePreferencePage::AppearancePreferencePage");
    }

    public TextEmitter getAppearancePreferencePageQualifiedClassNameEmitter() {
        return this.retrieveXpand("xpt::diagram::preferences::AppearancePreferencePage::qualifiedClassName");
    }

    public TextEmitter getGeneralPreferencePageEmitter() {
        return this.retrieveXpand("xpt::diagram::preferences::GeneralPreferencePage::GeneralPreferencePage");
    }

    public TextEmitter getGeneralPreferencePageQualifiedClassNameEmitter() {
        return this.retrieveXpand("xpt::diagram::preferences::GeneralPreferencePage::qualifiedClassName");
    }

    public BinaryEmitter getDiagramIconEmitter() throws UnexpectedBehaviourException {
        return this.newGIFEmitterAdapter("/xpt/editor/diagram.gif");
    }

    public BinaryEmitter getWizardBannerImageEmitter() throws UnexpectedBehaviourException {
        return this.newGIFEmitterAdapter("/xpt/editor/wizban.gif");
    }

    public TextEmitter getWizardBannerStemEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::CreationWizard::wizardBannerStem");
    }

    public TextEmitter getWizardBannerLocationEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::CreationWizard::wizardBannerLocation");
    }

    private BinaryEmitter newGIFEmitter(String relativePath) throws UnexpectedBehaviourException {
        return new org.eclipse.gmf.internal.common.codegen.GIFEmitter(this.checkTemplateLocation(relativePath));
    }

    private BinaryEmitter newGIFEmitterAdapter(String relativePath) throws UnexpectedBehaviourException {
        return new JETGIFEmitterAdapter(new GIFEmitter(this.checkTemplateLocation(relativePath)));
    }

    private String checkTemplateLocation(String relativePath) throws UnexpectedBehaviourException {
        String templateLocation = JETCompiler.find((String[])this.getTemplatePath(), (String)relativePath);
        if (templateLocation == null) {
            throw new UnexpectedBehaviourException("Template " + relativePath + " not found");
        }
        return templateLocation;
    }

    private String[] getTemplatePath() {
        return this.myTemplatePath;
    }

    private static Bundle getTemplatesBundle() {
        return Activator.getDefault();
    }

    private static Bundle getCodegenTemplatesBundle() {
        return Platform.getBundle((String)CODEGEN_PLUGIN_ID);
    }

    public URL getJMergeControlFile() {
        return CodegenEmitters.getCodegenTemplatesBundle().getEntry("/templates/emf-merge.xml");
    }

    public BinaryEmitter getShortcutImageEmitter() throws UnexpectedBehaviourException {
        return this.newGIFEmitter("/xpt/editor/shortcut.gif");
    }

    public TextEmitter getNavigatorContentProviderEmitter() {
        return this.retrieveXpand("xpt::navigator::NavigatorContentProvider::NavigatorContentProvider");
    }

    public TextEmitter getDomainNavigatorContentProviderEmitter() {
        return this.retrieveXpand("xpt::navigator::DomainNavigatorContentProvider::DomainNavigatorContentProvider");
    }

    public TextEmitter getDomainNavigatorLabelProviderEmitter() {
        return this.retrieveXpand("xpt::navigator::DomainNavigatorLabelProvider::DomainNavigatorLabelProvider");
    }

    public TextEmitter getDomainNavigatorItemEmitter() {
        return this.retrieveXpand("xpt::navigator::DomainNavigatorItem::DomainNavigatorItem");
    }

    public TextEmitter getURIEditorInputTesterEmitter() {
        return this.retrieveXpand("xpt::editor::UriEditorInputTester::UriEditorInputTester");
    }

    public TextEmitter getNavigatorLabelProviderEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::navigator::NavigatorLabelProvider::NavigatorLabelProvider");
    }

    public TextEmitter getNavigatorLinkHelperEmitter() {
        return this.retrieveXpand("xpt::navigator::NavigatorLinkHelper::NavigatorLinkHelper");
    }

    public TextEmitter getNavigatorSorterEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::navigator::NavigatorSorter::NavigatorSorter");
    }

    public TextEmitter getNavigatorActionProviderEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::navigator::NavigatorActionProvider::NavigatorActionProvider");
    }

    public TextEmitter getAbstractNavigatorItemEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::navigator::AbstractNavigatorItem::AbstractNavigatorItem");
    }

    public TextEmitter getNavigatorGroupEmitter() {
        return this.retrieveXpand("xpt::navigator::NavigatorGroup::NavigatorGroup");
    }

    public TextEmitter getNavigatorItemEmitter() {
        return this.retrieveXpand("xpt::navigator::NavigatorItem::NavigatorItem");
    }

    public BinaryEmitter getGroupIconEmitter() throws UnexpectedBehaviourException {
        return this.newGIFEmitter("/xpt/navigator/navigatorGroup.gif");
    }

    public TextEmitter getPropertySheetLabelProviderEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::propsheet::SheetLabelProvider::SheetLabelProvider");
    }

    public TextEmitter getPropertySectionEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::propsheet::PropertySection::PropertySection");
    }

    public TextEmitter getApplicationEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::application::Application::Application");
    }

    public TextEmitter getActionBarAdvisorEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::application::ActionBarAdvisor::ActionBarAdvisor");
    }

    public TextEmitter getPerspectiveEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::application::Perspective::Perspective");
    }

    public TextEmitter getWorkbenchAdvisorEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::application::WorkbenchAdvisor::WorkbenchAdvisor");
    }

    public TextEmitter getWorkbenchWindowAdvisorEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::application::WorkbenchWindowAdvisor::WorkbenchWindowAdvisor");
    }

    public TextEmitter getMarkerNavigationProviderEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::providers::MarkerNavigationProvider::MarkerNavigationProvider");
    }

    public TextEmitter getExternalizeEmitter() {
        return this.retrieveXpand("xpt::Externalizer::Access");
    }

    public TextEmitter getMessagesEmitter() {
        return this.retrieveXpand("xpt::Externalizer::Values");
    }

    private TextEmitter retrieveXpand(String templateFQN) {
        return new XpandTextEmitter(this.myResourceManager, templateFQN);
    }
}

