/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests;

import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.tests.Plugin;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class JDTUtil {
    private final IJavaProject myJavaProject;
    private ViolationAggregator myAggregator;

    public JDTUtil(IJavaProject javaProject) {
        this.myJavaProject = javaProject;
    }

    public JDTUtil(IProject p) {
        this(JavaCore.create((IProject)p));
    }

    public IStatus collectProblems() {
        return this.collectProblems(new IMemberProcessor[]{new GeneratedTagEnsurer(), new GeneratedTagAbsenceInLocalMembersEnsurer()});
    }

    private IStatus collectProblems(IMemberProcessor[] processors) {
        if (this.myAggregator == null) {
            this.myAggregator = new ViolationAggregator();
            this.collectProblems((IJavaElement)this.myJavaProject, processors);
        }
        return this.myAggregator.getStatus();
    }

    private void collectProblems(IJavaElement jElement, IMemberProcessor[] processors) {
        try {
            switch (jElement.getElementType()) {
                case 2: {
                    IJavaProject jProject = (IJavaProject)jElement;
                    IPackageFragmentRoot[] roots = jProject.getPackageFragmentRoots();
                    int i = 0;
                    while (i < roots.length) {
                        if (roots[i].getKind() == 1) {
                            this.collectProblems((IJavaElement)roots[i], processors);
                        }
                        ++i;
                    }
                    break;
                }
                case 3: {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)jElement;
                    IJavaElement[] children = root.getChildren();
                    int i = 0;
                    while (i < children.length) {
                        this.collectProblems(children[i], processors);
                        ++i;
                    }
                    break;
                }
                case 4: {
                    IPackageFragment pf = (IPackageFragment)jElement;
                    ICompilationUnit[] compilationUnits = pf.getCompilationUnits();
                    int i = 0;
                    while (i < compilationUnits.length) {
                        this.collectProblems((IJavaElement)compilationUnits[i], processors);
                        ++i;
                    }
                    break;
                }
                case 5: {
                    ICompilationUnit compilationUnit = (ICompilationUnit)jElement;
                    IType[] types = compilationUnit.getTypes();
                    int i = 0;
                    while (i < types.length) {
                        this.collectProblems((IJavaElement)types[i], processors);
                        ++i;
                    }
                    break;
                }
                case 7: {
                    IMember member = (IMember)jElement;
                    this.collectProblems(member, processors, false);
                }
            }
        }
        catch (JavaModelException e) {
            this.myAggregator.add(e.getStatus());
        }
    }

    private void collectProblems(IMember member, IMemberProcessor[] processors, boolean isLocalMember) throws JavaModelException {
        int i = 0;
        while (i < processors.length) {
            IStatus status = processors[i].processMember(member, isLocalMember);
            if (status != null && !status.isOK()) {
                this.myAggregator.add(status);
            }
            ++i;
        }
        isLocalMember |= !(member instanceof IType);
        IJavaElement[] children = member.getChildren();
        int i2 = 0;
        while (i2 < children.length) {
            this.collectProblems((IMember)children[i2], processors, isLocalMember);
            ++i2;
        }
    }

    private static IStatus newViolation(IMember member, String description) {
        return new Status(4, Plugin.getPluginID(), 0, MessageFormat.format("{0} has problem: {1}", member.getHandleIdentifier(), description), null);
    }

    private static class GeneratedTagAbsenceInLocalMembersEnsurer
    extends JavadocMemberProcessor {
        private GeneratedTagAbsenceInLocalMembersEnsurer() {
        }

        public IStatus processMember(IMember member, boolean isLocalMember) throws JavaModelException {
            if (!isLocalMember) {
                return null;
            }
            String javadoc = this.getJavadoc(member);
            if (javadoc.indexOf("@generated") != -1) {
                return JDTUtil.newViolation(member, "@generated tag in local members is misleading");
            }
            return null;
        }
    }

    public static class GeneratedTagEnsurer
    extends JavadocMemberProcessor {
        public IStatus processMember(IMember member, boolean isLocalMember) throws JavaModelException {
            if (isLocalMember) {
                return null;
            }
            if (member.getElementType() == 10 && member.getOccurrenceCount() > 1) {
                return JDTUtil.newViolation(member, "Multiple sibling initializers should be avoided in the generated code: they may not always be merged correctly");
            }
            String javadoc = this.getJavadoc(member);
            int index = javadoc.lastIndexOf("@generated");
            if (index == -1) {
                return JDTUtil.newViolation(member, "@generated is missing");
            }
            if (javadoc.indexOf("@generated") != index) {
                return JDTUtil.newViolation(member, "There is more than one @generated tag");
            }
            String afterGenerated = javadoc.substring(index + "@generated".length()).trim();
            String asteriskIgnored = afterGenerated.replace('*', ' ').trim();
            if (asteriskIgnored.length() == 0) {
                return JDTUtil.newViolation(member, "JavaDoc comment with @generated tag is not terminated properly");
            }
            switch (asteriskIgnored.charAt(0)) {
                case '@': {
                    break;
                }
                case '/': {
                    break;
                }
                default: {
                    return JDTUtil.newViolation(member, "@generated tag will be interpreted as @generated NOT");
                }
            }
            return null;
        }
    }

    private static interface IMemberProcessor {
        public IStatus processMember(IMember var1, boolean var2) throws JavaModelException;
    }

    private static abstract class JavadocMemberProcessor
    implements IMemberProcessor {
        protected static final String GENERATED = "@generated";

        private JavadocMemberProcessor() {
        }

        protected final String getJavadoc(IMember member) throws JavaModelException {
            ISourceRange javadocRange = member.getJavadocRange();
            if (javadocRange == null) {
                return "";
            }
            return member.getCompilationUnit().getSource().substring(javadocRange.getOffset(), javadocRange.getLength() + javadocRange.getOffset());
        }
    }

    private static class ViolationAggregator {
        private MultiStatus myStatus = new MultiStatus(Plugin.getPluginID(), 0, "JDT Violations", null);

        private ViolationAggregator() {
        }

        public void add(IStatus status) {
            this.myStatus.merge(status);
        }

        public IStatus getStatus() {
            if (this.myStatus.isOK()) {
                return Status.OK_STATUS;
            }
            StringBuffer buffer = new StringBuffer();
            IStatus[] children = this.myStatus.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i].matches(this.myStatus.getSeverity())) {
                    buffer.append(children[i].getMessage()).append("\n");
                }
                ++i;
            }
            return new Status(this.myStatus.getSeverity(), Plugin.getPluginID(), 0, buffer.toString(), null);
        }
    }
}

