/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.batik.bridge.BaseScriptingEnvironment;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.Messages;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.ScriptingEnvironment;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterException;
import org.apache.batik.script.Window;
import org.apache.batik.util.EncodingUtilities;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.RunnableQueue;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGDocument;

public class ScriptingEnvironment
extends BaseScriptingEnvironment {
    protected static final String FRAGMENT_PREFIX = "<svg xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink'>";
    protected static final String FRAGMENT_SUFFIX = "</svg>";
    public static final String[] SVG_EVENT_ATTRS = new String[]{"onabort", "onerror", "onresize", "onscroll", "onunload", "onzoom", "onbegin", "onend", "onrepeat", "onfocusin", "onfocusout", "onactivate", "onclick", "onmousedown", "onmouseup", "onmouseover", "onmouseout", "onmousemove", "onkeypress", "onkeydown", "onkeyup"};
    public static final String[] SVG_DOM_EVENT = new String[]{"SVGAbort", "SVGError", "SVGResize", "SVGScroll", "SVGUnload", "SVGZoom", "beginEvent", "endEvent", "repeatEvent", "DOMFocusIn", "DOMFocusOut", "DOMActivate", "click", "mousedown", "mouseup", "mouseover", "mouseout", "mousemove", "keypress", "keydown", "keyup"};
    protected Timer timer = new Timer(true);
    protected UpdateManager updateManager;
    protected RunnableQueue updateRunnableQueue;
    protected EventListener domNodeInsertedListener = new DOMNodeInsertedListener();
    protected EventListener domNodeRemovedListener = new DOMNodeRemovedListener();
    protected EventListener domAttrModifiedListener = new DOMAttrModifiedListener();
    protected EventListener svgAbortListener = new ScriptingEventListener("onabort");
    protected EventListener svgErrorListener = new ScriptingEventListener("onerror");
    protected EventListener svgResizeListener = new ScriptingEventListener("onresize");
    protected EventListener svgScrollListener = new ScriptingEventListener("onscroll");
    protected EventListener svgUnloadListener = new ScriptingEventListener("onunload");
    protected EventListener svgZoomListener = new ScriptingEventListener("onzoom");
    protected EventListener beginListener = new ScriptingEventListener("onbegin");
    protected EventListener endListener = new ScriptingEventListener("onend");
    protected EventListener repeatListener = new ScriptingEventListener("onrepeat");
    protected EventListener focusinListener = new ScriptingEventListener("onfocusin");
    protected EventListener focusoutListener = new ScriptingEventListener("onfocusout");
    protected EventListener activateListener = new ScriptingEventListener("onactivate");
    protected EventListener clickListener = new ScriptingEventListener("onclick");
    protected EventListener mousedownListener = new ScriptingEventListener("onmousedown");
    protected EventListener mouseupListener = new ScriptingEventListener("onmouseup");
    protected EventListener mouseoverListener = new ScriptingEventListener("onmouseover");
    protected EventListener mouseoutListener = new ScriptingEventListener("onmouseout");
    protected EventListener mousemoveListener = new ScriptingEventListener("onmousemove");
    protected EventListener keypressListener = new ScriptingEventListener("onkeypress");
    protected EventListener keydownListener = new ScriptingEventListener("onkeydown");
    protected EventListener keyupListener = new ScriptingEventListener("onkeyup");
    protected EventListener[] listeners = new EventListener[]{this.svgAbortListener, this.svgErrorListener, this.svgResizeListener, this.svgScrollListener, this.svgUnloadListener, this.svgZoomListener, this.beginListener, this.endListener, this.repeatListener, this.focusinListener, this.focusoutListener, this.activateListener, this.clickListener, this.mousedownListener, this.mouseupListener, this.mouseoverListener, this.mouseoutListener, this.mousemoveListener, this.keypressListener, this.keydownListener, this.keyupListener};
    Map attrToDOMEvent = new HashMap(SVG_EVENT_ATTRS.length);
    Map attrToListener = new HashMap(SVG_EVENT_ATTRS.length);

    public ScriptingEnvironment(BridgeContext bridgeContext) {
        super(bridgeContext);
        int n = 0;
        while (n < SVG_EVENT_ATTRS.length) {
            this.attrToDOMEvent.put(SVG_EVENT_ATTRS[n], SVG_DOM_EVENT[n]);
            this.attrToListener.put(SVG_EVENT_ATTRS[n], this.listeners[n]);
            ++n;
        }
        this.updateManager = bridgeContext.getUpdateManager();
        this.updateRunnableQueue = this.updateManager.getUpdateRunnableQueue();
        this.addScriptingListeners(this.document.getDocumentElement());
        EventTarget eventTarget = (EventTarget)((Object)this.document);
        eventTarget.addEventListener("DOMNodeInserted", this.domNodeInsertedListener, false);
        eventTarget.addEventListener("DOMNodeRemoved", this.domNodeRemovedListener, false);
        eventTarget.addEventListener("DOMAttrModified", this.domAttrModifiedListener, false);
    }

    public org.apache.batik.script.Window createWindow(Interpreter interpreter, String string) {
        return new Window(interpreter, string);
    }

    public void runEventHandler(String string, Event event, String string2, String string3) {
        Interpreter interpreter = this.getInterpreter(string2);
        if (interpreter == null) {
            return;
        }
        try {
            this.checkCompatibleScriptURL(string2, this.docPURL);
            interpreter.bindObject("event", event);
            interpreter.bindObject("evt", event);
            interpreter.evaluate(new StringReader(string), string3);
        }
        catch (IOException iOException) {
        }
        catch (InterpreterException interpreterException) {
            this.handleInterpreterException(interpreterException);
        }
        catch (SecurityException securityException) {
            this.handleSecurityException(securityException);
        }
    }

    public void interrupt() {
        this.timer.cancel();
        this.removeScriptingListeners(this.document.getDocumentElement());
        EventTarget eventTarget = (EventTarget)((Object)this.document);
        eventTarget.removeEventListener("DOMNodeInserted", this.domNodeInsertedListener, false);
        eventTarget.removeEventListener("DOMNodeRemoved", this.domNodeRemovedListener, false);
        eventTarget.removeEventListener("DOMAttrModified", this.domAttrModifiedListener, false);
    }

    protected void addScriptingListeners(Node node) {
        Node node2;
        if (node.getNodeType() == 1) {
            node2 = (Element)node;
            EventTarget eventTarget = (EventTarget)((Object)node2);
            if ("http://www.w3.org/2000/svg".equals(node2.getNamespaceURI())) {
                if ("svg".equals(node2.getLocalName())) {
                    if (node2.hasAttributeNS(null, "onabort")) {
                        eventTarget.addEventListener("SVGAbort", this.svgAbortListener, false);
                    }
                    if (node2.hasAttributeNS(null, "onerror")) {
                        eventTarget.addEventListener("SVGError", this.svgErrorListener, false);
                    }
                    if (node2.hasAttributeNS(null, "onresize")) {
                        eventTarget.addEventListener("SVGResize", this.svgResizeListener, false);
                    }
                    if (node2.hasAttributeNS(null, "onscroll")) {
                        eventTarget.addEventListener("SVGScroll", this.svgScrollListener, false);
                    }
                    if (node2.hasAttributeNS(null, "onunload")) {
                        eventTarget.addEventListener("SVGUnload", this.svgUnloadListener, false);
                    }
                    if (node2.hasAttributeNS(null, "onzoom")) {
                        eventTarget.addEventListener("SVGZoom", this.svgZoomListener, false);
                    }
                } else {
                    String string = node2.getLocalName();
                    if (string.equals("set") || string.startsWith("animate")) {
                        if (node2.hasAttributeNS(null, "onbegin")) {
                            eventTarget.addEventListener("beginEvent", this.beginListener, false);
                        }
                        if (node2.hasAttributeNS(null, "onend")) {
                            eventTarget.addEventListener("endEvent", this.endListener, false);
                        }
                        if (node2.hasAttributeNS(null, "onrepeat")) {
                            eventTarget.addEventListener("repeatEvent", this.repeatListener, false);
                        }
                        return;
                    }
                }
            }
            if (node2.hasAttributeNS(null, "onfocusin")) {
                eventTarget.addEventListener("DOMFocusIn", this.focusinListener, false);
            }
            if (node2.hasAttributeNS(null, "onfocusout")) {
                eventTarget.addEventListener("DOMFocusOut", this.focusoutListener, false);
            }
            if (node2.hasAttributeNS(null, "onactivate")) {
                eventTarget.addEventListener("DOMActivate", this.activateListener, false);
            }
            if (node2.hasAttributeNS(null, "onclick")) {
                eventTarget.addEventListener("click", this.clickListener, false);
            }
            if (node2.hasAttributeNS(null, "onmousedown")) {
                eventTarget.addEventListener("mousedown", this.mousedownListener, false);
            }
            if (node2.hasAttributeNS(null, "onmouseup")) {
                eventTarget.addEventListener("mouseup", this.mouseupListener, false);
            }
            if (node2.hasAttributeNS(null, "onmouseover")) {
                eventTarget.addEventListener("mouseover", this.mouseoverListener, false);
            }
            if (node2.hasAttributeNS(null, "onmouseout")) {
                eventTarget.addEventListener("mouseout", this.mouseoutListener, false);
            }
            if (node2.hasAttributeNS(null, "onmousemove")) {
                eventTarget.addEventListener("mousemove", this.mousemoveListener, false);
            }
            if (node2.hasAttributeNS(null, "onkeypress")) {
                eventTarget.addEventListener("keypress", this.keypressListener, false);
            }
            if (node2.hasAttributeNS(null, "onkeydown")) {
                eventTarget.addEventListener("keydown", this.keydownListener, false);
            }
            if (node2.hasAttributeNS(null, "onkeyup")) {
                eventTarget.addEventListener("keyup", this.keyupListener, false);
            }
        }
        node2 = node.getFirstChild();
        while (node2 != null) {
            this.addScriptingListeners(node2);
            node2 = node2.getNextSibling();
        }
    }

    protected void removeScriptingListeners(Node node) {
        Node node2;
        if (node.getNodeType() == 1) {
            node2 = (Element)node;
            EventTarget eventTarget = (EventTarget)((Object)node2);
            if ("http://www.w3.org/2000/svg".equals(node2.getNamespaceURI())) {
                if ("svg".equals(node2.getLocalName())) {
                    eventTarget.removeEventListener("SVGAbort", this.svgAbortListener, false);
                    eventTarget.removeEventListener("SVGError", this.svgErrorListener, false);
                    eventTarget.removeEventListener("SVGResize", this.svgResizeListener, false);
                    eventTarget.removeEventListener("SVGScroll", this.svgScrollListener, false);
                    eventTarget.removeEventListener("SVGUnload", this.svgUnloadListener, false);
                    eventTarget.removeEventListener("SVGZoom", this.svgZoomListener, false);
                } else {
                    String string = node2.getLocalName();
                    if (string.equals("set") || string.startsWith("animate")) {
                        eventTarget.removeEventListener("beginEvent", this.beginListener, false);
                        eventTarget.removeEventListener("endEvent", this.endListener, false);
                        eventTarget.removeEventListener("repeatEvent", this.repeatListener, false);
                        return;
                    }
                }
            }
            eventTarget.removeEventListener("DOMFocusIn", this.focusinListener, false);
            eventTarget.removeEventListener("DOMFocusOut", this.focusoutListener, false);
            eventTarget.removeEventListener("DOMActivate", this.activateListener, false);
            eventTarget.removeEventListener("click", this.clickListener, false);
            eventTarget.removeEventListener("mousedown", this.mousedownListener, false);
            eventTarget.removeEventListener("mouseup", this.mouseupListener, false);
            eventTarget.removeEventListener("mouseover", this.mouseoverListener, false);
            eventTarget.removeEventListener("mouseout", this.mouseoutListener, false);
            eventTarget.removeEventListener("mousemove", this.mousemoveListener, false);
            eventTarget.removeEventListener("keypress", this.keypressListener, false);
            eventTarget.removeEventListener("keydown", this.keydownListener, false);
            eventTarget.removeEventListener("keyup", this.keyupListener, false);
        }
        node2 = node.getFirstChild();
        while (node2 != null) {
            this.removeScriptingListeners(node2);
            node2 = node2.getNextSibling();
        }
    }

    protected void updateScriptingListeners(Element element, String string) {
        String string2 = (String)this.attrToDOMEvent.get(string);
        if (string2 == null) {
            return;
        }
        EventListener eventListener = (EventListener)this.attrToListener.get(string);
        EventTarget eventTarget = (EventTarget)((Object)element);
        if (element.hasAttributeNS(null, string)) {
            eventTarget.addEventListener(string2, eventListener, false);
        } else {
            eventTarget.removeEventListener(string2, eventListener, false);
        }
    }

    protected class DOMAttrModifiedListener
    implements EventListener {
        protected DOMAttrModifiedListener() {
        }

        public void handleEvent(Event event) {
            MutationEvent mutationEvent = (MutationEvent)event;
            if (mutationEvent.getAttrChange() != 1) {
                ScriptingEnvironment.this.updateScriptingListeners((Element)((Object)mutationEvent.getTarget()), mutationEvent.getAttrName());
            }
        }
    }

    protected class DOMNodeInsertedListener
    implements EventListener {
        protected DOMNodeInsertedListener() {
        }

        public void handleEvent(Event event) {
            ScriptingEnvironment.this.addScriptingListeners((Node)((Object)event.getTarget()));
        }
    }

    protected class DOMNodeRemovedListener
    implements EventListener {
        protected DOMNodeRemovedListener() {
        }

        public void handleEvent(Event event) {
            ScriptingEnvironment.this.removeScriptingListeners((Node)((Object)event.getTarget()));
        }
    }

    protected class EvaluateIntervalRunnable
    implements Runnable {
        public int count;
        public boolean error;
        protected Interpreter interpreter;
        protected String script;

        public EvaluateIntervalRunnable(String string, Interpreter interpreter) {
            this.interpreter = interpreter;
            this.script = string;
        }

        public void run() {
            EvaluateIntervalRunnable evaluateIntervalRunnable = this;
            synchronized (evaluateIntervalRunnable) {
                if (this.error) {
                    return;
                }
                --this.count;
            }
            try {
                this.interpreter.evaluate(this.script);
            }
            catch (InterpreterException interpreterException) {
                ScriptingEnvironment.this.handleInterpreterException(interpreterException);
                EvaluateIntervalRunnable evaluateIntervalRunnable2 = this;
                synchronized (evaluateIntervalRunnable2) {
                    this.error = true;
                }
            }
            catch (Exception exception) {
                if (ScriptingEnvironment.this.userAgent != null) {
                    ScriptingEnvironment.this.userAgent.displayError(exception);
                } else {
                    exception.printStackTrace();
                }
                EvaluateIntervalRunnable evaluateIntervalRunnable3 = this;
                synchronized (evaluateIntervalRunnable3) {
                    this.error = true;
                }
            }
        }
    }

    protected class EvaluateRunnable
    implements Runnable {
        protected Interpreter interpreter;
        protected String script;

        public EvaluateRunnable(String string, Interpreter interpreter) {
            this.interpreter = interpreter;
            this.script = string;
        }

        public void run() {
            try {
                this.interpreter.evaluate(this.script);
            }
            catch (InterpreterException interpreterException) {
                ScriptingEnvironment.this.handleInterpreterException(interpreterException);
            }
        }
    }

    protected class EvaluateRunnableRunnable
    implements Runnable {
        public int count;
        public boolean error;
        protected Runnable runnable;

        public EvaluateRunnableRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        public void run() {
            EvaluateRunnableRunnable evaluateRunnableRunnable = this;
            synchronized (evaluateRunnableRunnable) {
                if (this.error) {
                    return;
                }
                --this.count;
            }
            try {
                this.runnable.run();
            }
            catch (Exception exception) {
                if (ScriptingEnvironment.this.userAgent != null) {
                    ScriptingEnvironment.this.userAgent.displayError(exception);
                } else {
                    exception.printStackTrace();
                }
                EvaluateRunnableRunnable evaluateRunnableRunnable2 = this;
                synchronized (evaluateRunnableRunnable2) {
                    this.error = true;
                }
            }
        }
    }

    protected class ScriptingEventListener
    implements EventListener {
        protected String attribute;

        public ScriptingEventListener(String string) {
            this.attribute = string;
        }

        public void handleEvent(Event event) {
            Element element = (Element)((Object)event.getCurrentTarget());
            String string = element.getAttributeNS(null, this.attribute);
            if (string.length() == 0) {
                return;
            }
            DocumentLoader documentLoader = ScriptingEnvironment.this.bridgeContext.getDocumentLoader();
            SVGDocument sVGDocument = (SVGDocument)element.getOwnerDocument();
            int n = documentLoader.getLineNumber(element);
            String string2 = Messages.formatMessage("BaseScriptingEnvironment.constant.event.script.description", new Object[]{sVGDocument.getURL(), this.attribute, new Integer(n)});
            Element element2 = element;
            while (!(element2 == null || "http://www.w3.org/2000/svg".equals(element2.getNamespaceURI()) && "svg".equals(element2.getLocalName()))) {
                element2 = SVGUtilities.getParentElement(element2);
            }
            if (element2 == null) {
                return;
            }
            String string3 = element2.getAttributeNS(null, "contentScriptType");
            ScriptingEnvironment.this.runEventHandler(string, event, string3, string2);
        }
    }

    protected class Window
    implements org.apache.batik.script.Window {
        protected Interpreter interpreter;
        protected String language;
        static final String DEFLATE = "deflate";
        static final String GZIP = "gzip";
        static final String UTF_8 = "UTF-8";

        public Window(Interpreter interpreter, String string) {
            this.interpreter = interpreter;
            this.language = string;
        }

        public Object setInterval(String string, long l) {
            TimerTask timerTask = new TimerTask(this, string){
                EvaluateIntervalRunnable eir;
                private final /* synthetic */ String val$script;
                private final /* synthetic */ Window this$1;
                {
                    this.this$1 = window;
                    this.val$script = string;
                    this.eir = Window.access$000(this.this$1).new EvaluateIntervalRunnable(this.val$script, this.this$1.interpreter);
                }

                public void run() {
                    EvaluateIntervalRunnable evaluateIntervalRunnable = this.eir;
                    synchronized (evaluateIntervalRunnable) {
                        if (this.eir.count > 1) {
                            return;
                        }
                        ++this.eir.count;
                    }
                    Object object = Window.access$000((Window)this.this$1).updateRunnableQueue.getIteratorLock();
                    synchronized (object) {
                        if (Window.access$000((Window)this.this$1).updateRunnableQueue.getThread() == null) {
                            this.cancel();
                            return;
                        }
                        Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater((Runnable)this.eir);
                    }
                    EvaluateIntervalRunnable evaluateIntervalRunnable2 = this.eir;
                    synchronized (evaluateIntervalRunnable2) {
                        if (this.eir.error) {
                            this.cancel();
                        }
                    }
                }
            };
            ScriptingEnvironment.this.timer.schedule(timerTask, l, l);
            return timerTask;
        }

        public Object setInterval(Runnable runnable, long l) {
            TimerTask timerTask = new TimerTask(this, runnable){
                EvaluateRunnableRunnable eihr;
                private final /* synthetic */ Runnable val$r;
                private final /* synthetic */ Window this$1;
                {
                    this.this$1 = window;
                    this.val$r = runnable;
                    this.eihr = Window.access$000(this.this$1).new EvaluateRunnableRunnable(this.val$r);
                }

                public void run() {
                    EvaluateRunnableRunnable evaluateRunnableRunnable = this.eihr;
                    synchronized (evaluateRunnableRunnable) {
                        if (this.eihr.count > 1) {
                            return;
                        }
                        ++this.eihr.count;
                    }
                    Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater((Runnable)this.eihr);
                    EvaluateRunnableRunnable evaluateRunnableRunnable2 = this.eihr;
                    synchronized (evaluateRunnableRunnable2) {
                        if (this.eihr.error) {
                            this.cancel();
                        }
                    }
                }
            };
            ScriptingEnvironment.this.timer.schedule(timerTask, l, l);
            return timerTask;
        }

        public void clearInterval(Object object) {
            if (object == null) {
                return;
            }
            ((TimerTask)object).cancel();
        }

        public Object setTimeout(String string, long l) {
            TimerTask timerTask = new TimerTask(this, string){
                private final /* synthetic */ String val$script;
                private final /* synthetic */ Window this$1;
                {
                    this.this$1 = window;
                    this.val$script = string;
                }

                public void run() {
                    Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater((Runnable)Window.access$000(this.this$1).new EvaluateRunnable(this.val$script, this.this$1.interpreter));
                }
            };
            ScriptingEnvironment.this.timer.schedule(timerTask, l);
            return timerTask;
        }

        public Object setTimeout(Runnable runnable, long l) {
            TimerTask timerTask = new TimerTask(this, runnable){
                private final /* synthetic */ Runnable val$r;
                private final /* synthetic */ Window this$1;
                {
                    this.this$1 = window;
                    this.val$r = runnable;
                }

                public void run() {
                    Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(new Runnable(this){
                        private final /* synthetic */ 4 this$2;
                        {
                            this.this$2 = var1_1;
                        }

                        public void run() {
                            block2: {
                                try {
                                    4.access$100(this.this$2).run();
                                }
                                catch (Exception exception) {
                                    if (Window.access$000((Window)4.access$200(this.this$2)).userAgent == null) break block2;
                                    Window.access$000((Window)4.access$200(this.this$2)).userAgent.displayError(exception);
                                }
                            }
                        }
                    });
                }

                static /* synthetic */ Runnable access$100(4 var0) {
                    return var0.val$r;
                }

                static /* synthetic */ Window access$200(4 var0) {
                    return var0.this$1;
                }
            };
            ScriptingEnvironment.this.timer.schedule(timerTask, l);
            return timerTask;
        }

        public void clearTimeout(Object object) {
            if (object == null) {
                return;
            }
            ((TimerTask)object).cancel();
        }

        public Node parseXML(String string, Document node) {
            Node node2;
            Object object;
            Object object2;
            String string2;
            block14: {
                SAXSVGDocumentFactory sAXSVGDocumentFactory = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());
                URL uRL = null;
                if (node != null && node instanceof SVGOMDocument) {
                    uRL = ((SVGOMDocument)node).getURLObject();
                }
                if (uRL == null) {
                    uRL = ((SVGOMDocument)ScriptingEnvironment.this.bridgeContext.getDocument()).getURLObject();
                }
                string2 = uRL == null ? "" : uRL.toString();
                try {
                    Document document = sAXSVGDocumentFactory.createDocument(string2, (Reader)new StringReader(string));
                    if (node == null) {
                        return document;
                    }
                    DocumentFragment documentFragment = node.createDocumentFragment();
                    documentFragment.appendChild(node.importNode(document.getDocumentElement(), true));
                    return documentFragment;
                }
                catch (Exception exception) {
                    if (node == null || !(node instanceof SVGOMDocument)) break block14;
                    object2 = new StringBuffer(ScriptingEnvironment.FRAGMENT_PREFIX.length() + string.length() + ScriptingEnvironment.FRAGMENT_SUFFIX.length());
                    ((StringBuffer)object2).append(ScriptingEnvironment.FRAGMENT_PREFIX);
                    ((StringBuffer)object2).append(string);
                    ((StringBuffer)object2).append(ScriptingEnvironment.FRAGMENT_SUFFIX);
                    object = ((StringBuffer)object2).toString();
                    try {
                        node2 = sAXSVGDocumentFactory.createDocument(string2, (Reader)new StringReader((String)object));
                        if (node == null) {
                            node = node2;
                        }
                        Node node3 = node2.getDocumentElement().getFirstChild();
                        while (node3 != null) {
                            if (node3.getNodeType() == 1) {
                                node3 = node.importNode(node3, true);
                                DocumentFragment documentFragment = node.createDocumentFragment();
                                documentFragment.appendChild(node3);
                                return documentFragment;
                            }
                            node3 = node3.getNextSibling();
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
            object2 = node != null ? new SAXDocumentFactory(node.getImplementation(), XMLResourceDescriptor.getXMLParserClassName()) : new SAXDocumentFactory((DOMImplementation)new GenericDOMImplementation(), XMLResourceDescriptor.getXMLParserClassName());
            try {
                object = object2.createDocument(string2, (Reader)new StringReader(string));
                if (node == null) {
                    return object;
                }
                node2 = node.createDocumentFragment();
                node2.appendChild(node.importNode(object.getDocumentElement(), true));
                return node2;
            }
            catch (Exception exception) {
                if (ScriptingEnvironment.this.userAgent != null) {
                    ScriptingEnvironment.this.userAgent.displayError(exception);
                }
                return null;
            }
        }

        public void getURL(String string, Window.URLResponseHandler uRLResponseHandler) {
            this.getURL(string, uRLResponseHandler, null);
        }

        public void getURL(String string, Window.URLResponseHandler uRLResponseHandler, String string2) {
            Thread thread = new Thread(this, string, string2, uRLResponseHandler){
                private final /* synthetic */ String val$uri;
                private final /* synthetic */ String val$enc;
                private final /* synthetic */ Window.URLResponseHandler val$h;
                private final /* synthetic */ Window this$1;
                {
                    this.this$1 = window;
                    this.val$uri = string;
                    this.val$enc = string2;
                    this.val$h = uRLResponseHandler;
                }

                public void run() {
                    try {
                        int n;
                        Reader reader;
                        URL uRL = ((SVGOMDocument)Window.access$000((Window)this.this$1).document).getURLObject();
                        ParsedURL parsedURL = new ParsedURL(uRL, this.val$uri);
                        String string = null;
                        if (this.val$enc != null) {
                            string = EncodingUtilities.javaEncoding((String)this.val$enc);
                            string = string == null ? this.val$enc : string;
                        }
                        InputStream inputStream = parsedURL.openStream();
                        if (string == null) {
                            reader = new InputStreamReader(inputStream);
                        } else {
                            try {
                                reader = new InputStreamReader(inputStream, string);
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                reader = new InputStreamReader(inputStream);
                            }
                        }
                        reader = new BufferedReader(reader);
                        StringBuffer stringBuffer = new StringBuffer();
                        char[] cArray = new char[4096];
                        while ((n = reader.read(cArray, 0, cArray.length)) != -1) {
                            stringBuffer.append(cArray, 0, n);
                        }
                        reader.close();
                        Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(new Runnable(this, parsedURL, stringBuffer){
                            private final /* synthetic */ ParsedURL val$purl;
                            private final /* synthetic */ StringBuffer val$sb;
                            private final /* synthetic */ 6 this$2;
                            {
                                this.this$2 = var1_1;
                                this.val$purl = parsedURL;
                                this.val$sb = stringBuffer;
                            }

                            public void run() {
                                block2: {
                                    try {
                                        6.access$300(this.this$2).getURLDone(true, this.val$purl.getContentType(), this.val$sb.toString());
                                    }
                                    catch (Exception exception) {
                                        if (Window.access$000((Window)6.access$400(this.this$2)).userAgent == null) break block2;
                                        Window.access$000((Window)6.access$400(this.this$2)).userAgent.displayError(exception);
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception exception) {
                        if (exception instanceof SecurityException) {
                            Window.access$000((Window)this.this$1).userAgent.displayError(exception);
                        }
                        Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(new Runnable(this){
                            private final /* synthetic */ 6 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public void run() {
                                block2: {
                                    try {
                                        6.access$300(this.this$2).getURLDone(false, null, null);
                                    }
                                    catch (Exception exception) {
                                        if (Window.access$000((Window)6.access$400(this.this$2)).userAgent == null) break block2;
                                        Window.access$000((Window)6.access$400(this.this$2)).userAgent.displayError(exception);
                                    }
                                }
                            }
                        });
                    }
                }

                static /* synthetic */ Window.URLResponseHandler access$300(6 var0) {
                    return var0.val$h;
                }

                static /* synthetic */ Window access$400(6 var0) {
                    return var0.this$1;
                }
            };
            thread.setPriority(1);
            thread.start();
        }

        public void postURL(String string, String string2, Window.URLResponseHandler uRLResponseHandler) {
            this.postURL(string, string2, uRLResponseHandler, "text/plain", null);
        }

        public void postURL(String string, String string2, Window.URLResponseHandler uRLResponseHandler, String string3) {
            this.postURL(string, string2, uRLResponseHandler, string3, null);
        }

        public void postURL(String string, String string2, Window.URLResponseHandler uRLResponseHandler, String string3, String string4) {
            Thread thread = new Thread(this, string, string3, string4, string2, uRLResponseHandler){
                private final /* synthetic */ String val$uri;
                private final /* synthetic */ String val$mimeType;
                private final /* synthetic */ String val$fEnc;
                private final /* synthetic */ String val$content;
                private final /* synthetic */ Window.URLResponseHandler val$h;
                private final /* synthetic */ Window this$1;
                {
                    this.this$1 = window;
                    this.val$uri = string;
                    this.val$mimeType = string2;
                    this.val$fEnc = string3;
                    this.val$content = string4;
                    this.val$h = uRLResponseHandler;
                }

                public void run() {
                    try {
                        int n;
                        URL uRL = ((SVGOMDocument)Window.access$000((Window)this.this$1).document).getURLObject();
                        URL uRL2 = uRL != null ? new URL(uRL, this.val$uri) : new URL(this.val$uri);
                        URLConnection uRLConnection = uRL2.openConnection();
                        uRLConnection.setDoOutput(true);
                        uRLConnection.setDoInput(true);
                        uRLConnection.setUseCaches(false);
                        uRLConnection.setRequestProperty("Content-Type", this.val$mimeType);
                        OutputStream outputStream = uRLConnection.getOutputStream();
                        String string = null;
                        String string2 = this.val$fEnc;
                        if (string2 != null) {
                            if (string2.startsWith("deflate")) {
                                outputStream = new DeflaterOutputStream(outputStream);
                                string2 = string2.length() > "deflate".length() ? string2.substring("deflate".length() + 1) : "";
                                uRLConnection.setRequestProperty("Content-Encoding", "deflate");
                            }
                            if (string2.startsWith("gzip")) {
                                outputStream = new GZIPOutputStream(outputStream);
                                string2 = string2.length() > "gzip".length() ? string2.substring("gzip".length() + 1) : "";
                                uRLConnection.setRequestProperty("Content-Encoding", "deflate");
                            }
                            if (string2.length() != 0) {
                                string = EncodingUtilities.javaEncoding((String)string2);
                                if (string == null) {
                                    string = "UTF-8";
                                }
                            } else {
                                string = "UTF-8";
                            }
                        }
                        OutputStreamWriter outputStreamWriter = string == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, string);
                        outputStreamWriter.write(this.val$content);
                        ((Writer)outputStreamWriter).flush();
                        ((Writer)outputStreamWriter).close();
                        outputStream.close();
                        InputStream inputStream = uRLConnection.getInputStream();
                        string = "UTF-8";
                        Reader reader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
                        reader = new BufferedReader(reader);
                        StringBuffer stringBuffer = new StringBuffer();
                        char[] cArray = new char[4096];
                        while ((n = reader.read(cArray, 0, cArray.length)) != -1) {
                            stringBuffer.append(cArray, 0, n);
                        }
                        reader.close();
                        Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(new Runnable(this, uRLConnection, stringBuffer){
                            private final /* synthetic */ URLConnection val$conn;
                            private final /* synthetic */ StringBuffer val$sb;
                            private final /* synthetic */ 9 this$2;
                            {
                                this.this$2 = var1_1;
                                this.val$conn = uRLConnection;
                                this.val$sb = stringBuffer;
                            }

                            public void run() {
                                block2: {
                                    try {
                                        9.access$500(this.this$2).getURLDone(true, this.val$conn.getContentType(), this.val$sb.toString());
                                    }
                                    catch (Exception exception) {
                                        if (Window.access$000((Window)9.access$600(this.this$2)).userAgent == null) break block2;
                                        Window.access$000((Window)9.access$600(this.this$2)).userAgent.displayError(exception);
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception exception) {
                        if (exception instanceof SecurityException) {
                            Window.access$000((Window)this.this$1).userAgent.displayError(exception);
                        }
                        Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(new Runnable(this){
                            private final /* synthetic */ 9 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public void run() {
                                block2: {
                                    try {
                                        9.access$500(this.this$2).getURLDone(false, null, null);
                                    }
                                    catch (Exception exception) {
                                        if (Window.access$000((Window)9.access$600(this.this$2)).userAgent == null) break block2;
                                        Window.access$000((Window)9.access$600(this.this$2)).userAgent.displayError(exception);
                                    }
                                }
                            }
                        });
                    }
                }

                static /* synthetic */ Window.URLResponseHandler access$500(9 var0) {
                    return var0.val$h;
                }

                static /* synthetic */ Window access$600(9 var0) {
                    return var0.this$1;
                }
            };
            thread.setPriority(1);
            thread.start();
        }

        public void alert(String string) {
            if (ScriptingEnvironment.this.userAgent != null) {
                ScriptingEnvironment.this.userAgent.showAlert(string);
            }
        }

        public boolean confirm(String string) {
            if (ScriptingEnvironment.this.userAgent != null) {
                return ScriptingEnvironment.this.userAgent.showConfirm(string);
            }
            return false;
        }

        public String prompt(String string) {
            if (ScriptingEnvironment.this.userAgent != null) {
                return ScriptingEnvironment.this.userAgent.showPrompt(string);
            }
            return null;
        }

        public String prompt(String string, String string2) {
            if (ScriptingEnvironment.this.userAgent != null) {
                return ScriptingEnvironment.this.userAgent.showPrompt(string, string2);
            }
            return null;
        }

        public BridgeContext getBridgeContext() {
            return ScriptingEnvironment.this.bridgeContext;
        }

        public Interpreter getInterpreter() {
            return this.interpreter;
        }

        static /* synthetic */ ScriptingEnvironment access$000(Window window) {
            return window.ScriptingEnvironment.this;
        }
    }
}

