/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.compiler.templates;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jet.JET2Template;
import org.eclipse.jet.JET2TemplateLoader;
import org.eclipse.jet.JET2TemplateLoaderExtension;
import org.eclipse.jet.internal.compiler.templates.DummyMain;
import org.eclipse.jet.internal.compiler.templates.JET2JavaGenerator;
import org.eclipse.jet.internal.compiler.templates.JET2TransformGenerator;
import org.eclipse.jet.internal.compiler.templates.JETTemplateMapGenerator;
import org.eclipse.jet.internal.compiler.templates.TagDataDeclGenerator;
import org.eclipse.jet.internal.compiler.templates.WriteJavaExpressionTemplate;
import org.eclipse.jet.internal.compiler.templates.WriteTextElementTemplate;
import org.eclipse.jet.internal.compiler.templates.XMLEndGenerator;
import org.eclipse.jet.internal.compiler.templates.XMLStartGenerator;
import org.eclipse.jet.internal.compiler.templates.v1.JET1JavaGenerator;
import org.eclipse.jet.internal.compiler.templates.v2.JET2JavaGeneratorNew;

public class CodeGenTemplateLoader
implements JET2TemplateLoader,
JET2TemplateLoaderExtension {
    private JET2TemplateLoader delegate = null;
    private static Map pathToTemplateOrdinalMap = null;

    public JET2TemplateLoader getDelegateLoader() {
        return this.delegate;
    }

    public JET2Template getTemplate(String templatePath) {
        Integer ordinal;
        if (pathToTemplateOrdinalMap == null) {
            CodeGenTemplateLoader.initPathToFactoryMap();
        }
        switch ((ordinal = (Integer)pathToTemplateOrdinalMap.get(templatePath)) != null ? ordinal : -1) {
            case 0: {
                return new JET2JavaGenerator();
            }
            case 1: {
                return new JET2TransformGenerator();
            }
            case 2: {
                return new JETTemplateMapGenerator();
            }
            case 3: {
                return new DummyMain();
            }
            case 4: {
                return new TagDataDeclGenerator();
            }
            case 5: {
                return new JET1JavaGenerator();
            }
            case 6: {
                return new JET2JavaGeneratorNew();
            }
            case 7: {
                return new WriteJavaExpressionTemplate();
            }
            case 8: {
                return new WriteTextElementTemplate();
            }
            case 9: {
                return new XMLEndGenerator();
            }
            case 10: {
                return new XMLStartGenerator();
            }
        }
        return this.delegate != null ? this.delegate.getTemplate(templatePath) : null;
    }

    private static synchronized void initPathToFactoryMap() {
        if (pathToTemplateOrdinalMap == null) {
            pathToTemplateOrdinalMap = new HashMap(11);
            pathToTemplateOrdinalMap.put("templates/jet2java.jet", new Integer(0));
            pathToTemplateOrdinalMap.put("templates/jet2transform.jet", new Integer(1));
            pathToTemplateOrdinalMap.put("templates/jetTemplateMap.properties.jet", new Integer(2));
            pathToTemplateOrdinalMap.put("templates/main.jet", new Integer(3));
            pathToTemplateOrdinalMap.put("templates/tagDataDeclarations.jet", new Integer(4));
            pathToTemplateOrdinalMap.put("templates/v1/jet2java.jet", new Integer(5));
            pathToTemplateOrdinalMap.put("templates/v2/jet2java.jet", new Integer(6));
            pathToTemplateOrdinalMap.put("templates/writeJavaExpression.jet", new Integer(7));
            pathToTemplateOrdinalMap.put("templates/writeTextElement.jet", new Integer(8));
            pathToTemplateOrdinalMap.put("templates/xmlEnd.jet", new Integer(9));
            pathToTemplateOrdinalMap.put("templates/xmlStart.jet", new Integer(10));
        }
    }

    public void setDelegateLoader(JET2TemplateLoader loader) {
        this.delegate = loader;
    }
}

