/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.compiler.templates.v1;

import java.util.Iterator;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Template;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.core.parser.ast.JETASTVisitor;
import org.eclipse.jet.core.parser.ast.JETCompilationUnit;
import org.eclipse.jet.core.parser.ast.JavaDeclaration;
import org.eclipse.jet.core.parser.ast.JavaElement;
import org.eclipse.jet.core.parser.ast.JavaExpression;
import org.eclipse.jet.core.parser.ast.JavaScriptlet;
import org.eclipse.jet.core.parser.ast.TextElement;
import org.eclipse.jet.internal.JavaUtil;
import org.eclipse.jet.internal.compiler.SafeJETASTVisitor;

public class JET1JavaGenerator
implements JET2Template {
    private static final String NL = System.getProperty("line.separator");

    public void generate(JET2Context context, JET2Writer __out) {
        JET2Writer out = __out;
        JETCompilationUnit cu = (JETCompilationUnit)context.getVariable("cu");
        out.write("package ");
        out.write(cu.getOutputJavaPackage());
        out.write(";");
        out.write(NL);
        out.write(NL);
        Iterator i = cu.getImports().iterator();
        while (i.hasNext()) {
            String importName = (String)i.next();
            out.write("import ");
            out.write(importName);
            out.write(";");
            out.write(NL);
        }
        out.write(NL);
        out.write("public class ");
        out.write(cu.getOutputJavaClassName());
        out.write(NL);
        out.write("{");
        out.write(NL);
        cu.accept((JETASTVisitor)new SafeJETASTVisitor(context, out){

            public boolean visit(JavaDeclaration decl) {
                this.writeAndRecord((JavaElement)decl);
                this.out.write("\t");
                this.out.write(NL);
                return true;
            }
        });
        out.write("  protected static String nl;");
        out.write(NL);
        out.write("  public static synchronized ");
        out.write(cu.getOutputJavaClassName());
        out.write(" create(String lineSeparator)");
        out.write(NL);
        out.write("  {");
        out.write(NL);
        out.write("    nl = lineSeparator;");
        out.write(NL);
        out.write("    ");
        out.write(cu.getOutputJavaClassName());
        out.write(" result = new ");
        out.write(cu.getOutputJavaClassName());
        out.write("();");
        out.write(NL);
        out.write("    nl = null;");
        out.write(NL);
        out.write("    return result;");
        out.write(NL);
        out.write("  }");
        out.write(NL);
        out.write(NL);
        out.write("  protected final String NL = nl == null ? (System.getProperties().getProperty(\"line.separator\")) : nl; //$NON-NLS-1$");
        out.write(NL);
        cu.accept((JETASTVisitor)new SafeJETASTVisitor(context, out){
            private int textCount;
            {
                this.textCount = 0;
            }

            public boolean visit(TextElement text) {
                if (text.getText().length > 0) {
                    ++this.textCount;
                    this.out.write("  protected final String TEXT_");
                    this.out.write(this.textCount);
                    this.out.write(" = ");
                    this.out.write(JavaUtil.asJavaQuoteStringWithNLRemoved(text.getText()));
                    this.out.write(";");
                    this.out.write(JavaUtil.nlsCommentsForJavaQuoteStringWithNLRemoved(text.getText()));
                    this.out.write(NL);
                }
                return true;
            }
        });
        out.write(NL);
        out.write("  public String generate(Object argument)");
        out.write(NL);
        out.write("  {");
        out.write(NL);
        out.write("    final StringBuffer stringBuffer = new StringBuffer();");
        out.write(NL);
        cu.accept((JETASTVisitor)new SafeJETASTVisitor(context, out){
            private int textCount;
            {
                this.textCount = 0;
            }

            public boolean visit(TextElement text) {
                if (text.getText().length > 0) {
                    ++this.textCount;
                    this.out.write("    stringBuffer.append(TEXT_");
                    this.out.write(this.textCount);
                    this.out.write(");");
                    this.out.write(NL);
                }
                return true;
            }

            public boolean visit(JavaScriptlet scriptlet) {
                this.writeAndRecord((JavaElement)scriptlet);
                this.out.write(NL);
                return true;
            }

            public boolean visit(JavaExpression expr) {
                this.out.write("    stringBuffer.append(");
                this.writeAndRecord((JavaElement)expr);
                this.out.write(");");
                this.out.write(NL);
                return true;
            }
        });
        out.write("    return stringBuffer.toString();");
        out.write(NL);
        out.write("  }");
        out.write(NL);
        out.write("}");
        out.write(NL);
    }
}

