/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.runtime;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.extensionpoints.TransformData;
import org.eclipse.jet.internal.extensionpoints.TransformDataFactory;
import org.eclipse.jet.internal.runtime.IJETBundleProvider;
import org.eclipse.jet.internal.runtime.JETBundleManager;
import org.eclipse.jet.internal.runtime.JETBundleManifest;
import org.eclipse.jet.internal.runtime.NotABundleException;
import org.eclipse.jet.internal.runtime.ProjectJETBundleDescriptor;
import org.eclipse.jet.transform.IJETBundleDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class ProjectJETBundleProvider
implements IResourceChangeListener,
IJETBundleProvider {
    private final Map descriptorsById = Collections.synchronizedMap(new HashMap());
    private final Map projectNameToIdMap = Collections.synchronizedMap(new HashMap());

    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 2: 
            case 4: {
                this.handleProjectChange((IProject)event.getResource());
                break;
            }
            case 1: {
                this.handleWorkspaceChange(event.getDelta());
            }
        }
    }

    public void startup() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            try {
                if (projects[i].exists() && projects[i].isOpen() && projects[i].hasNature("org.eclipse.jet.jet2Nature")) {
                    this.updateJETProject(projects[i]);
                }
            }
            catch (CoreException e) {
                InternalJET2Platform.logError("Exception caught in \"should never happen\" catch clause", (Exception)((Object)e));
            }
            ++i;
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void shutdown() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.descriptorsById.clear();
        this.projectNameToIdMap.clear();
    }

    private void handleProjectChange(IProject project) {
        try {
            if (project.isOpen() && project.exists() && project.hasNature("org.eclipse.jet.jet2Nature")) {
                this.removeJETProject(project.getName());
            }
        }
        catch (CoreException e) {
            InternalJET2Platform.logError("Exception caught in \"should never happen\" catch clause", (Exception)((Object)e));
        }
    }

    private void handleWorkspaceChange(IResourceDelta delta) {
        try {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta childDelta) throws CoreException {
                    switch (childDelta.getResource().getType()) {
                        case 8: {
                            return true;
                        }
                        case 4: {
                            IProject project = (IProject)childDelta.getResource();
                            if (project.exists() && project.isOpen() && project.hasNature("org.eclipse.jet.jet2Nature")) {
                                IResourceDelta manifestDelta = childDelta.findMember((IPath)new Path("META-INF/MANIFEST.MF"));
                                IResourceDelta pluginXML = childDelta.findMember((IPath)new Path("plugin.xml"));
                                if (manifestDelta != null || pluginXML != null) {
                                    ProjectJETBundleProvider.this.updateJETProject(project);
                                }
                                return true;
                            }
                            return false;
                        }
                        case 2: {
                            IFolder folder = (IFolder)childDelta.getResource();
                            return folder.getProjectRelativePath().equals((Object)new Path("META-INF/MANIFEST.MF").removeLastSegments(1));
                        }
                    }
                    return false;
                }
            });
        }
        catch (CoreException e) {
            InternalJET2Platform.logError("Exception caught in \"should never happen\" catch clause", (Exception)((Object)e));
        }
    }

    public Set getAllJETBundleIds() {
        return this.descriptorsById.keySet();
    }

    public IJETBundleDescriptor getDescriptor(String id) {
        return (IJETBundleDescriptor)this.descriptorsById.get(id);
    }

    private void removeJETProject(String projectName) {
        String id = (String)this.projectNameToIdMap.get(projectName);
        if (id != null) {
            this.projectNameToIdMap.remove(projectName);
            this.descriptorsById.remove(id);
        }
    }

    private void updateJETProject(IProject project) {
        String projectName = project.getName();
        try {
            URL projectURL = new URL("platform:/resource/" + project.getName() + "/");
            JETBundleManifest manifest = JETBundleManager.loadManifest(projectURL);
            String transformId = manifest.getTransformId();
            TransformData transformData = TransformDataFactory.INSTANCE.createTransformData(transformId, projectURL);
            this.descriptorsById.put(transformId, new ProjectJETBundleDescriptor(manifest, transformData, projectURL, projectName));
            this.projectNameToIdMap.put(projectName, transformId);
        }
        catch (MalformedURLException e) {
            InternalJET2Platform.logError(e.getMessage(), e);
        }
        catch (IOException iOException) {
        }
        catch (NotABundleException notABundleException) {}
    }

    public IJETBundleDescriptor getDescriptorForProject(String name) {
        IProject project;
        IJETBundleDescriptor result = null;
        String id = (String)this.projectNameToIdMap.get(name);
        if (id == null && this.isOpenJETProject(project = ResourcesPlugin.getWorkspace().getRoot().getProject(name))) {
            this.updateJETProject(project);
            id = (String)this.projectNameToIdMap.get(name);
        }
        if (id != null) {
            result = (IJETBundleDescriptor)this.descriptorsById.get(id);
        }
        return result;
    }

    private boolean isOpenJETProject(IProject project) {
        try {
            return project != null && project.exists() && project.isOpen() && project.hasNature("org.eclipse.jet.jet2Nature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public String getProjectForId(String id) {
        ProjectJETBundleDescriptor descriptor = (ProjectJETBundleDescriptor)this.getDescriptor(id);
        return descriptor == null ? null : descriptor.getProjectName();
    }

    public Bundle load(String id, IProgressMonitor monitor) throws BundleException {
        Bundle bundle = null;
        ProjectJETBundleDescriptor descriptor = (ProjectJETBundleDescriptor)this.getDescriptor(id);
        if (descriptor != null && this.ensureProjectIsBuilt(descriptor.getProjectName(), monitor)) {
            URL baseURL = descriptor.getBaseURL();
            try {
                URL baseFileURL = FileLocator.toFileURL((URL)baseURL);
                bundle = InternalJET2Platform.getDefault().getJETBundleInstaller().installBundle(baseFileURL);
            }
            catch (IOException e) {
                new BundleException(MessageFormat.format("Could not convert URL ''{0}'' to ''file'' protocol", baseURL), (Throwable)e);
            }
        }
        return bundle;
    }

    public void unload(String id) throws BundleException {
        if (this.descriptorsById.containsKey(id)) {
            Bundle bundle = Platform.getBundle((String)id);
            this.unload(bundle);
        }
    }

    private boolean ensureProjectIsBuilt(String name, IProgressMonitor monitor) {
        try {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            project.build(10, monitor);
            return true;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void unload(Bundle bundle) throws BundleException {
        if (bundle != null) {
            bundle.uninstall();
        }
    }

    public Collection getAllJETBundleDescriptors() {
        return this.descriptorsById.values();
    }
}

