/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.editor.navigation;

import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.xtend.shared.ui.Messages;
import org.eclipse.xtend.shared.ui.editor.AbstractXtendXpandEditor;
import org.eclipse.xtend.shared.ui.editor.navigation.GenericHyperlinkDetector;

public class OpenAction
extends SelectionDispatchAction {
    private final AbstractXtendXpandEditor editor;

    public OpenAction(AbstractXtendXpandEditor editor) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.editor = editor;
        this.setText(Messages.OpenAction_ActionName);
        this.setEnabled(editor.getEditorInput() instanceof IFileEditorInput);
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(this.checkEnabled(selection));
    }

    private boolean checkEnabled(ITextSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        return this.editor.getEditorInput() instanceof IFileEditorInput;
    }

    public void run(ITextSelection selection) {
        if (!this.checkEnabled(selection)) {
            return;
        }
        Region region = new Region(selection.getOffset(), selection.getLength());
        GenericHyperlinkDetector detector = new GenericHyperlinkDetector((IEditorPart)this.editor);
        IHyperlink[] hyperlinks = detector.detectHyperlinks((ITextViewer)this.editor.internalGetSourceViewer(), (IRegion)region, false);
        if (hyperlinks != null && hyperlinks.length == 1) {
            hyperlinks[0].open();
        }
    }
}

