/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.internal.evaluation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.acceleo.engine.AcceleoEvaluationCancelledException;
import org.eclipse.acceleo.engine.AcceleoEvaluationException;
import org.eclipse.acceleo.engine.internal.debug.ASTFragment;
import org.eclipse.acceleo.engine.internal.debug.IDebugAST;
import org.eclipse.acceleo.engine.internal.environment.AcceleoEvaluationEnvironment;
import org.eclipse.acceleo.engine.internal.evaluation.AcceleoEvaluationContext;
import org.eclipse.acceleo.model.mtl.Block;
import org.eclipse.acceleo.model.mtl.FileBlock;
import org.eclipse.acceleo.model.mtl.ForBlock;
import org.eclipse.acceleo.model.mtl.IfBlock;
import org.eclipse.acceleo.model.mtl.InitSection;
import org.eclipse.acceleo.model.mtl.LetBlock;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.MtlFactory;
import org.eclipse.acceleo.model.mtl.MtlPackage;
import org.eclipse.acceleo.model.mtl.ProtectedAreaBlock;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.model.mtl.QueryInvocation;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.acceleo.model.mtl.TemplateInvocation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.EvaluationVisitor;
import org.eclipse.ocl.EvaluationVisitorDecorator;
import org.eclipse.ocl.ecore.StringLiteralExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoEvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>
extends EvaluationVisitorDecorator<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> {
    private static IDebugAST debug;
    private static final Object NULL_QUERY_RESULT;
    private static final String SELF_VARIABLE_NAME = "self";
    private static final String UNDEFINED_GUARD_MESSAGE_KEY = "AcceleoEvaluationVisitor.UndefinedGuard";
    private static final Object UNDEFINED_QUERY_RESULT;
    private final AcceleoEvaluationContext context;
    private EObject lastEObjectSelfValue;
    private OCLExpression<C> lastSourceExpression;
    private Object lastSourceExpressionResult;
    private final Object oclInvalid = this.getEnvironment().getOCLStandardLibrary().getOclInvalid();
    private final Map<Query, Map<List<Object>, Object>> queryResults = new HashMap<Query, Map<List<Object>, Object>>();
    private boolean fireGenerationEvent;

    static {
        NULL_QUERY_RESULT = new Object();
        UNDEFINED_QUERY_RESULT = new Object();
    }

    public AcceleoEvaluationVisitor(EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> decoratedVisitor, AcceleoEvaluationContext context) {
        super(decoratedVisitor);
        this.context = context;
    }

    public static void setDebug(IDebugAST acceleoDebug) {
        debug = acceleoDebug;
    }

    public void visitAcceleoBlock(Block block) {
        for (OCLExpression nested : block.getBody()) {
            this.visitExpression(nested);
        }
    }

    public void visitAcceleoFileBlock(FileBlock fileBlock) {
        boolean appendMode;
        boolean fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        Object fileURLResult = this.visitExpression((OCLExpression<C>)fileBlock.getFileUrl());
        this.fireGenerationEvent = fireEvents;
        if (this.isUndefined(fileURLResult)) {
            AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedFileURL", fileBlock.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)fileBlock)).getName(), fileBlock.toString(), this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME)));
            exception.fillInStackTrace();
            throw exception;
        }
        if (fileURLResult instanceof Collection) {
            AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.CollectionFileURL", fileBlock.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)fileBlock)).getName(), fileBlock.toString(), this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME)));
            exception.fillInStackTrace();
            throw exception;
        }
        String filePath = String.valueOf(fileURLResult);
        boolean bl = appendMode = fileBlock.getOpenMode().getValue() == 0;
        if ("stdout".equals(filePath)) {
            this.context.openNested(System.out);
        } else {
            Object currentSelf = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
            EObject source = currentSelf instanceof EObject ? (EObject)currentSelf : this.lastEObjectSelfValue;
            this.context.openNested(filePath, (Block)fileBlock, source, appendMode);
        }
        for (OCLExpression nested : fileBlock.getBody()) {
            this.fireGenerationEvent = true;
            this.visitExpression(nested);
            this.fireGenerationEvent = fireEvents;
        }
        this.context.closeContext();
    }

    public void visitAcceleoForBlock(ForBlock forBlock) {
        boolean fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        Object iteration = this.visitExpression((OCLExpression<C>)forBlock.getIterSet());
        this.fireGenerationEvent = fireEvents;
        Variable loopVariable = forBlock.getLoopVariable();
        Object currentSelf = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
        if (this.isUndefined(iteration)) {
            AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.NullForIteration", forBlock.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)forBlock)).getName(), forBlock.toString(), currentSelf));
            exception.fillInStackTrace();
            throw exception;
        }
        if (iteration instanceof Collection) {
            if (((Collection)iteration).size() > 0 && forBlock.getBefore() != null) {
                this.visitExpression((OCLExpression<C>)forBlock.getBefore());
            }
            Iterator contentIterator = ((Collection)iteration).iterator();
            while (contentIterator.hasNext()) {
                Object guardValue;
                Object o = contentIterator.next();
                this.getEvaluationEnvironment().replace(loopVariable.getName(), o);
                this.getEvaluationEnvironment().replace(SELF_VARIABLE_NAME, o);
                if (forBlock.getGuard() == null) {
                    guardValue = Boolean.TRUE;
                } else {
                    this.fireGenerationEvent = false;
                    guardValue = this.visitExpression((OCLExpression<C>)forBlock.getGuard());
                    this.fireGenerationEvent = fireEvents;
                }
                if (this.isInvalid(guardValue)) {
                    AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString(UNDEFINED_GUARD_MESSAGE_KEY, forBlock.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)forBlock)).getName(), forBlock, o, forBlock.getGuard()));
                    exception.fillInStackTrace();
                    throw exception;
                }
                if (guardValue == null || !((Boolean)guardValue).booleanValue()) continue;
                for (OCLExpression nested : forBlock.getBody()) {
                    this.visitExpression(nested);
                }
                if (forBlock.getEach() == null || !contentIterator.hasNext()) continue;
                this.visitExpression((OCLExpression<C>)forBlock.getEach());
            }
            if (((Collection)iteration).size() > 0 && forBlock.getAfter() != null) {
                this.visitExpression((OCLExpression<C>)forBlock.getAfter());
            }
        } else {
            Object guardValue;
            if (forBlock.getBefore() != null) {
                this.visitExpression((OCLExpression<C>)forBlock.getBefore());
            }
            this.getEvaluationEnvironment().replace(loopVariable.getName(), iteration);
            this.getEvaluationEnvironment().replace(SELF_VARIABLE_NAME, iteration);
            if (forBlock.getGuard() == null) {
                guardValue = Boolean.TRUE;
            } else {
                this.fireGenerationEvent = false;
                guardValue = this.visitExpression((OCLExpression<C>)forBlock.getGuard());
                this.fireGenerationEvent = fireEvents;
            }
            if (this.isInvalid(guardValue)) {
                AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString(UNDEFINED_GUARD_MESSAGE_KEY, forBlock.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)forBlock)).getName(), forBlock, iteration, forBlock.getGuard()));
                exception.fillInStackTrace();
                throw exception;
            }
            if (guardValue != null && ((Boolean)guardValue).booleanValue()) {
                for (OCLExpression nested : forBlock.getBody()) {
                    this.visitExpression(nested);
                }
            }
            if (forBlock.getAfter() != null) {
                this.visitExpression((OCLExpression<C>)forBlock.getAfter());
            }
        }
        this.getEvaluationEnvironment().replace(SELF_VARIABLE_NAME, currentSelf);
    }

    public void visitAcceleoIfBlock(IfBlock ifBlock) {
        org.eclipse.ocl.ecore.OCLExpression condition = ifBlock.getIfExpr();
        Object currentSelf = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
        boolean fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        Object conditionValue = this.visitExpression((OCLExpression<C>)condition);
        this.fireGenerationEvent = fireEvents;
        if (this.isInvalid(conditionValue)) {
            AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedCondition", ifBlock.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)ifBlock)).getName(), ifBlock, currentSelf));
            exception.fillInStackTrace();
            throw exception;
        }
        if (conditionValue != null && ((Boolean)conditionValue).booleanValue()) {
            for (OCLExpression nested : ifBlock.getBody()) {
                this.visitExpression(nested);
            }
        } else if (ifBlock.getElseIf().size() > 0) {
            IfBlock temp = null;
            for (IfBlock elseif : ifBlock.getElseIf()) {
                this.fireGenerationEvent = false;
                Object elseValue = this.visitExpression((OCLExpression<C>)elseif.getIfExpr());
                this.fireGenerationEvent = fireEvents;
                if (this.isInvalid(elseValue)) {
                    String rootName = ((Module)EcoreUtil.getRootContainer((EObject)elseif)).getName();
                    AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedElseCondition", elseif.getStartPosition(), rootName, elseif, currentSelf));
                    exception.fillInStackTrace();
                    throw exception;
                }
                if (elseValue == null || !((Boolean)elseValue).booleanValue()) continue;
                temp = elseif;
                break;
            }
            if (temp != null) {
                for (OCLExpression nested : temp.getBody()) {
                    this.visitExpression(nested);
                }
            } else if (ifBlock.getElse() != null) {
                this.visitAcceleoBlock(ifBlock.getElse());
            }
        } else if (ifBlock.getElse() != null) {
            this.visitAcceleoBlock(ifBlock.getElse());
        }
    }

    public void visitAcceleoLetBlock(LetBlock letBlock) {
        Object currentSelf = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
        Variable var = letBlock.getLetVariable();
        boolean fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        Object value = this.visitExpression(var.getInitExpression());
        this.fireGenerationEvent = fireEvents;
        if (this.isInvalid(value)) {
            AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedLetValue", letBlock.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)letBlock)).getName(), letBlock, currentSelf));
            exception.fillInStackTrace();
            throw exception;
        }
        if (((EClassifier)var.getType()).isInstance(value)) {
            this.getEvaluationEnvironment().replace(var.getName(), value);
            for (OCLExpression nested : letBlock.getBody()) {
                this.visitExpression(nested);
            }
        } else if (letBlock.getElseLet().size() > 0) {
            LetBlock temp = null;
            for (LetBlock elseLet : letBlock.getElseLet()) {
                var = elseLet.getLetVariable();
                this.fireGenerationEvent = false;
                value = this.visitExpression(var.getInitExpression());
                this.fireGenerationEvent = fireEvents;
                if (this.isInvalid(value)) {
                    String rootName = ((Module)EcoreUtil.getRootContainer((EObject)elseLet)).getName();
                    AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedElseLetValue", elseLet.getStartPosition(), rootName, elseLet, currentSelf));
                    exception.fillInStackTrace();
                    throw exception;
                }
                if (!((EClassifier)var.getType()).isInstance(value)) continue;
                this.getEvaluationEnvironment().replace(var.getName(), value);
                temp = elseLet;
                break;
            }
            if (temp != null) {
                for (OCLExpression nested : temp.getBody()) {
                    this.visitExpression(nested);
                }
            } else if (letBlock.getElse() != null) {
                this.visitAcceleoBlock(letBlock.getElse());
            }
        } else if (letBlock.getElse() != null) {
            this.visitAcceleoBlock(letBlock.getElse());
        }
    }

    public void visitAcceleoProtectedArea(ProtectedAreaBlock protectedArea) {
        boolean fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        Object markerValue = this.visitExpression((OCLExpression<C>)protectedArea.getMarker());
        this.fireGenerationEvent = fireEvents;
        Object source = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
        if (this.isUndefined(markerValue)) {
            AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedAreaMarker", protectedArea.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)protectedArea)).getName(), protectedArea, source));
            exception.fillInStackTrace();
            throw exception;
        }
        String marker = markerValue.toString().trim();
        String areaContent = this.context.getProtectedAreaContent(marker);
        if (source instanceof EObject) {
            this.lastEObjectSelfValue = (EObject)source;
        }
        if (areaContent != null) {
            this.context.append(areaContent, (Block)protectedArea, this.lastEObjectSelfValue, this.fireGenerationEvent);
        } else {
            this.context.append(AcceleoEngineMessages.getString("usercode.start"), (Block)protectedArea, this.lastEObjectSelfValue, this.fireGenerationEvent);
            this.context.append(String.valueOf(' ') + marker, (Block)protectedArea, this.lastEObjectSelfValue, this.fireGenerationEvent);
            this.visitAcceleoBlock((Block)protectedArea);
            this.context.append(AcceleoEngineMessages.getString("usercode.end"), (Block)protectedArea, this.lastEObjectSelfValue, this.fireGenerationEvent);
        }
    }

    public Object visitAcceleoQueryInvocation(QueryInvocation invocation) {
        Map<Object, Object> results;
        Query query = invocation.getDefinition();
        ArrayList<Object> arguments = new ArrayList<Object>();
        boolean fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        int i = 0;
        while (i < query.getParameter().size()) {
            Object argValue = this.visitExpression((OCLExpression)invocation.getArgument().get(i));
            if (this.isInvalid(argValue)) {
                String rootName = ((Module)EcoreUtil.getRootContainer((EObject)invocation)).getName();
                AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedArgument", invocation.getStartPosition(), rootName, invocation, this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME), invocation.getArgument().get(i)));
                exception.fillInStackTrace();
                throw exception;
            }
            arguments.add(argValue);
            ++i;
        }
        this.fireGenerationEvent = fireEvents;
        if (this.queryResults.containsKey(query)) {
            Map<List<Object>, Object> results2 = this.queryResults.get(query);
            Object result = results2.get(arguments);
            if (result == UNDEFINED_QUERY_RESULT) {
                String rootName = ((Module)EcoreUtil.getRootContainer((EObject)query)).getName();
                AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedQuery", query.getExpression(), invocation.getStartPosition(), rootName, query, this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME)));
                exception.fillInStackTrace();
                throw exception;
            }
            if (result != null) {
                if (result == NULL_QUERY_RESULT) {
                    result = null;
                }
                return result;
            }
        }
        Object[] oldArgs = new Object[invocation.getArgument().size() + 1];
        int i2 = 0;
        while (i2 < query.getParameter().size()) {
            Variable param = (Variable)query.getParameter().get(i2);
            oldArgs[i2] = this.getEvaluationEnvironment().getValueOf(param.getName());
            this.getEvaluationEnvironment().replace(param.getName(), arguments.get(i2));
            if (i2 == 0) {
                oldArgs[oldArgs.length - 1] = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
                this.getEvaluationEnvironment().replace(SELF_VARIABLE_NAME, arguments.get(i2));
            }
            ++i2;
        }
        Object result = this.visitExpression((OCLExpression<C>)query.getExpression());
        int i3 = 0;
        while (i3 < query.getParameter().size()) {
            Variable param = (Variable)query.getParameter().get(i3);
            if (oldArgs[i3] != null) {
                this.getEvaluationEnvironment().replace(param.getName(), oldArgs[i3]);
            } else {
                this.getEvaluationEnvironment().remove(param.getName());
            }
            ++i3;
        }
        if (query.getParameter().size() > 0) {
            this.getEvaluationEnvironment().replace(SELF_VARIABLE_NAME, oldArgs[oldArgs.length - 1]);
        }
        if (this.queryResults.containsKey(query)) {
            results = this.queryResults.get(query);
            if (this.isInvalid(result)) {
                results.put(arguments, UNDEFINED_QUERY_RESULT);
            } else if (result == null) {
                results.put(arguments, NULL_QUERY_RESULT);
            } else {
                results.put(arguments, result);
            }
        } else {
            results = new HashMap(2);
            if (this.isInvalid(result)) {
                results.put(arguments, UNDEFINED_QUERY_RESULT);
            } else if (result == null) {
                results.put(arguments, NULL_QUERY_RESULT);
            } else {
                results.put(arguments, result);
            }
            this.queryResults.put(query, results);
        }
        if (this.isInvalid(result)) {
            String rootName = ((Module)EcoreUtil.getRootContainer((EObject)query)).getName();
            AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedQuery", query.getExpression(), invocation.getStartPosition(), rootName, query, this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME)));
            exception.fillInStackTrace();
            throw exception;
        }
        return result;
    }

    public String visitAcceleoTemplate(Template template) {
        this.context.openNested();
        for (OCLExpression nested : template.getBody()) {
            this.visitExpression(nested);
        }
        return this.context.closeContext();
    }

    public Object visitAcceleoTemplateInvocation(TemplateInvocation invocation) {
        Object source;
        Iterator param;
        Object[] oldArgs;
        Template actualTemplate;
        this.context.openNested();
        Template template = invocation.getDefinition();
        ArrayList<Object> newArguments = new ArrayList<Object>();
        if (invocation.isSuper()) {
            Template containingTemplate = (Template)invocation.eContainer();
            actualTemplate = containingTemplate.eContainer() instanceof TemplateInvocation ? ((TemplateInvocation)containingTemplate.eContainer()).getDefinition() : (Template)template.getOverrides().get(0);
            oldArgs = new Object[containingTemplate.getParameter().size() + 1];
            int i = 0;
            while (i < actualTemplate.getParameter().size()) {
                param = (Variable)actualTemplate.getParameter().get(i);
                oldArgs[i] = this.getEvaluationEnvironment().getValueOf(param.getName());
                Object newArg = this.getEvaluationEnvironment().getValueOf(((Variable)containingTemplate.getParameter().get(i)).getName());
                this.getEvaluationEnvironment().replace(param.getName(), newArg);
                newArguments.add(newArg);
                if (i == 0) {
                    oldArgs[oldArgs.length - 1] = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
                    this.getEvaluationEnvironment().replace(SELF_VARIABLE_NAME, newArg);
                }
                ++i;
            }
        } else {
            oldArgs = new Object[invocation.getArgument().size() + 1];
            boolean fireEvents = this.fireGenerationEvent;
            this.fireGenerationEvent = false;
            for (OCLExpression expression : invocation.getArgument()) {
                Object argValue = this.visitExpression(expression);
                if (this.isInvalid(argValue)) {
                    AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedArgument", invocation.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)invocation)).getName(), invocation, this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME), expression));
                    exception.fillInStackTrace();
                    throw exception;
                }
                newArguments.add(argValue);
            }
            this.fireGenerationEvent = fireEvents;
            List<Template> applicableCandidates = ((AcceleoEvaluationEnvironment)this.getEvaluationEnvironment()).getAllCandidates((Module)EcoreUtil.getRootContainer((EObject)invocation), template, newArguments);
            this.evaluateGuards(applicableCandidates, newArguments);
            if (applicableCandidates.size() > 0) {
                actualTemplate = ((AcceleoEvaluationEnvironment)this.getEvaluationEnvironment()).getMostSpecificTemplate(applicableCandidates, newArguments);
                int i = 0;
                while (i < actualTemplate.getParameter().size()) {
                    Variable param2 = (Variable)actualTemplate.getParameter().get(i);
                    oldArgs[i] = this.getEvaluationEnvironment().getValueOf(param2.getName());
                    this.getEvaluationEnvironment().replace(param2.getName(), newArguments.get(i));
                    if (i == 0) {
                        oldArgs[oldArgs.length - 1] = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
                        this.getEvaluationEnvironment().replace(SELF_VARIABLE_NAME, newArguments.get(i));
                    }
                    ++i;
                }
            } else {
                actualTemplate = MtlFactory.eINSTANCE.createTemplate();
            }
        }
        if (invocation.getBefore() != null) {
            this.visitExpression((OCLExpression<C>)invocation.getBefore());
        }
        if ((source = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME)) instanceof EObject) {
            this.lastEObjectSelfValue = (EObject)source;
        }
        this.context.append(this.visitExpression((OCLExpression<C>)actualTemplate).toString(), (Block)actualTemplate, this.lastEObjectSelfValue, false);
        if (invocation.getAfter() != null) {
            this.visitExpression((OCLExpression<C>)invocation.getAfter());
        }
        int i = 0;
        while (i < actualTemplate.getParameter().size()) {
            param = (Variable)actualTemplate.getParameter().get(i);
            this.getEvaluationEnvironment().replace(param.getName(), oldArgs[i]);
            ++i;
        }
        if (actualTemplate.getParameter().size() > 0) {
            this.getEvaluationEnvironment().replace(SELF_VARIABLE_NAME, oldArgs[oldArgs.length - 1]);
        }
        return this.context.closeContext();
    }

    public Object visitExpression(OCLExpression<C> expression) {
        ASTFragment astFragment;
        EObject debugInput;
        Object result;
        block40: {
            result = null;
            debugInput = null;
            astFragment = null;
            if (debug != null && !(expression instanceof StringLiteralExp)) {
                Object name;
                debugInput = this.lastEObjectSelfValue;
                astFragment = new ASTFragment(expression);
                if (debugInput != null && debugInput.eClass().getEStructuralFeature("name") != null && (name = debugInput.eGet(debugInput.eClass().getEStructuralFeature("name"))) instanceof String) {
                    astFragment.setEObjectNameFilter((String)name);
                }
                debug.startDebug(astFragment);
                debug.stepDebugInput(astFragment, debugInput);
            }
            try {
                boolean hasInit;
                boolean bl = hasInit = expression instanceof Block && ((Block)expression).getInit() != null;
                if (hasInit) {
                    this.handleAcceleoInitSection(((Block)expression).getInit());
                }
                boolean fireEvents = this.fireGenerationEvent;
                if (expression == this.lastSourceExpression) {
                    this.fireGenerationEvent = false;
                }
                if (expression instanceof Template) {
                    result = this.visitAcceleoTemplate((Template)expression);
                } else if (expression instanceof IfBlock) {
                    this.visitAcceleoIfBlock((IfBlock)expression);
                    result = "";
                } else if (expression instanceof ForBlock) {
                    this.visitAcceleoForBlock((ForBlock)expression);
                    result = "";
                } else if (expression instanceof FileBlock) {
                    this.visitAcceleoFileBlock((FileBlock)expression);
                    result = "";
                } else if (expression instanceof TemplateInvocation) {
                    result = this.visitAcceleoTemplateInvocation((TemplateInvocation)expression);
                } else if (expression instanceof QueryInvocation) {
                    result = this.visitAcceleoQueryInvocation((QueryInvocation)expression);
                } else if (expression instanceof LetBlock) {
                    this.visitAcceleoLetBlock((LetBlock)expression);
                    result = "";
                } else if (expression instanceof ProtectedAreaBlock) {
                    this.visitAcceleoProtectedArea((ProtectedAreaBlock)expression);
                    result = "";
                } else {
                    result = super.visitExpression(expression);
                }
                this.fireGenerationEvent = fireEvents;
                if (expression == this.lastSourceExpression) {
                    this.lastSourceExpressionResult = result;
                }
                if (this.shouldGenerateText((EReference)expression.eContainingFeature())) {
                    Object source = null;
                    EObject generatedBlock = expression;
                    while (!(generatedBlock instanceof Block)) {
                        generatedBlock = generatedBlock.eContainer();
                    }
                    if (this.lastSourceExpressionResult == null) {
                        source = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
                    } else {
                        source = this.lastSourceExpressionResult;
                        this.lastSourceExpressionResult = null;
                    }
                    if (source instanceof EObject) {
                        this.lastEObjectSelfValue = (EObject)source;
                    }
                    if (result != null) {
                        boolean fireEvent = this.fireGenerationEvent && !(expression instanceof TemplateInvocation) && !(expression instanceof Template);
                        this.context.append(String.valueOf(result), (Block)generatedBlock, this.lastEObjectSelfValue, fireEvent);
                    }
                }
                if (hasInit) {
                    this.restoreVariables();
                }
            }
            catch (AcceleoEvaluationException e) {
                AcceleoEnginePlugin.log(e, false);
                if (debug != null && !(expression instanceof StringLiteralExp)) {
                    debug.stepDebugOutput(astFragment, debugInput, result);
                    debug.endDebug(astFragment);
                }
                break block40;
            }
            catch (RuntimeException e) {
                try {
                    try {
                        this.context.dispose();
                    }
                    catch (AcceleoEvaluationException acceleoEvaluationException) {}
                    throw e;
                }
                catch (Throwable throwable) {
                    if (debug != null && !(expression instanceof StringLiteralExp)) {
                        debug.stepDebugOutput(astFragment, debugInput, result);
                        debug.endDebug(astFragment);
                    }
                    throw throwable;
                }
            }
            if (debug != null && !(expression instanceof StringLiteralExp)) {
                debug.stepDebugOutput(astFragment, debugInput, result);
                debug.endDebug(astFragment);
            }
        }
        if (this.context.getProgressMonitor().isCanceled()) {
            this.cancel(astFragment, debugInput, result);
        }
        return result;
    }

    private void cancel(ASTFragment astFragment, EObject debugInput, Object result) {
        if (debug != null) {
            debug.stepDebugOutput(astFragment, debugInput, result);
            debug.endDebug(astFragment);
            debug = null;
        }
        this.context.dispose();
        throw new AcceleoEvaluationCancelledException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.CancelException"));
    }

    public Object visitOperationCallExp(OperationCallExp<C, O> callExp) {
        this.lastSourceExpression = callExp.getSource();
        return super.visitOperationCallExp(callExp);
    }

    public Object visitPropertyCallExp(PropertyCallExp<C, P> callExp) {
        this.lastSourceExpression = callExp.getSource();
        return super.visitPropertyCallExp(callExp);
    }

    private void evaluateGuards(List<Template> candidates, List<Object> arguments) {
        boolean fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        AcceleoEvaluationException exception = null;
        for (Template candidate : new ArrayList<Template>(candidates)) {
            Object[] oldArgs = new Object[candidate.getParameter().size() + 1];
            int i = 0;
            while (i < candidate.getParameter().size()) {
                Variable param = (Variable)candidate.getParameter().get(i);
                oldArgs[i] = this.getEvaluationEnvironment().getValueOf(param.getName());
                this.getEvaluationEnvironment().replace(param.getName(), arguments.get(i));
                if (i == 0) {
                    oldArgs[oldArgs.length - 1] = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
                    this.getEvaluationEnvironment().replace(SELF_VARIABLE_NAME, arguments.get(i));
                }
                ++i;
            }
            Object guardValue = candidate.getGuard() == null ? Boolean.TRUE : this.visitExpression((OCLExpression<C>)candidate.getGuard());
            if (this.isInvalid(guardValue)) {
                exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString(UNDEFINED_GUARD_MESSAGE_KEY, candidate.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)candidate)).getName(), candidate, this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME), candidate.getGuard()));
                exception.fillInStackTrace();
                candidates.remove(candidate);
                continue;
            }
            if (guardValue == null || !((Boolean)guardValue).booleanValue()) {
                candidates.remove(candidate);
            }
            int i2 = 0;
            while (i2 < candidate.getParameter().size()) {
                Variable param = (Variable)candidate.getParameter().get(i2);
                this.getEvaluationEnvironment().replace(param.getName(), oldArgs[i2]);
                ++i2;
            }
            if (candidate.getParameter().size() <= 0) continue;
            this.getEvaluationEnvironment().replace(SELF_VARIABLE_NAME, oldArgs[oldArgs.length - 1]);
        }
        if (candidates.size() == 0 && exception != null) {
            throw exception;
        }
        this.fireGenerationEvent = fireEvents;
    }

    private void handleAcceleoInitSection(InitSection init) {
        boolean fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        HashMap<String, Object> oldVariables = new HashMap<String, Object>(init.getVariable().size());
        for (Variable var : init.getVariable()) {
            String varName = var.getName();
            Object oldValue = this.getEvaluationEnvironment().getValueOf(varName);
            oldVariables.put(varName, oldValue);
            Object newValue = this.visitExpression(var.getInitExpression());
            if (this.isInvalid(newValue)) {
                AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedVariable", var.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)init)).getName(), init.eContainer(), this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME), var));
                exception.fillInStackTrace();
                throw exception;
            }
            this.getEvaluationEnvironment().replace(varName, newValue);
        }
        this.context.saveVariableValues(oldVariables);
        this.fireGenerationEvent = fireEvents;
    }

    private boolean isUndefined(Object value) {
        return value == null || value == this.oclInvalid;
    }

    private boolean isInvalid(Object value) {
        return value == this.oclInvalid;
    }

    private void restoreVariables() {
        Map<String, Object> variables = this.context.getLastVariablesValues();
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            this.getEvaluationEnvironment().replace(entry.getKey(), entry.getValue());
        }
    }

    private boolean shouldGenerateText(EReference reference) {
        boolean generate = reference == MtlPackage.eINSTANCE.getBlock_Body();
        generate = generate || reference == MtlPackage.eINSTANCE.getForBlock_Each();
        generate = generate || reference == MtlPackage.eINSTANCE.getTemplateInvocation_Each();
        generate = generate || reference == MtlPackage.eINSTANCE.getForBlock_Before();
        generate = generate || reference == MtlPackage.eINSTANCE.getForBlock_After();
        generate = generate || reference == MtlPackage.eINSTANCE.getTemplateInvocation_Before();
        generate = generate || reference == MtlPackage.eINSTANCE.getTemplateInvocation_After();
        return generate;
    }
}

