/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jet.BodyContentWriter;
import org.eclipse.jet.ContextLogEntry;
import org.eclipse.jet.CoreJETException;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2TemplateLoader;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.XPathContextExtender;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.JETActivatorWrapper;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.runtime.RuntimeLoggerContextExtender;
import org.eclipse.jet.internal.runtime.RuntimeTagLogger;
import org.eclipse.jet.runtime.model.ILoaderManager;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jet.taglib.workspace.WorkspaceContextExtender;
import org.eclipse.jet.transform.IJETBundleDescriptor;
import org.eclipse.jet.transform.IJETBundleManager;
import org.eclipse.jet.transform.IJETRunnable;
import org.eclipse.jet.transform.TransformContextExtender;
import org.eclipse.jet.xpath.XPathFunctionMetaData;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.BundleException;

public class JET2Platform {
    private static boolean DEBUG = InternalJET2Platform.getDefault().isDebugging() && Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jet/debug/traceTagExecution")) != false;
    public static final String PLUGIN_ID = "org.eclipse.jet";
    public static final String JET2_NATURE_ID = "org.eclipse.jet.jet2Nature";

    public static final Object getShellContext() {
        final Object[] shell = new Object[1];
        try {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (PlatformUI.isWorkbenchRunning()) {
                        Display.getDefault().syncExec(new Runnable(this, shell){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ Object[] val$shell;
                            {
                                this.this$1 = var1_1;
                                this.val$shell = objectArray;
                            }

                            public void run() {
                                IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                if (activeWorkbenchWindow != null) {
                                    this.val$shell[0] = activeWorkbenchWindow.getShell();
                                }
                            }
                        });
                    }
                }
            };
            runnable.run();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        return shell[0];
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void addRuntimeProblemMarkersToProject(IProject project, ContextLogEntry contextLog) throws CoreException {
        fileBuffers = new HashSet<IPath>();
        tfbManager = FileBuffers.getTextFileBufferManager();
        project.deleteMarkers("org.eclipse.jet.runtimeProblem", true, 2);
        problems = contextLog.getChildren();
        try {
            i = 0;
            while (i < problems.length) {
                templatePath = problems[i].getTemplatePath();
                if (templatePath != null) {
                    errorResource /* !! */  = templatePath != null ? project.findMember(templatePath) : project;
                    location = errorResource /* !! */ .getFullPath();
                    if (!fileBuffers.contains(location)) {
                        tfbManager.connect(location, (IProgressMonitor)new NullProgressMonitor());
                        fileBuffers.add(location);
                    }
                    textFileBuffer = tfbManager.getTextFileBuffer(location);
                    marker = errorResource /* !! */ .createMarker("org.eclipse.jet.runtimeProblem");
                    switch (problems[i].getSeverity()) {
                        case 4: {
                            marker.setAttribute("severity", 2);
                            break;
                        }
                        case 2: {
                            marker.setAttribute("severity", 1);
                            break;
                        }
                        case 1: {
                            marker.setAttribute("severity", 0);
                            break;
                        }
                    }
                    td = problems[i].getTagInfo();
                    line = problems[i].getLine();
                    col = problems[i].getCol();
                    if (line > 0 && col > 0) {
                        marker.setAttribute("lineNumber", line);
                        try {
                            start = textFileBuffer.getDocument().getLineOffset(td.getLine() - 1) + td.getCol() - 1;
                            region = new FindReplaceDocumentAdapter(textFileBuffer.getDocument()).find(start, "(?<!\\\\)>", true, true, false, true);
                            end = region.getOffset() + region.getLength();
                            marker.setAttribute("charStart", start);
                            marker.setAttribute("charEnd", end);
                        }
                        catch (BadLocationException v0) {}
                    }
                    if (problems[i].getMessage() != null) {
                        marker.setAttribute("message", (Object)problems[i].getMessage());
                    }
                }
                ++i;
            }
            ** GOTO lbl-1000
        }
        catch (Throwable var18_17) {
            var17_18 = null;
            i = fileBuffers.iterator();
        }
        while (true) {
            if (!i.hasNext()) {
                throw var18_17;
            }
            location = (IPath)i.next();
            tfbManager.disconnect(location, (IProgressMonitor)new NullProgressMonitor());
        }
lbl-1000:
        // 1 sources

        {
            var17_19 = null;
            i = fileBuffers.iterator();
        }
        while (true) {
            if (!i.hasNext()) {
                return;
            }
            location = (IPath)i.next();
            tfbManager.disconnect(location, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static IStatus execute(String id, IResource resource, IProgressMonitor monitor) {
        return JET2Platform.runTransformOnResource(id, resource, null, monitor);
    }

    public static IStatus execute(String id, Object source, IProgressMonitor monitor) {
        return JET2Platform.runTransformOnObject(id, source, null, monitor);
    }

    public static IStatus execute(String id, String source, IProgressMonitor monitor) {
        return JET2Platform.runTransformOnString(id, source, monitor);
    }

    public static IStatus execute(String id, String source, String kind, IProgressMonitor monitor) {
        return JET2Platform.runTransformOnString(id, source, kind, null, monitor);
    }

    public static XPathFunctionMetaData[] getInstalledXPathFunctions() {
        return InternalJET2Platform.getDefault().getXPathFunctionsManager().getCustomFunctions();
    }

    public static IJETBundleManager getJETBundleManager() {
        return InternalJET2Platform.getDefault().getBundleManager();
    }

    public static IJETBundleDescriptor getProjectDescription(String name) {
        IJETBundleDescriptor result = null;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (JET2Platform.isOpenJETProject(project)) {
            IJETBundleManager bundleManager = JET2Platform.getJETBundleManager();
            result = bundleManager.getDescriptorForProject(name);
        }
        return result;
    }

    private static boolean isOpenJETProject(IProject project) {
        try {
            return project != null && project.exists() && project.isOpen() && project.hasNature(JET2_NATURE_ID);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private static void processResults(String id, final ContextLogEntry contextLog) {
        IJETBundleManager bundleManager = JET2Platform.getJETBundleManager();
        String projectName = bundleManager.getProjectForId(id);
        if (projectName != null) {
            final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            try {
                project.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor1) throws CoreException {
                        project.deleteMarkers("org.eclipse.jet.runtimeProblem", true, 2);
                        JET2Platform.addRuntimeProblemMarkersToProject(project, contextLog);
                    }
                }, null, 1, null);
            }
            catch (CoreException e) {
                InternalJET2Platform.logError(JET2Messages.JET2Platform_ErrorMarkingProject, (Exception)((Object)e));
                InternalJET2Platform.log(JET2Platform.toIStatus(contextLog));
            }
        } else {
            InternalJET2Platform.log(JET2Platform.toIStatus(contextLog));
        }
    }

    public static IStatus toIStatus(ContextLogEntry logEntry) {
        ContextLogEntry[] children = logEntry.getChildren();
        if (children.length > 0) {
            MultiStatus result = new MultiStatus(PLUGIN_ID, 0, logEntry.getMessage(), logEntry.getException());
            int i = 0;
            while (i < children.length) {
                result.add(JET2Platform.toIStatus(children[i]));
                ++i;
            }
            return result;
        }
        int severity = logEntry.getSeverity();
        return new Status(severity, PLUGIN_ID, 0, logEntry.getMessage(), logEntry.getException());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IStatus runTransform(String id, final JET2Context context, IProgressMonitor monitor) {
        Status result;
        block8: {
            IStatus iStatus;
            block7: {
                monitor.beginTask(String.valueOf(JET2Messages.JET2Platform_Executing) + id, 100);
                try {
                    try {
                        IJETBundleManager bundleManager = JET2Platform.getJETBundleManager();
                        if (bundleManager.getDescriptor(id) == null) {
                            String msg = MessageFormat.format(JET2Messages.JET2Platform_TransformNotFound, id);
                            IStatus result2 = InternalJET2Platform.newStatus(4, msg, null);
                            InternalJET2Platform.log(result2);
                            iStatus = result2;
                            Object var6_10 = null;
                            break block7;
                        }
                        monitor.subTask(JET2Messages.JET2Platform_RetrievingBundle);
                        RuntimeLoggerContextExtender.install(context);
                        if (DEBUG) {
                            RuntimeLoggerContextExtender rl = RuntimeLoggerContextExtender.getInstance(context);
                            rl.addListener(new RuntimeTagLogger(){

                                public void log(String message, TagInfo td, String templatePath, int level) {
                                    int nlPos = message.indexOf(System.getProperty("line.separator"));
                                    if (nlPos >= 0) {
                                        message = message.substring(0, nlPos);
                                    }
                                    System.out.println(String.valueOf(templatePath == null ? "" : String.valueOf(templatePath) + " ") + (td != null ? td.toString() : "") + ": " + message);
                                }
                            });
                        }
                        bundleManager.run(id, new IJETRunnable(){

                            /*
                             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            public void run(IJETBundleDescriptor descriptor, JET2TemplateLoader templateLoader, IProgressMonitor monitor) {
                                Object shell;
                                monitor.beginTask(JET2Messages.JET2Platform_Executing, 100);
                                TransformContextExtender tce = TransformContextExtender.getInstance(context);
                                if (tce.getShellContext() == null && (shell = JET2Platform.getShellContext()) != null) {
                                    tce.setShellContext(shell);
                                }
                                try {
                                    try {
                                        XPathContextExtender xpe = XPathContextExtender.getInstance(context);
                                        xpe.addCustomFunctions(JET2Platform.getInstalledXPathFunctions());
                                        tce.setLoader(templateLoader);
                                        tce.setBundleDescriptor(descriptor);
                                        if (descriptor.getOverridesId() != null) {
                                            tce.setOverride(descriptor.getOverridesId(), (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                                        }
                                        BodyContentWriter bodyContentWriter = new BodyContentWriter();
                                        SubProgressMonitor templateMonitor = new SubProgressMonitor(monitor, 50);
                                        templateMonitor.beginTask(JET2Messages.JET2Platform_ExecutingTemplates, -1);
                                        try {
                                            tce.execute(descriptor.getMainTemplate(), (JET2Writer)bodyContentWriter);
                                        }
                                        catch (Throwable throwable) {
                                            Object var8_10 = null;
                                            templateMonitor.done();
                                            throw throwable;
                                        }
                                        {
                                            Object var8_11 = null;
                                        }
                                        templateMonitor.done();
                                        monitor.subTask(JET2Messages.JET2Platform_CommittingResults);
                                        tce.commit((IProgressMonitor)new SubProgressMonitor(monitor, 50));
                                    }
                                    catch (JET2TagException e) {
                                        context.logError((Throwable)e);
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var10_13 = null;
                                    tce.cleanup();
                                    monitor.done();
                                    throw throwable;
                                }
                                {
                                    Object var10_14 = null;
                                    tce.cleanup();
                                }
                                monitor.done();
                            }
                        }, (IProgressMonitor)new SubProgressMonitor(monitor, 90));
                        ContextLogEntry contextLog = context.getLogEntries();
                        JET2Platform.processResults(id, contextLog);
                        result = JET2Platform.toIStatus(contextLog);
                    }
                    catch (BundleException e) {
                        result = new Status(4, PLUGIN_ID, 0, e.getLocalizedMessage(), (Throwable)e);
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var6_11 = null;
                    monitor.done();
                    if (!DEBUG) throw throwable;
                    System.out.flush();
                    throw throwable;
                }
            }
            monitor.done();
            if (!DEBUG) return iStatus;
            System.out.flush();
            return iStatus;
        }
        Object var6_12 = null;
        monitor.done();
        if (!DEBUG) return result;
        System.out.flush();
        return result;
    }

    public static IStatus runTransformOnObject(String id, Object source, IProgressMonitor monitor) {
        return JET2Platform.runTransformOnObject(id, source, null, monitor);
    }

    public static IStatus runTransformOnObject(String id, Object source, Map variables, IProgressMonitor monitor) {
        JET2Context context = new JET2Context(source);
        try {
            if (variables != null) {
                context.setVariables(variables);
            }
            return JET2Platform.runTransform(id, context, monitor);
        }
        catch (JET2TagException e) {
            return new Status(4, id, 0, e.getMessage(), (Throwable)e);
        }
    }

    public static IStatus runTransformOnResource(String id, IResource resource, IProgressMonitor monitor) {
        return JET2Platform.runTransformOnResource(id, resource, null, monitor);
    }

    public static IStatus runTransformOnResource(String id, IResource resource, Map variables, IProgressMonitor monitor) {
        try {
            IJETBundleDescriptor descriptor = JET2Platform.getJETBundleManager().getDescriptor(id);
            JET2Context context = new JET2Context(null);
            if (variables != null) {
                context.setVariables(variables);
            }
            String loaderId = descriptor.getModelLoaderId();
            String fileType = descriptor.getModelExtension();
            WorkspaceContextExtender.loadResourceAsSource(context, resource, loaderId, fileType);
            return JET2Platform.runTransform(id, context, monitor);
        }
        catch (JET2TagException e) {
            return new Status(4, id, 0, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            return new Status(4, id, 0, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (CoreJETException e) {
            return new Status(4, id, 0, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static IStatus runTransformOnString(String id, String source, IProgressMonitor monitor) {
        return JET2Platform.runTransformOnString(id, source, "xml", null, monitor);
    }

    public static IStatus runTransformOnString(String id, String source, String kind, IProgressMonitor monitor) {
        return JET2Platform.runTransformOnString(id, source, kind, null, monitor);
    }

    public static IStatus runTransformOnString(String id, String source, String kind, Map variables, IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;
        JET2Context context = new JET2Context(null);
        IJETBundleDescriptor descriptor = JET2Platform.getJETBundleManager().getDescriptor(id);
        String modelLoaderID = descriptor.getModelLoaderId();
        try {
            if (variables != null) {
                context.setVariables(variables);
            }
            Object sourceObject = TransformContextExtender.loadModelFromString(source, modelLoaderID, kind);
            context.setSource(sourceObject);
            result = JET2Platform.runTransform(id, context, monitor);
        }
        catch (JET2TagException e) {
            return new Status(4, id, 0, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (CoreJETException e) {
            return new Status(4, id, 0, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IOException e) {
            result = InternalJET2Platform.newStatus(4, JET2Messages.JET2Platform_CouldNotParseString, e);
        }
        return result;
    }

    public ILoaderManager getModelLoaderManager() {
        return JETActivatorWrapper.INSTANCE.getLoaderManager();
    }

    private JET2Platform() {
    }
}

