/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.extensionpoints;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.JETActivatorWrapper;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.runtime.model.EclipseExtensionLoaderFactory;
import org.eclipse.jet.runtime.model.ILoaderManager;

public final class ModelLoaderExtManager
implements IRegistryChangeListener {
    private static boolean DEBUG = InternalJET2Platform.getDefault().isDebugging() && Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jet/debug/modelLoaderExtensions")) != false;
    private static final String PLUGIN_ID = "org.eclipse.jet";
    private static final String EXTENSION_NAME = "modelLoaders";
    private static final String EXTENSION_POINT_ID = "org.eclipse.jet.modelLoaders";
    private final Map tagLibraries = new HashMap();
    private static final String E_LOADER = "loader";
    private static final String A_LOADER_ID = "id";
    private static final String A_LOADER_NAME = "name";
    private static final String A_LOADER_CLASS = "class";
    private static final String A_LOADER_DYNAMICTYPES = "dynamicTypes";
    private static final String E_DEFAULTTYPELOADER = "defaultTypeLoader";
    private static final String A_DEFAULTTYPELOADER_FILETYPE = "fileType";
    private static final String A_DEFAULTTYPELOADER_ID = "id";
    private static final String E_LOADABLETYPE = "loadableType";
    private static final String A_LOADABLETYPE_FILETYPE = "fileType";
    private static final String A_LOADABLETYPE_ID = "id";
    private static final String E_TYPE = "type";
    private static final String A_TYPE_FILETYPE = "fileType";

    public void startup() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] configElements = reg.getConfigurationElementsFor(EXTENSION_POINT_ID);
        this.addConfigElements(configElements);
        reg.addRegistryChangeListener((IRegistryChangeListener)this, PLUGIN_ID);
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas(EXTENSION_POINT_ID);
        int i = 0;
        while (i < deltas.length) {
            IExtension ext = deltas[i].getExtension();
            if (deltas[i].getKind() == 1) {
                if (DEBUG) {
                    System.out.println("ModelLoaderExtManager.registryChanged(add " + ext.getContributor().getName() + ")");
                }
                this.addConfigElements(ext.getConfigurationElements());
            } else {
                if (DEBUG) {
                    System.out.println("ModelLoaderExtManager.registryChanged(remove " + ext.getContributor().getName() + ")");
                }
                this.removeConfigElements(ext.getConfigurationElements());
            }
            ++i;
        }
    }

    public void shutdown() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        reg.removeRegistryChangeListener((IRegistryChangeListener)this);
        this.tagLibraries.clear();
    }

    private void addConfigElements(IConfigurationElement[] configElements) {
        ILoaderManager mgr = JETActivatorWrapper.INSTANCE.getLoaderManager();
        int i = 0;
        while (i < configElements.length) {
            String fileType;
            String id;
            if (E_LOADER.equals(configElements[i].getName())) {
                id = configElements[i].getAttribute("id");
                String fullId = String.valueOf(configElements[i].getDeclaringExtension().getNamespace()) + "." + id;
                String name = configElements[i].getAttribute(A_LOADER_NAME);
                boolean dynamic = Boolean.valueOf(configElements[i].getAttribute(A_LOADER_DYNAMICTYPES));
                mgr.addLoader(fullId, name, new EclipseExtensionLoaderFactory(configElements[i], A_LOADER_CLASS), dynamic);
                int j = 0;
                while (j < configElements[i].getChildren(E_TYPE).length) {
                    IConfigurationElement typeElement = configElements[i].getChildren(E_TYPE)[j];
                    String fileType2 = typeElement.getAttribute("fileType");
                    mgr.addLoaderForType(fullId, fileType2);
                    ++j;
                }
            } else if (E_LOADABLETYPE.equals(configElements[i].getName())) {
                id = configElements[i].getAttribute("id");
                fileType = configElements[i].getAttribute("fileType");
                mgr.addLoaderForType(id, fileType);
            } else if (E_DEFAULTTYPELOADER.equals(configElements[i].getName())) {
                id = configElements[i].getAttribute("id");
                fileType = configElements[i].getAttribute("fileType");
                try {
                    mgr.setDefaultLoader(fileType, id);
                }
                catch (IllegalStateException illegalStateException) {
                    String msg = MessageFormat.format(JET2Messages.ModelLoaderExtManager_TypeAlreadyDefined, fileType, mgr.getDefaultModelLoaderId(fileType), id);
                    Status status = new Status(2, configElements[i].getDeclaringExtension().getNamespace(), 0, msg, null);
                    InternalJET2Platform.getDefault().getLog().log((IStatus)status);
                }
            }
            ++i;
        }
    }

    private void removeConfigElements(IConfigurationElement[] configElements) {
        ILoaderManager mgr = JETActivatorWrapper.INSTANCE.getLoaderManager();
        int i = 0;
        while (i < configElements.length) {
            String id;
            if (E_LOADER.equals(configElements[i].getName())) {
                id = configElements[i].getAttribute("id");
                String fullId = String.valueOf(configElements[i].getDeclaringExtension().getNamespace()) + "." + id;
                mgr.removeLoader(fullId);
                int j = 0;
                while (j < configElements[i].getChildren(E_TYPE).length) {
                    IConfigurationElement typeElement = configElements[i].getChildren(E_TYPE)[j];
                    String fileType = typeElement.getAttribute("fileType");
                    mgr.removeLoaderForType(fullId, fileType);
                    ++j;
                }
            } else if (E_LOADABLETYPE.equals(configElements[i].getName())) {
                id = configElements[i].getAttribute("id");
                String fileType = configElements[i].getAttribute("fileType");
                mgr.removeLoaderForType(id, fileType);
            } else if (E_DEFAULTTYPELOADER.equals(configElements[i].getName())) {
                String fileType = configElements[i].getAttribute("fileType");
                mgr.clearDefaultLoader(fileType);
            }
            ++i;
        }
    }
}

