/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.extensionpoints;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jet.internal.extensionpoints.IPluginChangeListener;
import org.eclipse.jet.internal.extensionpoints.PluginProjectMonitor;
import org.eclipse.jet.internal.extensionpoints.TagLibraryDataFactory;
import org.eclipse.jet.internal.runtime.BundleManifest;
import org.eclipse.jet.taglib.TagLibrary;

public class WorkspaceTagLibraryManager
implements IPluginChangeListener {
    private PluginProjectMonitor projectMonitor;
    private final Map tagLibrariesById = new HashMap();
    private final Map libraryIdsByProjectName = new HashMap();
    private final Map projectByTagLibraryId = new HashMap();

    public void projectRemoved(IProject project) {
        String projectName = project.getName();
        this.internalRemoveProject(projectName);
    }

    private void internalRemoveProject(String projectName) {
        String[] ids = (String[])this.libraryIdsByProjectName.remove(projectName);
        if (ids != null) {
            int i = 0;
            while (i < ids.length) {
                this.tagLibrariesById.remove(ids[i]);
                this.projectByTagLibraryId.remove(ids[i]);
                ++i;
            }
        }
    }

    public void projectUpdated(IProject project, BundleManifest manifest, Object pluginDocumentRoot) {
        String projectName = project.getName();
        this.internalRemoveProject(projectName);
        TagLibrary[] newLibraries = TagLibraryDataFactory.INSTANCE.createTagLibraries(manifest.getSymbolicName(), pluginDocumentRoot);
        String[] newIds = new String[newLibraries.length];
        int i = 0;
        while (i < newLibraries.length) {
            newIds[i] = newLibraries[i].getLibraryId();
            this.tagLibrariesById.put(newIds[i], newLibraries[i]);
            this.projectByTagLibraryId.put(newIds[i], project);
            ++i;
        }
        this.libraryIdsByProjectName.put(projectName, newIds);
    }

    public void startup(PluginProjectMonitor projectMonitor) {
        if (projectMonitor == null) {
            throw new NullPointerException();
        }
        if (this.projectMonitor != null) {
            throw new IllegalStateException();
        }
        this.projectMonitor = projectMonitor;
        this.projectMonitor.addPluginProjectListener(this);
    }

    public void shutdown() {
        if (this.projectMonitor != null) {
            this.projectMonitor.removePluginProjectListener(this);
            this.projectMonitor = null;
        }
    }

    public TagLibrary getTagLibrary(String id) {
        return (TagLibrary)this.tagLibrariesById.get(id);
    }

    public IProject getProjectDefiningTagLibrary(String id) {
        return (IProject)this.projectByTagLibraryId.get(id);
    }
}

