/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.workspace;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jet.BodyContentWriter;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.internal.taglib.workspace.WsFileFromWriterAction;
import org.eclipse.jet.taglib.AbstractEmptyTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jet.taglib.workspace.WorkspaceContextExtender;
import org.eclipse.jet.transform.TransformContextExtender;

public class FileTag
extends AbstractEmptyTag {
    private static final String TEMPLATE__ATTR = "template";
    private static final String PATH__ATTR = "path";
    private static final String REPLACE__ATTR = "replace";
    private static final String DERIVED__ATTR = "derived";
    private static final String ENCODING__ATTR = "encoding";

    public void doAction(TagInfo td, JET2Context context, JET2Writer out) throws JET2TagException {
        IFile file;
        Path path = new Path(this.getAttribute(PATH__ATTR));
        String templatePath = this.getAttribute(TEMPLATE__ATTR);
        boolean replace = true;
        if (td.hasAttribute(REPLACE__ATTR)) {
            replace = Boolean.valueOf(this.getAttribute(REPLACE__ATTR));
        }
        boolean derived = false;
        if (td.hasAttribute(DERIVED__ATTR)) {
            derived = Boolean.valueOf(this.getAttribute(DERIVED__ATTR));
        }
        WorkspaceContextExtender wsExtender = WorkspaceContextExtender.getInstance(context);
        if (path.isAbsolute() || !wsExtender.existsContainer()) {
            try {
                file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            }
            catch (IllegalArgumentException e) {
                throw new JET2TagException(e.getLocalizedMessage(), (Throwable)e);
            }
        } else {
            file = wsExtender.getContainer().getFile((IPath)path);
        }
        BodyContentWriter contentWriter = new BodyContentWriter();
        TransformContextExtender tce = new TransformContextExtender(context);
        tce.execute(templatePath, (JET2Writer)contentWriter);
        WsFileFromWriterAction fileAction = new WsFileFromWriterAction(context, tce.getTemplatePath(), td, file, (JET2Writer)contentWriter, replace, derived);
        if (td.hasAttribute(ENCODING__ATTR)) {
            fileAction.setEncoding(this.getAttribute(ENCODING__ATTR));
        }
        wsExtender.addAction(fileAction);
    }
}

