/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.parser;

import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.xpath.parser.Token;
import org.eclipse.jet.internal.xpath.parser.XPathTokens;
import org.eclipse.jet.xpath.XPathLexicalException;

public class XPathTokenScanner {
    public static final int EOF = -1;
    private final String input;
    private int nextOffset;
    private TokenRule[] tokenRules = new TokenRule[]{new WhitespaceRule(), new StringLiteralRule(), new QNameRule(), new NCNameRule(), new NumberRule(), new SymbolicTokenRule("(", XPathTokens.LPAREN), new SymbolicTokenRule(")", XPathTokens.RPAREN), new SymbolicTokenRule("[", XPathTokens.LBRACKET), new SymbolicTokenRule("]", XPathTokens.RBRACKET), new SymbolicTokenRule("..", XPathTokens.DOT_DOT), new SymbolicTokenRule(".", XPathTokens.DOT), new SymbolicTokenRule("@", XPathTokens.AT_SIGN), new SymbolicTokenRule("::", XPathTokens.COLON_COLON), new SymbolicTokenRule(":", XPathTokens.COLON), new SymbolicTokenRule(",", XPathTokens.COMMA), new SymbolicTokenRule("$", XPathTokens.DOLLAR_SIGN), new SymbolicTokenRule("*", XPathTokens.ASTERISK), new SymbolicTokenRule("+", XPathTokens.PLUS_SIGN), new SymbolicTokenRule("-", XPathTokens.HYPHEN), new SymbolicTokenRule("//", XPathTokens.SLASH_SLASH), new SymbolicTokenRule("/", XPathTokens.SLASH), new SymbolicTokenRule("=", XPathTokens.EQUALS), new SymbolicTokenRule("!=", XPathTokens.NOT_EQUALS), new SymbolicTokenRule("<=", XPathTokens.LT_EQUALS), new SymbolicTokenRule("<", XPathTokens.LT), new SymbolicTokenRule(">=", XPathTokens.GT_EQUALS), new SymbolicTokenRule(">", XPathTokens.GT), new SymbolicTokenRule("|", XPathTokens.OR_BAR)};
    private int tokenStart = -1;
    private int tokenEnd = -1;

    public XPathTokenScanner(String input) {
        this.input = input;
        this.nextOffset = 0;
    }

    public int peek() {
        int next = this.nextOffset < this.input.length() ? (int)this.input.charAt(this.nextOffset) : -1;
        return next;
    }

    public void prev() {
        --this.nextOffset;
    }

    public void addTokenError(String string) {
    }

    public int next() {
        int next = this.nextOffset < this.input.length() ? (int)this.input.charAt(this.nextOffset) : -1;
        ++this.nextOffset;
        return next;
    }

    public Token nextToken() throws XPathLexicalException {
        int savedNextOffset = this.nextOffset;
        int i = 0;
        while (i < this.tokenRules.length) {
            Token token = this.tokenRules[i].evaluate(this);
            if (token != null && token.isWhitespace()) {
                savedNextOffset = this.nextOffset;
            } else if (token != null && !token.isUndefined()) {
                this.tokenStart = savedNextOffset;
                this.tokenEnd = this.nextOffset;
                return token;
            }
            this.nextOffset = savedNextOffset;
            ++i;
        }
        if (this.nextOffset >= this.input.length()) {
            return Token.EOF_TOKEN;
        }
        return Token.UNDEFINED_TOKEN;
    }

    public String getTokenText() {
        if (this.tokenStart == -1 || this.tokenEnd == -1) {
            throw new IllegalStateException();
        }
        return this.input.substring(this.tokenStart, this.tokenEnd);
    }

    public void putBackToken() {
        if (this.tokenStart == -1 || this.tokenEnd == -1) {
            throw new IllegalStateException();
        }
        this.nextOffset = this.tokenStart;
        this.tokenEnd = -1;
        this.tokenStart = -1;
    }

    public int getTokenStart() {
        return this.tokenStart;
    }

    public int getTokenEnd() {
        return this.tokenEnd;
    }

    private static class NCNameRule
    implements TokenRule {
        private NCNameRule() {
        }

        public Token evaluate(XPathTokenScanner scanner) throws XPathLexicalException {
            int ch = scanner.next();
            if (!this.isNCNameStartChar(ch)) {
                return Token.UNDEFINED_TOKEN;
            }
            ch = scanner.next();
            while (this.isNCNameChar(ch)) {
                ch = scanner.next();
            }
            scanner.prev();
            return XPathTokens.NCNAME;
        }

        private boolean isNCNameChar(int ch) {
            return Character.isLetterOrDigit((char)ch) || ch == 46 || ch == 45 || ch == 95;
        }

        private boolean isNCNameStartChar(int c) {
            return Character.isLetter((char)c) || c == 95;
        }
    }

    private static class NumberRule
    implements TokenRule {
        private NumberRule() {
        }

        public Token evaluate(XPathTokenScanner scanner) throws XPathLexicalException {
            boolean decimalPointFound = false;
            int ch = scanner.next();
            if (ch == 46) {
                decimalPointFound = true;
                ch = scanner.next();
            }
            if (!Character.isDigit((char)ch)) {
                return Token.UNDEFINED_TOKEN;
            }
            ch = scanner.next();
            while (Character.isDigit((char)ch) || ch == 46 && !decimalPointFound) {
                if (ch == 46) {
                    decimalPointFound = true;
                }
                ch = scanner.next();
            }
            scanner.prev();
            return XPathTokens.NUMBER;
        }
    }

    private static class QNameRule
    implements TokenRule {
        private QNameRule() {
        }

        public Token evaluate(XPathTokenScanner scanner) throws XPathLexicalException {
            int ch = scanner.next();
            if (!this.isNCNameStartChar(ch)) {
                return Token.UNDEFINED_TOKEN;
            }
            ch = scanner.next();
            while (this.isNCNameChar(ch)) {
                ch = scanner.next();
            }
            if (ch != 58) {
                return Token.UNDEFINED_TOKEN;
            }
            ch = scanner.next();
            if (!this.isNCNameStartChar(ch)) {
                return Token.UNDEFINED_TOKEN;
            }
            ch = scanner.next();
            while (this.isNCNameChar(ch)) {
                ch = scanner.next();
            }
            scanner.prev();
            return XPathTokens.QNAME;
        }

        private boolean isNCNameChar(int ch) {
            return Character.isLetterOrDigit((char)ch) || ch == 46 || ch == 45 || ch == 95;
        }

        private boolean isNCNameStartChar(int c) {
            return Character.isLetter((char)c) || c == 95;
        }
    }

    private static class StringLiteralRule
    implements TokenRule {
        private StringLiteralRule() {
        }

        public Token evaluate(XPathTokenScanner scanner) throws XPathLexicalException {
            int first = scanner.next();
            if (first != 39 && first != 34) {
                return Token.UNDEFINED_TOKEN;
            }
            int ch = scanner.next();
            while (ch != -1) {
                if (ch == first) {
                    if (scanner.peek() != first) break;
                    scanner.next();
                }
                ch = scanner.next();
            }
            if (ch != first) {
                throw new XPathLexicalException(JET2Messages.XPathTokenScanner_UnterminatedStringLiteral);
            }
            return XPathTokens.LITERAL;
        }
    }

    private static class SymbolicTokenRule
    implements TokenRule {
        private final String symbol;
        private final Token token;

        public SymbolicTokenRule(String symbol, Token token) {
            this.symbol = symbol;
            this.token = token;
        }

        public Token evaluate(XPathTokenScanner scanner) throws XPathLexicalException {
            int i = 0;
            while (i < this.symbol.length()) {
                int ch = scanner.next();
                if (ch != this.symbol.charAt(i)) {
                    return Token.UNDEFINED_TOKEN;
                }
                ++i;
            }
            return this.token;
        }
    }

    private static interface TokenRule {
        public Token evaluate(XPathTokenScanner var1) throws XPathLexicalException;
    }

    private static class WhitespaceRule
    implements TokenRule {
        private WhitespaceRule() {
        }

        public Token evaluate(XPathTokenScanner scanner) throws XPathLexicalException {
            int ch = scanner.next();
            if (!Character.isWhitespace((char)ch)) {
                return Token.UNDEFINED_TOKEN;
            }
            ch = scanner.next();
            while (Character.isWhitespace((char)ch)) {
                ch = scanner.next();
            }
            scanner.prev();
            return Token.WHITESPACE_TOKEN;
        }
    }
}

