/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.editor.outlineview;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IStorage;
import org.eclipse.internal.xtend.xtend.ast.ImportStatement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.shared.ui.core.IXtendXpandResource;
import org.eclipse.xtend.shared.ui.core.i18n.Messages;
import org.eclipse.xtend.shared.ui.editor.outlineview.OutlineElement;
import org.eclipse.xtend.shared.ui.editor.outlineview.OutlineElementComparator;
import org.eclipse.xtend.shared.ui.expression.editor.EditorImages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExtXptContentOutlinePage
extends ContentOutlinePage {
    private final TextEditor editor;
    private IEditorInput input;
    private ISelection selection;

    public AbstractExtXptContentOutlinePage(TextEditor editor) {
        this.editor = editor;
    }

    public void setInput(IEditorInput input) {
        this.input = input;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getTreeViewer().setContentProvider((IContentProvider)this.getContentProvider());
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        IXtendXpandResource r = this.parse();
        if (r != null) {
            this.getTreeViewer().setInput((Object)r);
        }
    }

    private IXtendXpandResource parse() {
        if (this.input == null) {
            return null;
        }
        IStorage file = (IStorage)this.input.getAdapter(IStorage.class);
        return Activator.getExtXptModelManager().findExtXptResource(file);
    }

    private ILabelProvider getLabelProvider() {
        return new ILabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof OutlineElement) {
                    return ((OutlineElement)element).image;
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof OutlineElement) {
                    return ((OutlineElement)element).label;
                }
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
    }

    private ITreeContentProvider getContentProvider() {
        return new ITreeContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getChildren(Object parentElement) {
                return AbstractExtXptContentOutlinePage.this.getChildren(parentElement);
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length > 0;
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }
        };
    }

    public final void selectionChanged(SelectionChangedEvent anEvent) {
        super.selectionChanged(anEvent);
        this.selection = anEvent.getSelection();
        this.updateHighlight();
    }

    private final void updateHighlight() {
        if (this.selection != null) {
            if (this.selection.isEmpty()) {
                this.editor.resetHighlightRange();
            } else {
                Object segment = ((IStructuredSelection)this.selection).getFirstElement();
                if (segment != null && segment instanceof OutlineElement) {
                    OutlineElement ext = (OutlineElement)segment;
                    int start = ext.start;
                    int length = ext.length;
                    if (start >= 0) {
                        try {
                            this.editor.setHighlightRange(start, length, true);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            this.editor.resetHighlightRange();
                        }
                    }
                }
            }
        }
    }

    public void refresh() {
        Control control;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
            IXtendXpandResource res = null;
            try {
                res = this.parse();
            }
            catch (RuntimeException runtimeException) {
                return;
            }
            control.setRedraw(false);
            if (res != null) {
                res.refresh();
            }
            viewer.setInput((Object)res);
            viewer.expandAll();
            control.setRedraw(true);
        }
    }

    protected abstract OutlineElement[] getChildren(Object var1);

    protected List<OutlineElement> toOutlineElementsForNamespaceImports(List<ImportStatement> imports) {
        ArrayList<OutlineElement> l = new ArrayList<OutlineElement>();
        for (ImportStatement s : imports) {
            l.add(new OutlineElement(s.getImportedId().getValue(), s.getStart(), s.getEnd() - s.getStart(), EditorImages.getImage("import_ns.gif"), 1));
        }
        return l;
    }

    protected List<OutlineElement> toOutlineElementsForExtensionImports(List<ImportStatement> imports) {
        ArrayList<OutlineElement> l = new ArrayList<OutlineElement>();
        for (ImportStatement s : imports) {
            l.add(new OutlineElement(s.getImportedId().getValue(), s.getStart(), s.getEnd() - s.getStart(), EditorImages.getImage("import_ext.gif"), 2));
        }
        return l;
    }

    public class LexicalSortingAction
    extends Action {
        public static final String ID_PLUGIN = "org.eclipse.internal.xtend";
        public static final String PREFIX = "org.eclipse.internal.xtend.";
        public static final String LEXICAL_SORTING_OUTLINE_ACTION = "org.eclipse.internal.xtend.lexical_sorting_outline_action";
        private OutlineElementComparator fComparator = new OutlineElementComparator();
        private ViewerComparator fSourcePositonComparator = new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return 0;
            }
        };

        public LexicalSortingAction() {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, LEXICAL_SORTING_OUTLINE_ACTION);
            this.setText(Messages.AbstractOawContentOutlinePage_1);
            this.setImageDescriptor(Activator.getImageDescriptor("icons/alphab_sort_co.gif"));
            this.setToolTipText(Messages.AbstractOawContentOutlinePage_3);
            this.setDescription(Messages.AbstractOawContentOutlinePage_4);
            boolean checked = Activator.getDefault().getPreferenceStore().getBoolean("LexicalSortingAction.isChecked");
            this.valueChanged(checked, false);
        }

        public void run() {
            this.valueChanged(this.isChecked(), true);
        }

        private void valueChanged(final boolean on, boolean store) {
            this.setChecked(on);
            final TreeViewer fOutlineViewer = AbstractExtXptContentOutlinePage.this.getTreeViewer();
            BusyIndicator.showWhile((Display)fOutlineViewer.getControl().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    if (on) {
                        fOutlineViewer.setComparator((ViewerComparator)LexicalSortingAction.this.fComparator);
                    } else {
                        fOutlineViewer.setComparator(LexicalSortingAction.this.fSourcePositonComparator);
                    }
                }
            });
            if (store) {
                Activator.getDefault().getPreferenceStore().setValue("LexicalSortingAction.isChecked", on);
            }
        }
    }
}

