/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.wizards;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.xtend.shared.ui.internal.XtendLog;
import org.eclipse.xtend.shared.ui.wizards.EclipseHelper;
import org.eclipse.xtend.shared.ui.wizards.OawProjectWizardPage;

public class OawProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private OawProjectWizardPage page;
    private ISelection selection;
    private IConfigurationElement configElement;

    public OawProjectWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new OawProjectWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String name = this.page.getProjectName();
        final boolean genExample = this.page.isCreateExample();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    OawProjectWizard.this.doFinish(name, genExample, monitor);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
        return true;
    }

    void doFinish(String name, boolean genExample, IProgressMonitor monitor) {
        String projectName = name;
        monitor.beginTask("Creating oaw generator project " + name, 2);
        HashSet<String> refs = new HashSet<String>();
        ArrayList<String> srcfolders = new ArrayList<String>();
        srcfolders.add("src");
        srcfolders.add("src-gen");
        IProject p = EclipseHelper.createExtXptProject(projectName, srcfolders, Collections.<IProject>emptyList(), refs, null, monitor, this.getShell());
        if (p == null) {
            return;
        }
        if (genExample) {
            EclipseHelper.createFile("src/metamodel/Checks.chk", (IContainer)p, this.getContents("Checks.chk"), monitor);
            EclipseHelper.createFile("src/metamodel/Extensions.ext", (IContainer)p, this.getContents("Extensions.ext"), monitor);
            EclipseHelper.createFile("src/metamodel/metamodel.ecore", (IContainer)p, this.getContents("metamodel.ecore"), monitor);
            EclipseHelper.createFile("src/template/GeneratorExtensions.ext", (IContainer)p, this.getContents("GeneratorExtensions.ext"), monitor);
            EclipseHelper.createFile("src/template/Template.xpt", (IContainer)p, this.getContents("Template.xpt"), monitor);
            EclipseHelper.createFile("src/workflow/generator.oaw", (IContainer)p, this.getContents("generator.oaw").replace("PROJECTNAME", projectName), monitor);
            EclipseHelper.createFile("src/Model.xmi", (IContainer)p, this.getContents("Model.xmi"), monitor);
        }
        monitor.worked(1);
    }

    private String getContents(String resource) {
        try {
            int read;
            InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/openarchitectureware/wizards/example/" + resource);
            byte[] buffer = new byte[4096];
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            while ((read = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, read);
            }
            outputStream.close();
            inputStream.close();
            return outputStream.toString("iso-8859-1");
        }
        catch (IOException e) {
            XtendLog.logError(e);
            return "";
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configElement = config;
    }
}

