/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.examples.toolkits.motorola;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.mtj.core.launching.LaunchEnvironment;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.sdk.device.AbstractMIDPDevice;
import org.eclipse.mtj.internal.core.sdk.device.LaunchTemplateProperties;
import org.eclipse.mtj.internal.core.util.ReplaceableParametersProcessor;

public class MotorolaDevice
extends AbstractMIDPDevice {
    private static final String PROPERTIES_FILE = "propertiesFile";
    private File propertiesFile;

    public String getLaunchCommand(LaunchEnvironment launchEnvironment, IProgressMonitor iProgressMonitor) throws CoreException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (launchEnvironment.getProject() instanceof IMidletSuiteProject) {
            Object object;
            boolean bl;
            IMidletSuiteProject iMidletSuiteProject = (IMidletSuiteProject)launchEnvironment.getProject();
            ILaunchConfiguration iLaunchConfiguration = launchEnvironment.getLaunchConfiguration();
            boolean bl2 = this.shouldDirectLaunchJAD(iLaunchConfiguration);
            File file = this.copyForLaunch(iMidletSuiteProject, iProgressMonitor, bl2);
            hashMap.put(LaunchTemplateProperties.EXECUTABLE.toString(), this.executable.getPath());
            hashMap.put(LaunchTemplateProperties.DEVICE.toString(), this.getName());
            hashMap.put("devicePropsFile", this.propertiesFile.getPath());
            if (launchEnvironment.isDebugLaunch()) {
                hashMap.put(LaunchTemplateProperties.DEBUGPORT.toString(), new Integer(launchEnvironment.getDebugListenerPort()).toString());
            }
            if (!(bl = this.shouldDirectLaunchJAD(iLaunchConfiguration))) {
                object = this.getProjectClasspathString((IMTJProject)iMidletSuiteProject, file, iProgressMonitor);
                hashMap.put(LaunchTemplateProperties.CLASSPATH.toString(), object);
            }
            this.addLaunchConfigurationValue(hashMap, LaunchTemplateProperties.VERBOSE.toString(), iLaunchConfiguration, "mtj.verbosity_options");
            this.addLaunchConfigurationValue(hashMap, LaunchTemplateProperties.HEAPSIZE.toString(), iLaunchConfiguration, "mtj.heap_size");
            if (bl) {
                hashMap.put(LaunchTemplateProperties.JADFILE.toString(), this.getSpecifiedJadURL(iLaunchConfiguration));
            } else if (!this.shouldDoOTA(iLaunchConfiguration) && ((File)(object = this.getJadForLaunch(iMidletSuiteProject, file, iProgressMonitor))).exists()) {
                hashMap.put(LaunchTemplateProperties.JADFILE.toString(), ((File)object).toString());
            }
            object = iLaunchConfiguration.getAttribute("mtj.launch_params", "");
            hashMap.put(LaunchTemplateProperties.USERSPECIFIEDARGUMENTS.toString(), object);
        }
        return ReplaceableParametersProcessor.processReplaceableValues((String)this.launchCommandTemplate, hashMap);
    }

    public void loadUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        super.loadUsing(iPersistenceProvider);
        this.propertiesFile = new File(iPersistenceProvider.loadString(PROPERTIES_FILE));
    }

    public void setPropertiesFile(File file) {
        this.propertiesFile = file;
    }

    public void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        super.storeUsing(iPersistenceProvider);
        iPersistenceProvider.storeString(PROPERTIES_FILE, this.propertiesFile.toString());
    }

    public File getWorkingDirectory() {
        return null;
    }
}

