/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.jmunit.ui.part;

import org.eclipse.core.runtime.Assert;
import org.eclipse.mtj.internal.jmunit.util.LayoutUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MethodStubsSelectionButtonGroup {
    private Composite fButtonComposite;
    private String[] fButtonNames;
    private Button[] fButtons;
    private boolean[] fButtonsEnabled;
    private boolean[] fButtonsSelected;
    private int fButtonsStyle;
    private boolean fEnabled = true;
    private int fGroupBorderStyle;
    private SelectionButtonGroupListener fGroupListener;
    private int fGroupNumberOfColumns;
    private Label fLabel = null;
    protected String fLabelText = "";

    public static Control createEmptySpace(Composite composite) {
        return MethodStubsSelectionButtonGroup.createEmptySpace(composite, 1);
    }

    public static Control createEmptySpace(Composite composite, int n) {
        return LayoutUtil.createEmptySpace(composite, n);
    }

    protected static GridData gridDataForLabel(int n) {
        GridData gridData = new GridData();
        gridData.horizontalSpan = n;
        return gridData;
    }

    public MethodStubsSelectionButtonGroup(int n, String[] stringArray, int n2) {
        this(n, stringArray, n2, 0);
    }

    public MethodStubsSelectionButtonGroup(int n, String[] stringArray, int n2, int n3) {
        Assert.isTrue((n == 16 || n == 32 || n == 2 ? 1 : 0) != 0);
        this.fButtonNames = stringArray;
        int n4 = stringArray.length;
        this.fButtonsSelected = new boolean[n4];
        this.fButtonsEnabled = new boolean[n4];
        int n5 = 0;
        while (n5 < n4) {
            this.fButtonsSelected[n5] = false;
            this.fButtonsEnabled[n5] = true;
            ++n5;
        }
        if (n == 16) {
            this.fButtonsSelected[0] = true;
        }
        this.fGroupBorderStyle = n3;
        this.fGroupNumberOfColumns = n2 <= 0 ? n4 : n2;
        this.fButtonsStyle = n;
    }

    public void dialogFieldChanged() {
        if (this.fGroupListener != null) {
            this.fGroupListener.groupChanged(this);
        }
    }

    public Control[] doFillIntoGrid(Composite composite, int n) {
        this.assertEnoughColumns(n);
        if (this.fGroupBorderStyle == 0) {
            Label label = this.getLabelControl(composite);
            label.setLayoutData((Object)MethodStubsSelectionButtonGroup.gridDataForLabel(1));
            Composite composite2 = this.getSelectionButtonsGroup(composite);
            GridData gridData = new GridData();
            gridData.horizontalSpan = n - 1;
            composite2.setLayoutData((Object)gridData);
            return new Control[]{label, composite2};
        }
        Composite composite3 = this.getSelectionButtonsGroup(composite);
        GridData gridData = new GridData();
        gridData.horizontalSpan = n;
        composite3.setLayoutData((Object)gridData);
        return new Control[]{composite3};
    }

    public Label getLabelControl(Composite composite) {
        if (this.fLabel == null) {
            this.assertCompositeNotNull(composite);
            this.fLabel = new Label(composite, 16448);
            this.fLabel.setFont(composite.getFont());
            this.fLabel.setEnabled(this.fEnabled);
            if (this.fLabelText != null && !"".equals(this.fLabelText)) {
                this.fLabel.setText(this.fLabelText);
            } else {
                this.fLabel.setText(".");
                this.fLabel.setVisible(false);
            }
        }
        return this.fLabel;
    }

    public int getNumberOfControls() {
        return this.fGroupBorderStyle == 0 ? 2 : 1;
    }

    public Button getSelectionButton(int n) {
        if (n >= 0 && n < this.fButtons.length) {
            return this.fButtons[n];
        }
        return null;
    }

    public Composite getSelectionButtonsGroup(Composite composite) {
        if (this.fButtonComposite == null) {
            Object object;
            this.assertCompositeNotNull(composite);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = this.fGroupNumberOfColumns;
            if (this.fGroupBorderStyle != 0) {
                object = new Group(composite, this.fGroupBorderStyle);
                if (this.fLabelText != null && this.fLabelText.length() > 0) {
                    object.setText(this.fLabelText);
                }
                this.fButtonComposite = object;
            } else {
                this.fButtonComposite = new Composite(composite, 0);
                gridLayout.marginHeight = 0;
                gridLayout.marginWidth = 0;
            }
            this.fButtonComposite.setLayout((Layout)gridLayout);
            object = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    MethodStubsSelectionButtonGroup.this.doWidgetSelected(selectionEvent);
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    MethodStubsSelectionButtonGroup.this.doWidgetSelected(selectionEvent);
                }
            };
            int n = this.fButtonNames.length;
            this.fButtons = new Button[n];
            int n2 = 0;
            while (n2 < n) {
                this.fButtons[n2] = this.createSelectionButton(n2, this.fButtonComposite, (SelectionListener)object);
                ++n2;
            }
            n2 = n / this.fGroupNumberOfColumns;
            int n3 = n2 * this.fGroupNumberOfColumns - n;
            int n4 = 0;
            while (n4 < n3) {
                MethodStubsSelectionButtonGroup.createEmptySpace(this.fButtonComposite);
                ++n4;
            }
            this.setSelectionGroupListener(new SelectionButtonGroupListener(){

                public void groupChanged(MethodStubsSelectionButtonGroup methodStubsSelectionButtonGroup) {
                    methodStubsSelectionButtonGroup.setEnabled(1, MethodStubsSelectionButtonGroup.this.isEnabled() && methodStubsSelectionButtonGroup.isSelected(0));
                }
            });
        }
        return this.fButtonComposite;
    }

    public final boolean isEnabled() {
        return this.fEnabled;
    }

    public boolean isEnabled(int n) {
        if (n >= 0 && n < this.fButtonsEnabled.length) {
            return this.fButtonsEnabled[n];
        }
        return false;
    }

    public boolean isSelected(int n) {
        if (n >= 0 && n < this.fButtonsSelected.length) {
            return this.fButtonsSelected[n] && this.fButtonsEnabled[n];
        }
        return false;
    }

    public void postSetFocusOnDialogField(Display display) {
        if (display != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    MethodStubsSelectionButtonGroup.this.setFocus();
                }
            });
        }
    }

    public final void setEnabled(boolean bl) {
        if (bl != this.fEnabled) {
            this.fEnabled = bl;
            this.updateEnableState();
        }
    }

    public void setEnabled(int n, boolean bl) {
        if (n >= 0 && n < this.fButtonsEnabled.length && this.fButtonsEnabled[n] != bl) {
            Button button;
            this.fButtonsEnabled[n] = bl;
            if (this.fButtons != null && this.isOkToUse((Control)(button = this.fButtons[n]))) {
                button.setEnabled(bl);
                if (!bl) {
                    button.setSelection(false);
                } else {
                    button.setSelection(this.fButtonsSelected[n]);
                }
            }
        }
    }

    public boolean setFocus() {
        return false;
    }

    public void setLabelText(String string) {
        this.fLabelText = string;
    }

    public void setSelection(int n, boolean bl) {
        if (n >= 0 && n < this.fButtonsSelected.length && this.fButtonsSelected[n] != bl) {
            Button button;
            this.fButtonsSelected[n] = bl;
            if (this.fButtons != null && this.isOkToUse((Control)(button = this.fButtons[n])) && button.isEnabled()) {
                button.setSelection(bl);
            }
        }
    }

    public final void setSelectionGroupListener(SelectionButtonGroupListener selectionButtonGroupListener) {
        this.fGroupListener = selectionButtonGroupListener;
    }

    private Button createSelectionButton(int n, Composite composite, SelectionListener selectionListener) {
        Button button = new Button(composite, this.fButtonsStyle | 0x4000);
        button.setFont(composite.getFont());
        button.setText(this.fButtonNames[n]);
        button.setEnabled(this.isEnabled() && this.isEnabled(n));
        button.setSelection(this.isSelected(n));
        button.addSelectionListener(selectionListener);
        return button;
    }

    private void doWidgetSelected(SelectionEvent selectionEvent) {
        Button button = (Button)selectionEvent.widget;
        int n = 0;
        while (n < this.fButtons.length) {
            if (this.fButtons[n] == button) {
                this.fButtonsSelected[n] = button.getSelection();
                this.dialogFieldChanged();
                return;
            }
            ++n;
        }
    }

    protected final void assertCompositeNotNull(Composite composite) {
        Assert.isNotNull((Object)composite, (String)"uncreated control requested with composite null");
    }

    protected final void assertEnoughColumns(int n) {
        Assert.isTrue((n >= this.getNumberOfControls() ? 1 : 0) != 0, (String)"given number of columns is too small");
    }

    protected final boolean isOkToUse(Control control) {
        return control != null && !control.isDisposed();
    }

    protected void updateEnableState() {
        if (this.fLabel != null) {
            this.fLabel.setEnabled(this.fEnabled);
        }
        if (this.fButtons != null) {
            boolean bl = this.isEnabled();
            int n = 0;
            while (n < this.fButtons.length) {
                Button button = this.fButtons[n];
                if (this.isOkToUse((Control)button)) {
                    button.setEnabled(bl && this.fButtonsEnabled[n]);
                }
                ++n;
            }
        }
    }

    public static interface SelectionButtonGroupListener {
        public void groupChanged(MethodStubsSelectionButtonGroup var1);
    }
}

