/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.mtj.core.build.MTJBuildState;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.internal.core.build.BuildHookInfo;
import org.eclipse.mtj.internal.core.build.BuildHooksRegistry;
import org.eclipse.mtj.internal.core.util.MTJStatusHandler;

public class BuildStateMachine {
    private static Map<IMTJProject, BuildStateMachine> map;
    private List<IStatus> buildStatuses = new ArrayList<IStatus>();
    private MTJBuildState currentState;
    private IMTJProject mtjProject;

    public static synchronized BuildStateMachine getInstance(IMTJProject iMTJProject) {
        BuildStateMachine buildStateMachine = null;
        if (map == null) {
            map = new HashMap<IMTJProject, BuildStateMachine>();
        }
        if ((buildStateMachine = map.get(iMTJProject)) == null) {
            buildStateMachine = new BuildStateMachine(iMTJProject);
            map.put(iMTJProject, buildStateMachine);
        }
        return buildStateMachine;
    }

    private BuildStateMachine(IMTJProject iMTJProject) {
        this.mtjProject = iMTJProject;
    }

    public synchronized void start(IProgressMonitor iProgressMonitor) throws CoreException {
        this.currentState = null;
        this.buildStatuses.clear();
        this.changeState(MTJBuildState.PRE_BUILD, iProgressMonitor);
    }

    public synchronized void changeState(MTJBuildState mTJBuildState, IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.currentState == null && mTJBuildState != MTJBuildState.PRE_BUILD) {
            throw new CoreException(MTJStatusHandler.newStatus(4, 999, "Build state machine has not been initialized."));
        }
        if (this.currentState == mTJBuildState) {
            return;
        }
        this.currentState = mTJBuildState;
        List<BuildHookInfo> list = BuildHooksRegistry.getInstance().getBuildHooks();
        for (BuildHookInfo buildHookInfo : list) {
            try {
                buildHookInfo.getHook().buildStateChanged(this.mtjProject, this.currentState, iProgressMonitor);
            }
            catch (CoreException coreException) {
                this.handleException(coreException);
            }
        }
        if (this.currentState == MTJBuildState.POST_BUILD && this.buildStatuses.size() > 0) {
            for (IStatus iStatus : this.buildStatuses) {
                IStatusHandler iStatusHandler = DebugPlugin.getDefault().getStatusHandler(iStatus);
                if (iStatusHandler == null) continue;
                iStatusHandler.handleStatus(iStatus, (Object)this);
            }
        }
    }

    private void handleException(CoreException coreException) throws CoreException {
        IStatus iStatus = coreException.getStatus();
        if (iStatus.getSeverity() == 4) {
            throw coreException;
        }
        this.buildStatuses.add(iStatus);
    }
}

