/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build;

import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.build.MTJBuildPropertiesChangeListener;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.osgi.util.NLS;

public class MTJBuildProperties
extends Properties {
    private static final long serialVersionUID = -3576616481147533654L;
    private static Map<IMTJProject, MTJBuildProperties> map;
    private List<MTJBuildPropertiesChangeListener> listeners;
    private IMTJProject mtjProject;

    public static synchronized MTJBuildProperties getBuildProperties(IMTJProject iMTJProject) {
        MTJBuildProperties mTJBuildProperties;
        if (map == null) {
            map = new HashMap<IMTJProject, MTJBuildProperties>();
        }
        if ((mTJBuildProperties = map.get(iMTJProject)) == null) {
            mTJBuildProperties = new MTJBuildProperties(iMTJProject);
            map.put(iMTJProject, mTJBuildProperties);
        }
        return mTJBuildProperties;
    }

    private MTJBuildProperties(IMTJProject iMTJProject) {
        if (iMTJProject == null) {
            throw new IllegalArgumentException(Messages.MTJBuildProperties_invalidMTJProject);
        }
        this.listeners = new ArrayList<MTJBuildPropertiesChangeListener>();
        this.mtjProject = iMTJProject;
        IFile iFile = this.getBuildPropertyFile();
        if (iFile.exists()) {
            try {
                this.load(new FileInputStream(iFile.getLocation().toOSString()));
            }
            catch (IOException iOException) {
                MTJLogger.log(4, iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertiesChangeListener(MTJBuildPropertiesChangeListener mTJBuildPropertiesChangeListener) {
        List<MTJBuildPropertiesChangeListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(mTJBuildPropertiesChangeListener)) {
                this.listeners.add(mTJBuildPropertiesChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertiesChangeListener(MTJBuildPropertiesChangeListener mTJBuildPropertiesChangeListener) {
        List<MTJBuildPropertiesChangeListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(mTJBuildPropertiesChangeListener)) {
                this.listeners.remove(mTJBuildPropertiesChangeListener);
            }
        }
    }

    public void setBuildProperty(MTJRuntime mTJRuntime, IResource[] iResourceArray) {
        IResource[] iResourceArray2;
        ArrayList<IResource[]> arrayList = new ArrayList<IResource[]>();
        IResource[] iResourceArray3 = iResourceArray;
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            iResourceArray2 = iResourceArray3[n2];
            if (iResourceArray2 instanceof IFile) {
                arrayList.add(iResourceArray2);
            }
            ++n2;
        }
        iResourceArray2 = arrayList.toArray(new IResource[arrayList.size()]);
        this.setProperty(mTJRuntime.getName(), this.getResourcesString(iResourceArray2));
    }

    public IResource[] getBuildProperty(MTJRuntime mTJRuntime) {
        String[] stringArray;
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        String string = mTJRuntime.getName();
        IProject iProject = this.mtjProject.getProject();
        String string2 = this.getProperty(string);
        String[] stringArray2 = stringArray = string2.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = stringArray2[n2];
            IResource iResource = iProject.findMember(string3);
            if (iResource != null && iResource instanceof IFile) {
                arrayList.add(iResource);
            }
            ++n2;
        }
        return arrayList.toArray(new IResource[arrayList.size()]);
    }

    public String getProperty(String string) {
        String string2 = super.getProperty(string);
        if (string2 == null) {
            string2 = this.getDefaultSourceContent();
        }
        return string2;
    }

    public void store(Writer writer, String string) throws IOException {
        PrintWriter printWriter = null;
        printWriter = !(writer instanceof PrintWriter) ? new PrintWriter(writer) : (PrintWriter)writer;
        try {
            this.writeProperties(printWriter, string);
            printWriter.flush();
            printWriter.close();
        }
        finally {
            this.notifyListeners();
        }
    }

    public void store(OutputStream outputStream, String string) throws IOException {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
        this.store(printWriter, string);
    }

    public void store() throws IOException {
        IFile iFile = this.getBuildPropertyFile();
        PrintWriter printWriter = new PrintWriter(new FileWriter(iFile.getLocation().toFile()));
        this.store(printWriter, Messages.MTJBuildProperties_mtjBuildPropertiesComment);
        try {
            if (!MTJCore.getWorkspace().isTreeLocked()) {
                iFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException coreException) {
            MTJLogger.log(4, coreException);
        }
    }

    public IFile getBuildPropertyFile() {
        return this.mtjProject.getProject().getFile("build.properties");
    }

    public IMTJProject getMTJProject() {
        return this.mtjProject;
    }

    public StringBuffer getContent() {
        StringWriter stringWriter = new StringWriter();
        this.writeProperties(new PrintWriter(stringWriter), null);
        return stringWriter.getBuffer();
    }

    private void writeProperties(PrintWriter printWriter, String string) {
        printWriter.println(string == null ? Messages.MTJBuildProperties_mtjBuildPropertiesComment : string);
        for (MTJRuntime mTJRuntime : this.mtjProject.getRuntimeList()) {
            String string2 = mTJRuntime.getName();
            String string3 = this.getProperty(string2);
            printWriter.println(NLS.bind((String)"{0}={1}", (Object[])new String[]{string2, this.format(string3)}));
        }
    }

    private String format(String string) {
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            String[] stringArray;
            String[] stringArray2 = stringArray = string.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string3 = stringArray2[n2];
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(NLS.bind((String)"{0}\\{1}", (Object[])new String[]{string3, string2}));
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    private String getDefaultSourceContent() {
        IClasspathEntry[] iClasspathEntryArray;
        IJavaProject iJavaProject = this.mtjProject.getJavaProject();
        IProject iProject = iJavaProject.getProject();
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        try {
            IClasspathEntry[] iClasspathEntryArray2 = iClasspathEntryArray = iJavaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFolder iFolder;
                IClasspathEntry iClasspathEntry = iClasspathEntryArray2[n2];
                if (iClasspathEntry.getEntryKind() == 3 && (iFolder = iProject.getFolder(iClasspathEntry.getPath().removeFirstSegments(1))).exists()) {
                    ResourceCollector resourceCollector = new ResourceCollector();
                    iFolder.accept((IResourceVisitor)resourceCollector);
                    arrayList.addAll(resourceCollector.getResources());
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            MTJLogger.log(4, coreException);
        }
        iClasspathEntryArray = arrayList.toArray(new IResource[arrayList.size()]);
        return this.getResourcesString((IResource[])iClasspathEntryArray);
    }

    private String getResourcesString(IResource[] iResourceArray) {
        StringBuffer stringBuffer = new StringBuffer();
        IResource[] iResourceArray2 = iResourceArray;
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource iResource = iResourceArray2[n2];
            String string = iResource.getProjectRelativePath().toString();
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(string);
            ++n2;
        }
        return stringBuffer.toString();
    }

    private void notifyListeners() {
        for (MTJBuildPropertiesChangeListener mTJBuildPropertiesChangeListener : this.listeners) {
            mTJBuildPropertiesChangeListener.propertiesChanged(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResourceCollector
    implements IResourceVisitor {
        private List<IResource> resources = new ArrayList<IResource>();

        public boolean visit(IResource iResource) throws CoreException {
            if (iResource instanceof IFile) {
                this.resources.add(iResource);
            }
            return true;
        }

        public List<IResource> getResources() {
            return this.resources;
        }
    }
}

