/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.refactoring;

import java.io.IOException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.mtj.internal.core.l10n.Messages;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class L10NResourcesMoveParticipant
extends MoveParticipant {
    private IJavaElement oldParent;
    private IJavaProject jProject;

    protected boolean initialize(Object object) {
        ICompilationUnit iCompilationUnit;
        if (object instanceof ICompilationUnit && (iCompilationUnit = (ICompilationUnit)object).getElementName().equals("L10nResources.java")) {
            this.jProject = iCompilationUnit.getJavaProject();
            this.oldParent = iCompilationUnit.getParent();
            return true;
        }
        return false;
    }

    public RefactoringStatus checkConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext) throws OperationCanceledException {
        return null;
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        IProject iProject;
        IPackageFragment iPackageFragment;
        block10: {
            MoveArguments moveArguments = this.getArguments();
            Object object = moveArguments.getDestination();
            if (object instanceof IPackageFragment) {
                iPackageFragment = (IPackageFragment)object;
                iProject = this.jProject.getProject();
                IFile iFile = iProject.getFile("Localization Data");
                if (iFile.exists()) {
                    try {
                        IPath iPath = iFile.getLocation();
                        Document document = Utils.getXmlDocument(iPath);
                        Element element = document.getDocumentElement();
                        element.setAttribute("package", iPackageFragment.getElementName());
                        TransformerFactory transformerFactory = TransformerFactory.newInstance();
                        Transformer transformer = transformerFactory.newTransformer();
                        transformer.transform(new DOMSource(document), new StreamResult(iPath.toFile()));
                    }
                    catch (IOException iOException) {
                        MTJLogger.log(4, Messages.L10nBuilder_ErrorParsingLocalizationData);
                        this.jProject.getProject().refreshLocal(2, iProgressMonitor);
                        break block10;
                    }
                    catch (Exception exception) {
                        try {
                            MTJLogger.log(4, exception);
                            break block10;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            this.jProject.getProject().refreshLocal(2, iProgressMonitor);
                        }
                    }
                    this.jProject.getProject().refreshLocal(2, iProgressMonitor);
                }
            }
        }
        if (this.oldParent != null && this.oldParent instanceof IPackageFragment && (iProject = (iPackageFragment = (IPackageFragment)this.oldParent).getCompilationUnit("L10nConstants.java")) != null && iProject.exists()) {
            iProject.delete(true, iProgressMonitor);
        }
        return null;
    }

    public String getName() {
        return "Localization Data Participant";
    }
}

