/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device.midp;

import java.io.File;
import java.util.List;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.ProjectType;
import org.eclipse.mtj.core.sdk.device.IAPI;
import org.eclipse.mtj.core.sdk.device.ILibraryImporter;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPLibrary;
import org.eclipse.mtj.internal.core.sdk.device.JavadocDetector;
import org.eclipse.mtj.internal.core.sdk.device.midp.APIRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UEILibraryImporter
implements ILibraryImporter {
    public static final String ID = "UEI_LIBRARY_IMPORTER";
    JavadocDetector javadocDetector;

    @Override
    public IMIDPLibrary createLibraryFor(File file) {
        List<IAPI> list = APIRegistry.getAPIs(file);
        IMIDPLibrary iMIDPLibrary = (IMIDPLibrary)MTJCore.createNewLibrary(ProjectType.MIDLET_SUITE);
        iMIDPLibrary.setApis(list);
        iMIDPLibrary.setLibraryFile(file);
        if (this.javadocDetector != null) {
            iMIDPLibrary.setJavadocURL(this.javadocDetector.detectJavadoc(iMIDPLibrary));
        }
        return iMIDPLibrary;
    }

    @Override
    public IMIDPLibrary createLibraryFor(File file, List<IAccessRule> list) {
        List<IAPI> list2 = APIRegistry.getAPIs(file);
        IMIDPLibrary iMIDPLibrary = (IMIDPLibrary)MTJCore.createNewLibrary(ProjectType.MIDLET_SUITE);
        iMIDPLibrary.setAccessRules(list);
        iMIDPLibrary.setApis(list2);
        iMIDPLibrary.setLibraryFile(file);
        return iMIDPLibrary;
    }

    public void setJavadocDetector(JavadocDetector javadocDetector) {
        this.javadocDetector = javadocDetector;
    }
}

