/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.text;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mtj.internal.core.IModel;
import org.eclipse.mtj.internal.core.text.AbstractEditingModel;
import org.eclipse.mtj.internal.core.text.IWritable;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.core.util.xml.SAXParserWrapper;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLEditingModel
extends AbstractEditingModel {
    private IStatus status;

    public XMLEditingModel(IDocument iDocument, boolean bl) {
        super(iDocument, bl);
    }

    public void adjustOffsets(IDocument iDocument) {
        try {
            SAXParserWrapper sAXParserWrapper = new SAXParserWrapper();
            sAXParserWrapper.parse(this.getInputStream(iDocument), this.createDocumentHandler(this, false));
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (FactoryConfigurationError factoryConfigurationError) {}
    }

    public String getContents() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.setLoaded(true);
        this.save(printWriter);
        printWriter.flush();
        try {
            stringWriter.close();
        }
        catch (IOException iOException) {}
        return stringWriter.toString();
    }

    public IStatus getStatus() {
        return this.status;
    }

    public void load(InputStream inputStream, boolean bl) {
        try {
            this.fLoaded = true;
            this.status = new Status(0, "org.eclipse.mtj.core", null);
            SAXParserWrapper sAXParserWrapper = new SAXParserWrapper();
            sAXParserWrapper.parse(inputStream, this.createDocumentHandler(this, true));
        }
        catch (SAXException sAXException) {
            this.fLoaded = false;
            this.status = new Status(4, "org.eclipse.mtj.core", sAXException.getMessage(), (Throwable)sAXException);
        }
        catch (IOException iOException) {
            this.fLoaded = false;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.fLoaded = false;
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            this.fLoaded = false;
        }
    }

    public void reload() {
        if (!this.isResourceFile()) {
            return;
        }
        IFile iFile = (IFile)this.getUnderlyingResource();
        if (iFile.exists()) {
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(iFile.getContents(true));
                this.reload(bufferedInputStream, false);
                this.setDirty(false);
            }
            catch (CoreException coreException) {}
        }
    }

    public void reload(IDocument iDocument) {
        String string = iDocument.get();
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF8"));
            this.reload(byteArrayInputStream, false);
            this.setDirty(false);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            MTJLogger.log(4, unsupportedEncodingException);
        }
        catch (CoreException coreException) {}
    }

    public void save() {
        if (!this.isResourceFile()) {
            return;
        }
        try {
            IFile iFile = (IFile)this.getUnderlyingResource();
            String string = this.getContents();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF8"));
            if (iFile.exists()) {
                iFile.setContents((InputStream)byteArrayInputStream, false, false, null);
            } else {
                iFile.create((InputStream)byteArrayInputStream, false, null);
            }
            byteArrayInputStream.close();
        }
        catch (CoreException coreException) {
            MTJLogger.log(4, coreException);
        }
        catch (IOException iOException) {}
    }

    public void save(PrintWriter printWriter) {
        if (this.isLoaded()) {
            this.getRoot().write("", printWriter);
        }
        this.setDirty(false);
    }

    private boolean isResourceFile() {
        if (this.getUnderlyingResource() == null) {
            return false;
        }
        return this.getUnderlyingResource() instanceof IFile;
    }

    protected abstract DefaultHandler createDocumentHandler(IModel var1, boolean var2);

    protected abstract IWritable getRoot();
}

