/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mtj.internal.core.util.MTJHTMLHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTJTextHelper {
    public static final String F_DOTS = "...";

    public static boolean isDefined(String string) {
        return string != null && string.length() != 0;
    }

    public static boolean isDefinedAfterTrim(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        return string2.length() != 0;
    }

    public static String translateReadText(String string) {
        if (string == null) {
            return "";
        }
        String string2 = "";
        String string3 = string.trim();
        int n = string3.length();
        int n2 = 32;
        StringBuffer stringBuffer = new StringBuffer(n);
        int n3 = 0;
        while (n3 < n) {
            int n4 = string3.charAt(n3);
            if (n4 == 13 || n4 == 10 || n4 == 9) {
                n4 = 32;
            }
            if (n4 == 32) {
                if (n2 != 32) {
                    stringBuffer.append((char)n4);
                    n2 = n4;
                }
            } else {
                stringBuffer.append((char)n4);
                n2 = n4;
            }
            ++n3;
        }
        string2 = stringBuffer.toString();
        if (MTJHTMLHelper.isAllWhitespace(string2)) {
            return "";
        }
        return string2;
    }

    public static String translateWriteText(String string, HashMap<Character, String> hashMap) {
        return MTJTextHelper.translateWriteText(string, null, hashMap);
    }

    public static String translateWriteText(String string, HashSet<String> hashSet, HashMap<Character, String> hashMap) {
        if (string == null) {
            return "";
        }
        boolean bl = false;
        int n = 0;
        if (hashSet != null && !hashSet.isEmpty()) {
            bl = true;
            n = MTJTextHelper.determineMaxLength(hashSet);
        }
        boolean bl2 = false;
        if (hashMap != null && !hashMap.isEmpty()) {
            bl2 = true;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        IntegerPointer integerPointer = new IntegerPointer(0);
        while (integerPointer.getInteger() < string.length()) {
            char c = string.charAt(integerPointer.getInteger());
            boolean bl3 = false;
            if (!bl3 && bl) {
                bl3 = MTJTextHelper.processTagExceptions(c, hashMap, hashSet, stringBuffer, n, string, integerPointer);
            }
            if (!bl3 && bl2) {
                bl3 = MTJTextHelper.processSubstituteChars(c, hashMap, stringBuffer);
            }
            if (!bl3) {
                stringBuffer.append(c);
            }
            integerPointer.increment();
        }
        return stringBuffer.toString();
    }

    public static String truncateAndTrailOffText(String string, int n) {
        String string2 = string.trim();
        int n2 = F_DOTS.length();
        int n3 = string2.length();
        int n4 = n - n2;
        if (n >= n3) {
            return string2;
        }
        if (n <= n2) {
            return "";
        }
        return String.valueOf(string2.substring(0, n4)) + F_DOTS;
    }

    private static int determineMaxLength(HashSet<String> hashSet) {
        Iterator<String> iterator = hashSet.iterator();
        int n = -1;
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.length() <= n) continue;
            n = string.length();
        }
        return n;
    }

    private static String getTagName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (Character.isWhitespace(c)) break;
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    private static boolean isValidTagAttributeList(String string) {
        String string2 = "^([\\s]+[A-Za-z0-9_:\\-\\.]+[\\s]?=[\\s]?\".+?\")*[\\s]*[/]?$";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    private static boolean isValidTagException(HashSet<String> hashSet, String string) {
        String string2 = MTJTextHelper.getTagName(string);
        return hashSet.contains(string2);
    }

    private static boolean processSubstituteChars(char c, HashMap<Character, String> hashMap, StringBuffer stringBuffer) {
        Character c2 = new Character(c);
        if (hashMap.containsKey(c2)) {
            String string = hashMap.get(c2);
            if (MTJTextHelper.isDefined(string)) {
                stringBuffer.append(string);
            }
            return true;
        }
        return false;
    }

    private static void processTagExceptionCharacters(HashMap<Character, String> hashMap, StringBuffer stringBuffer, String string) {
        String string2 = MTJTextHelper.getTagName(string);
        boolean bl = string.endsWith("/");
        String string3 = string.substring(string2.length());
        if (!MTJTextHelper.isValidTagAttributeList(string3)) {
            stringBuffer.append('<');
            stringBuffer.append(string2);
            if (bl) {
                stringBuffer.append('/');
            }
            stringBuffer.append('>');
            return;
        }
        if (string3.length() == 0) {
            stringBuffer.append('<');
            stringBuffer.append(string2);
            stringBuffer.append('>');
            return;
        }
        boolean bl2 = false;
        stringBuffer.append('<');
        int n = 0;
        while (n < string.length()) {
            boolean bl3;
            boolean bl4 = false;
            char c = string.charAt(n);
            boolean bl5 = bl3 = c == '\"';
            if (bl3) {
                bl2 = !bl2;
            }
            if (bl2 && !bl3) {
                bl4 = MTJTextHelper.processSubstituteChars(c, hashMap, stringBuffer);
            }
            if (!bl4) {
                stringBuffer.append(c);
            }
            ++n;
        }
        stringBuffer.append('>');
    }

    private static boolean processTagExceptions(char c, HashMap<Character, String> hashMap, HashSet<String> hashSet, StringBuffer stringBuffer, int n, String string, IntegerPointer integerPointer) {
        if (c == '<') {
            int n2 = string.length();
            StringBuffer stringBuffer2 = new StringBuffer();
            int n3 = integerPointer.getInteger() + 1;
            while (n3 < n2) {
                char c2 = string.charAt(n3);
                if (c2 == '>') {
                    String string2 = stringBuffer2.toString();
                    if (MTJTextHelper.isValidTagException(hashSet, string2)) {
                        MTJTextHelper.processTagExceptionCharacters(hashMap, stringBuffer, string2);
                        integerPointer.setInteger(n3);
                        return true;
                    }
                    return false;
                }
                stringBuffer2.append(c2);
                ++n3;
            }
        }
        return false;
    }

    private static class IntegerPointer {
        private int fInteger;

        public IntegerPointer(int n) {
            this.fInteger = n;
        }

        public int getInteger() {
            return this.fInteger;
        }

        public void increment() {
            ++this.fInteger;
        }

        public void setInteger(int n) {
            this.fInteger = n;
        }
    }
}

