/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceableParametersProcessor {
    private static Pattern OPTIONAL_BLOCK_PATTERN = Pattern.compile("\\[%(.*?)%\\|(.*?)\\]");
    private static Pattern PROPS_PATTERN = Pattern.compile("%(.*?)%");
    private static final String TEMP_PROP = "__mtjTemp";

    public static String processReplaceableValues(String string, Map<String, String> map) {
        map.put(TEMP_PROP, string);
        String string2 = ReplaceableParametersProcessor.getResolvedPropertyValue(TEMP_PROP, map);
        map.remove(TEMP_PROP);
        return string2;
    }

    private static String getResolvedPropertyValue(String string, Map<String, String> map) {
        String string2 = map.get(string);
        String string3 = string2 == null ? "" : string2.toString();
        StringBuffer stringBuffer = new StringBuffer(string3);
        ReplaceableParametersProcessor.resolveOptionalBlocks(stringBuffer, map);
        ReplaceableParametersProcessor.resolvePropertyValues(stringBuffer, map);
        string3 = stringBuffer.toString();
        map.put(string, string3);
        return string3;
    }

    private static void resolveOptionalBlocks(StringBuffer stringBuffer, Map<String, String> map) {
        int n = 0;
        Matcher matcher = OPTIONAL_BLOCK_PATTERN.matcher(stringBuffer);
        if (matcher.find()) {
            while (matcher.find(n)) {
                String string = matcher.group(1);
                String string2 = matcher.group(2);
                String string3 = ReplaceableParametersProcessor.getResolvedPropertyValue(string, map);
                String string4 = "";
                if (string3 != null && string3.length() > 0) {
                    string4 = string2;
                }
                stringBuffer.replace(matcher.start(), matcher.end(), string4);
                n = matcher.start() + string4.length();
            }
        }
    }

    private static void resolvePropertyValues(StringBuffer stringBuffer, Map<String, String> map) {
        int n = 0;
        Matcher matcher = PROPS_PATTERN.matcher(stringBuffer);
        if (matcher.find()) {
            while (matcher.find(n)) {
                String string = matcher.group(1);
                String string2 = ReplaceableParametersProcessor.getResolvedPropertyValue(string, map);
                if (string2 == null) continue;
                stringBuffer.replace(matcher.start(), matcher.end(), string2);
                n = matcher.start() + string2.length();
            }
        }
    }

    private ReplaceableParametersProcessor() {
    }
}

