/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final String EMPTY_STRING = "";
    private static final byte[] buffer = new byte[1024];
    private static boolean caseSensitiveFileSystem;
    private static boolean caseSensitivityChecked;
    private static final FileFilter DEFAULT_FILTER;
    private static final String PRIVATE_CONFIGURATION = "org.eclipse.debug.ui.private";

    static {
        DEFAULT_FILTER = new FileFilter(){

            public boolean accept(File file) {
                return true;
            }
        };
    }

    public static boolean arePathTargetsEqual(IPath iPath, IPath iPath2) throws CoreException {
        boolean bl = false;
        File file = Utils.getPathTargetFile(iPath);
        File file2 = Utils.getPathTargetFile(iPath2);
        if (file != null && file2 != null) {
            bl = file.equals(file2);
        }
        return bl;
    }

    public static void clearContainer(IContainer iContainer, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iContainer.exists()) {
            IResource[] iResourceArray;
            IResource[] iResourceArray2 = iResourceArray = iContainer.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource = iResourceArray2[n2];
                ResourceAttributes resourceAttributes = iResource.getResourceAttributes();
                if (resourceAttributes != null) {
                    if (resourceAttributes.isReadOnly()) {
                        resourceAttributes.setReadOnly(false);
                        iResource.setResourceAttributes(resourceAttributes);
                    }
                    if (iResource instanceof IContainer) {
                        Utils.clearContainer((IContainer)iResource, iProgressMonitor);
                        iResource.delete(true, iProgressMonitor);
                    } else {
                        iResource.delete(true, iProgressMonitor);
                    }
                }
                ++n2;
            }
        }
    }

    public static String codeFormat(IJavaProject iJavaProject, String string, int n, int n2, String string2) {
        CodeFormatter codeFormatter = ToolFactory.createCodeFormatter((Map)iJavaProject.getOptions(true));
        TextEdit textEdit = codeFormatter.format(n, string, 0, string.length(), n2, string2);
        if (textEdit != null) {
            Document document = new Document(string);
            try {
                textEdit.apply((IDocument)document);
                return document.get();
            }
            catch (MalformedTreeException malformedTreeException) {
            }
            catch (BadLocationException badLocationException) {}
        }
        return string;
    }

    public static void copy(File file, File file2) throws IOException {
        Utils.copy(file, file2, null);
    }

    public static void copy(File file, File file2, FileFilter fileFilter) throws IOException, SecurityException {
        if (file.exists()) {
            if (file.isDirectory()) {
                Utils.copyDirectory(file, file2, fileFilter);
            } else {
                Utils.copyFile(file, file2, fileFilter);
            }
        }
    }

    public static void copyDirectory(File file, File file2, FileFilter fileFilter) throws IOException, SecurityException {
        if (fileFilter == null) {
            fileFilter = DEFAULT_FILTER;
        }
        if (file.exists() && file.isDirectory() && fileFilter.accept(file)) {
            File[] fileArray;
            file2.mkdirs();
            File[] fileArray2 = fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file3 = fileArray2[n2];
                File file4 = new File(file2, file3.getName());
                if (file3.isDirectory()) {
                    Utils.copyDirectory(file3, file4, fileFilter);
                } else {
                    Utils.copyFile(file3, file4, fileFilter);
                }
                ++n2;
            }
        }
    }

    public static void copyFile(File file, File file2, FileFilter fileFilter) throws IOException, SecurityException {
        if (fileFilter == null) {
            fileFilter = DEFAULT_FILTER;
        }
        if (fileFilter.accept(file)) {
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            Utils.copyInputToOutput(fileInputStream, fileOutputStream);
            fileInputStream.close();
            fileOutputStream.close();
        }
    }

    public static void copyFile(IFile iFile, IFile iFile2) throws IOException, SecurityException {
        Utils.copyFile(iFile.getLocation().toFile(), iFile2.getLocation().toFile(), null);
    }

    public static void copyInputToOutput(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n = 0;
        do {
            if ((n = inputStream.read(buffer, 0, buffer.length)) <= 0) continue;
            outputStream.write(buffer, 0, n);
        } while (n != -1);
        outputStream.flush();
    }

    public static void createArchive(File file, File file2) throws IOException {
        if (file2.exists() && file2.isDirectory()) {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            try {
                Utils.addFolderToArchive(zipOutputStream, file2.getAbsolutePath().length() + 1, file2);
            }
            catch (Throwable throwable) {
                if (zipOutputStream != null) {
                    try {
                        zipOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void delete(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray;
                File[] fileArray2 = fileArray = file.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file2 = fileArray2[n2];
                    Utils.delete(file2);
                    ++n2;
                }
            }
            file.delete();
        }
    }

    public static void dumpCommandLine(ILaunch iLaunch) {
        IProcess iProcess;
        IProcess[] iProcessArray = iLaunch.getProcesses();
        if (iProcessArray != null && iProcessArray.length > 0 && (iProcess = iProcessArray[0]) != null) {
            String string = iProcess.getAttribute(IProcess.ATTR_CMDLINE);
            Utils.dumpCommandLine(string);
        }
    }

    public static void dumpCommandLine(String string) {
        String string2 = System.getProperty("mtj.dump.launch", Boolean.FALSE.toString());
        boolean bl = string2.equalsIgnoreCase(Boolean.TRUE.toString());
        if (bl) {
            String string3 = string == null ? Messages.Utils_commandLine_not_found : String.valueOf(Messages.Utils_commandLine) + string;
            MTJLogger.log(1, string3);
        }
    }

    public static void dumpCommandLine(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (n != 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(string);
            ++n;
        }
        Utils.dumpCommandLine(stringBuffer.toString());
    }

    public static Process exec(String[] stringArray, File file, String[] stringArray2) throws CoreException {
        return DebugPlugin.exec((String[])stringArray, (File)file, (String[])stringArray2);
    }

    public static boolean executableExists(File file) {
        File file2 = new File(file.getParentFile(), String.valueOf(file.getName()) + ".exe");
        return file.exists() || file2.exists();
    }

    public static void extractArchive(File file, File file2) throws IOException, SecurityException {
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
        try {
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                File file3;
                if (zipEntry.isDirectory()) {
                    file3 = new File(file2, zipEntry.getName());
                    file3.mkdirs();
                    continue;
                }
                file3 = new File(file2, zipEntry.getName());
                File file4 = file3.getParentFile();
                if (file4 == null) continue;
                file4.mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                try {
                    Utils.copyInputToOutput(zipInputStream, fileOutputStream);
                }
                catch (Throwable throwable) {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (fileOutputStream == null) continue;
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (Throwable throwable) {
            try {
                zipInputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            zipInputStream.close();
        }
        catch (IOException iOException) {}
    }

    public static String extractClassName(IJavaProject iJavaProject, IResource iResource) throws JavaModelException {
        IPath iPath = Utils.extractsSourceFolderRelativePath(iJavaProject, iResource);
        return iPath == null ? null : iPath.removeFileExtension().toString().replace('/', '.');
    }

    public static IPath extractsSourceFolderRelativePath(IJavaProject iJavaProject, IResource iResource) throws JavaModelException {
        return Utils.extractsSourceFolderRelativePath(iJavaProject, iResource, false);
    }

    public static IPath extractsSourceFolderRelativePath(IJavaProject iJavaProject, IResource iResource, boolean bl) throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray;
        IPath iPath = null;
        IPath iPath2 = iJavaProject.getOutputLocation().makeAbsolute();
        IPath iPath3 = iResource.getFullPath();
        IClasspathEntry[] iClasspathEntryArray2 = iClasspathEntryArray = iJavaProject.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry iClasspathEntry = iClasspathEntryArray2[n2];
            if (iClasspathEntry.getEntryKind() == 3) {
                IPath iPath4 = null;
                if (bl) {
                    iPath4 = iClasspathEntry.getPath().makeAbsolute();
                } else {
                    iPath4 = iClasspathEntry.getOutputLocation();
                    IPath iPath5 = iPath4 = iPath4 == null ? iPath2 : iPath4.makeAbsolute();
                }
                if (iPath4.isPrefixOf(iPath3)) {
                    iPath = iPath3.removeFirstSegments(iPath4.segmentCount());
                    break;
                }
            }
            ++n2;
        }
        return iPath;
    }

    public static IClasspathAttribute getJavadocAttribute(IClasspathEntry iClasspathEntry) {
        int n = Utils.getJavadocAttributeIndex(iClasspathEntry);
        return n == -1 ? null : iClasspathEntry.getExtraAttributes()[n];
    }

    public static int getJavadocAttributeIndex(IClasspathEntry iClasspathEntry) {
        int n = -1;
        IClasspathAttribute[] iClasspathAttributeArray = iClasspathEntry.getExtraAttributes();
        int n2 = 0;
        while (n2 < iClasspathAttributeArray.length) {
            IClasspathAttribute iClasspathAttribute = iClasspathAttributeArray[n2];
            if (iClasspathAttribute.getName().equals("javadoc_location")) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public static String[] getJavaProjectSourceDirectories(IJavaProject iJavaProject) throws CoreException {
        LinkedList<String> linkedList = new LinkedList<String>();
        IClasspathEntry[] iClasspathEntryArray = null;
        IClasspathEntry[] iClasspathEntryArray2 = iClasspathEntryArray = iJavaProject.getResolvedClasspath(true);
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry iClasspathEntry = iClasspathEntryArray2[n2];
            if (iClasspathEntry.getEntryKind() == 3 && iClasspathEntry.getContentKind() == 1) {
                IPath iPath = iClasspathEntry.getPath();
                linkedList.add(iPath.lastSegment());
            }
            ++n2;
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static String getKeyringURL(IProject iProject) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("projects.mtj/");
        String string = iProject.getName();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (Character.isLetterOrDigit(c) || c == '.') {
                stringBuffer.append(c);
            } else {
                stringBuffer.append('%');
                String string2 = Integer.toHexString(c);
                if ((string2.length() & 1) != 0) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string2);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static List<IType> getMidletTypesInProject(IProgressMonitor iProgressMonitor, IJavaProject iJavaProject) {
        HashSet<IType> hashSet = new HashSet<IType>(5);
        try {
            IType iType = iJavaProject.findType("javax.microedition.midlet.MIDlet");
            ITypeHierarchy iTypeHierarchy = iType.newTypeHierarchy(iJavaProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            IType[] iTypeArray = iTypeHierarchy.getAllSubtypes(iType);
            int n = iTypeArray.length;
            if (n != 0) {
                int n2 = 0;
                while (n2 < n) {
                    if (!iTypeArray[n2].isBinary()) {
                        hashSet.add(iTypeArray[n2]);
                    }
                    ++n2;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        iProgressMonitor.done();
        return new ArrayList<IType>(hashSet);
    }

    public static ILaunch getNewLaunch(String string) throws CoreException {
        return new Launch(Utils.getNewLaunchConfiguration(string), "run", null);
    }

    public static ILaunchConfiguration getNewLaunchConfiguration(String string) throws CoreException {
        ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType iLaunchConfigurationType = iLaunchManager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, string);
        iLaunchConfigurationWorkingCopy.setAttribute(PRIVATE_CONFIGURATION, true);
        return iLaunchConfigurationWorkingCopy;
    }

    public static Object getPathTarget(IPath iPath) {
        Object object = null;
        IWorkspaceRoot iWorkspaceRoot = MTJCore.getWorkspace().getRoot();
        object = iWorkspaceRoot.findMember(iPath);
        if (object == null) {
            File file = new File(iPath.toOSString());
            object = file != null && file.isFile() ? file : null;
        }
        return object;
    }

    public static File getPathTargetFile(IPath iPath) throws CoreException {
        File file = null;
        Object object = Utils.getPathTarget(iPath);
        if (object instanceof IResource) {
            file = ((IResource)object).getLocation().toFile();
        } else if (object instanceof File) {
            file = (File)object;
        }
        return file;
    }

    public static int getProcessOutput(String string, String[] stringArray, StringBuffer stringBuffer, StringBuffer stringBuffer2) throws CoreException {
        IProcess iProcess = Utils.launchApplication(stringArray, null, null, string, string);
        IStreamsProxy iStreamsProxy = iProcess.getStreamsProxy();
        iStreamsProxy.getOutputStreamMonitor().addListener((IStreamListener)new StreamListener(stringBuffer));
        iStreamsProxy.getErrorStreamMonitor().addListener((IStreamListener)new StreamListener(stringBuffer2));
        while (!iProcess.isTerminated()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return iProcess.getExitValue();
    }

    public static String getQualifiedClassName(IType iType) {
        String string = null;
        string = iType instanceof BinaryType ? Utils.getQualifiedClassName((BinaryType)iType) : iType.getFullyQualifiedName();
        return string;
    }

    public static IJavaProject[] getRequiredProjects(IJavaProject iJavaProject) throws JavaModelException {
        String[] stringArray;
        ArrayList<IJavaProject> arrayList = new ArrayList<IJavaProject>();
        String[] stringArray2 = stringArray = iJavaProject.getRequiredProjectNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            IProject iProject = MTJCore.getWorkspace().getRoot().getProject(string);
            if (iProject.exists() && iProject.isOpen()) {
                arrayList.add(JavaCore.create((IProject)iProject));
            }
            ++n2;
        }
        return arrayList.toArray(new IJavaProject[arrayList.size()]);
    }

    public static Object getResolvedClasspathEntry(IClasspathEntry iClasspathEntry) {
        IClasspathEntry iClasspathEntry2 = JavaCore.getResolvedClasspathEntry((IClasspathEntry)iClasspathEntry);
        return Utils.getPathTarget(iClasspathEntry2.getPath());
    }

    public static final File getResolvedClasspathEntryFile(IClasspathEntry iClasspathEntry) throws CoreException {
        IClasspathEntry iClasspathEntry2 = JavaCore.getResolvedClasspathEntry((IClasspathEntry)iClasspathEntry);
        return Utils.getPathTargetFile(iClasspathEntry2.getPath());
    }

    public static String getStandardOutput(String string, String[] stringArray) throws CoreException {
        return Utils.getStandardOutput(string, stringArray, null);
    }

    public static String getStandardOutput(String string, String[] stringArray, File file) throws CoreException {
        IProcess iProcess = Utils.launchApplication(stringArray, file, null, string, string);
        IStreamsProxy iStreamsProxy = iProcess.getStreamsProxy();
        while (!iProcess.isTerminated()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return iStreamsProxy.getOutputStreamMonitor().getContents();
    }

    public static String getStreamContent(InputStream inputStream) {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        try {
            while ((n = inputStream.read()) != -1) {
                stringBuffer.append((char)n);
            }
            string = stringBuffer.toString();
        }
        catch (IOException iOException) {}
        return string;
    }

    public static Document getTextDocument(InputStream inputStream) {
        String string;
        block8: {
            ByteArrayOutputStream byteArrayOutputStream = null;
            string = null;
            try {
                int n;
                byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[1024];
                while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                string = byteArrayOutputStream.toString("UTF-8");
                byteArrayOutputStream.close();
                byteArrayOutputStream = null;
                inputStream.close();
                inputStream = null;
            }
            catch (IOException iOException) {
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException2) {}
                }
                if (inputStream == null) break block8;
                try {
                    inputStream.close();
                }
                catch (IOException iOException3) {}
            }
        }
        return string == null ? null : new Document(string);
    }

    public static org.w3c.dom.Document getXmlDocument(IPath iPath) throws IOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(iPath.toFile());
        }
        catch (Exception exception) {
            throw new IOException(Messages.Utils_xml_parse_error);
        }
    }

    public static boolean isFileSystemCaseSensitive() {
        if (!caseSensitivityChecked) {
            String string;
            URL uRL;
            caseSensitivityChecked = true;
            Location location = Platform.getInstallLocation();
            if (location != null && (uRL = location.getURL()) != null && (string = uRL.toString()).startsWith("file:/")) {
                caseSensitiveFileSystem = !new File(string = string.substring("file:/".length()).toUpperCase()).exists();
            }
        }
        return caseSensitiveFileSystem;
    }

    public static boolean isMidlet(IType iType, IProgressMonitor iProgressMonitor) throws JavaModelException {
        boolean bl = false;
        if (iType != null) {
            IJavaProject iJavaProject = iType.getJavaProject();
            if (!iType.exists() && iType.isBinary()) {
                String string = Utils.getQualifiedClassName(iType);
                if (string != null) {
                    IType iType2 = iJavaProject.findType(string);
                    bl = Utils.isMidlet(iType2, iProgressMonitor);
                }
            } else {
                ITypeHierarchy iTypeHierarchy = iType.newSupertypeHierarchy(iProgressMonitor);
                IType iType3 = iJavaProject.findType("javax.microedition.midlet.MIDlet");
                bl = iType3 != null && iTypeHierarchy.contains(iType3);
            }
        }
        return bl;
    }

    public static IProcess launchApplication(String[] stringArray, File file, String[] stringArray2, String string, String string2) throws CoreException {
        Process process = Utils.exec(stringArray, file, stringArray2);
        Launch launch = new Launch(Utils.getNewLaunchConfiguration(string), "run", null);
        IProcess iProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)string2);
        Utils.dumpCommandLine(stringArray);
        return iProcess;
    }

    public static void switchAutoBuild(boolean bl) throws CoreException {
        IWorkspace iWorkspace = MTJCore.getWorkspace();
        IWorkspaceDescription iWorkspaceDescription = iWorkspace.getDescription();
        iWorkspaceDescription.setAutoBuilding(bl);
        iWorkspace.setDescription(iWorkspaceDescription);
    }

    public static boolean isAutoBuilding() {
        IWorkspace iWorkspace = MTJCore.getWorkspace();
        IWorkspaceDescription iWorkspaceDescription = iWorkspace.getDescription();
        return iWorkspaceDescription.isAutoBuilding();
    }

    private static void addFileEntryToArchive(ZipOutputStream zipOutputStream, int n, File file) throws IOException {
        ZipEntry zipEntry = Utils.getEntryForFile(file, n);
        zipOutputStream.putNextEntry(zipEntry);
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            Utils.copyInputToOutput(fileInputStream, zipOutputStream);
        }
        catch (Throwable throwable) {
            zipOutputStream.closeEntry();
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        zipOutputStream.closeEntry();
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void addFolderToArchive(ZipOutputStream zipOutputStream, int n, File file) throws IOException {
        File[] fileArray;
        File[] fileArray2 = fileArray = file.listFiles();
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            File file2 = fileArray2[n3];
            if (file2.isDirectory()) {
                Utils.addFolderToArchive(zipOutputStream, n, file2);
            } else {
                Utils.addFileEntryToArchive(zipOutputStream, n, file2);
            }
            ++n3;
        }
    }

    private static ZipEntry getEntryForFile(File file, int n) {
        String string = file.getAbsolutePath();
        String string2 = string.substring(n).replace('\\', '/');
        ZipEntry zipEntry = new ZipEntry(string2);
        zipEntry.setSize(file.length());
        zipEntry.setTime(file.lastModified());
        return zipEntry;
    }

    private static String getQualifiedClassName(BinaryType binaryType) {
        IPackageFragment iPackageFragment = binaryType.getPackageFragment();
        StringBuffer stringBuffer = new StringBuffer(binaryType.getElementName());
        while (iPackageFragment.getElementType() != 2) {
            String string = iPackageFragment.getElementName();
            if (string != null && string.length() > 0) {
                stringBuffer.insert(0, '.').insert(0, string);
            }
            iPackageFragment = iPackageFragment.getParent();
        }
        return stringBuffer.toString();
    }

    public static IResource[] getSourceFolders(IJavaProject iJavaProject) {
        ArrayList<IFolder> arrayList = new ArrayList<IFolder>();
        try {
            IClasspathEntry[] iClasspathEntryArray;
            IClasspathEntry[] iClasspathEntryArray2 = iClasspathEntryArray = iJavaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry iClasspathEntry = iClasspathEntryArray2[n2];
                if (iClasspathEntry.getEntryKind() == 3) {
                    IProject iProject = iJavaProject.getProject();
                    IPath iPath = iProject.getFullPath();
                    IFolder iFolder = iProject.getFolder(iClasspathEntry.getPath().removeFirstSegments(iPath.segmentCount()));
                    if (iFolder.exists()) {
                        arrayList.add(iFolder);
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            MTJLogger.log(4, javaModelException);
        }
        return arrayList.toArray(new IResource[arrayList.size()]);
    }

    private Utils() {
    }

    public static void setResourcesAsDerived(IContainer iContainer) throws CoreException {
        if (iContainer.exists()) {
            IResource[] iResourceArray;
            iContainer.setDerived(true);
            IResource[] iResourceArray2 = iResourceArray = iContainer.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource = iResourceArray2[n2];
                if (iResource instanceof IContainer) {
                    Utils.setResourcesAsDerived((IContainer)iResource);
                } else {
                    iResource.setDerived(true);
                }
                ++n2;
            }
        }
    }

    public static boolean isValidFolderName(String string) {
        String string2 = System.getProperty("java.io.tmpdir");
        File file = new File(string2, string);
        return file.exists() || file.mkdir();
    }

    private static class StreamListener
    implements IStreamListener {
        private StringBuffer buf;

        public StreamListener(StringBuffer stringBuffer) {
            this.buf = stringBuffer;
        }

        public void streamAppended(String string, IStreamMonitor iStreamMonitor) {
            if (this.buf != null) {
                this.buf.append(string);
            }
        }
    }
}

