/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.devices;

import java.util.List;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceRegistryListener;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.viewers.LabelProviderViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DeviceSelector {
    private String deviceGroupComentLabel = null;
    private String deviceGroupLabel = MTJUIMessages.DeviceSelector_deviceGroupLabel;
    private ComboViewer deviceNamesViewer;
    private ComboViewer deviceViewer;
    private boolean fireSelectionChangedListener = true;
    private ComboViewer groupViewer;
    private Button manageDevicesButton;
    private final Object[] NO_ELEMENTS = new Object[0];
    private IDeviceRegistryListener registryListener;
    private ISelectionChangedListener selectionChangedListener;
    private ComboViewer viewer;

    public void createContents(Composite composite, boolean bl, boolean bl2) {
        Composite composite2 = null;
        if (bl) {
            Group group = new Group(composite, 0);
            group.setText(this.deviceGroupLabel);
            composite2 = group;
        } else {
            composite2 = new Composite(composite, 0);
        }
        this.setCompositeLayout(composite, composite2);
        if (this.deviceGroupComentLabel != null) {
            new Label(composite2, 0).setText(this.deviceGroupComentLabel);
            new Label(composite2, 0);
        }
        this.createSelectionControls(composite2);
        if (bl2) {
            this.createDeviceManagementControls(composite2);
        }
        this.addRegistryListener();
        this.enableFireSelectionChanged(false);
        this.setInitialState();
        this.enableFireSelectionChanged(true);
    }

    public void dispose() {
        MTJCore.getDeviceRegistry().removeRegistryListener(this.registryListener);
    }

    public void enableFireSelectionChanged(boolean bl) {
        this.fireSelectionChangedListener = bl;
    }

    public String getDeviceGroupComentLabel() {
        return this.deviceGroupComentLabel;
    }

    public String getDeviceGroupLabel() {
        return this.deviceGroupLabel;
    }

    public IDevice getSelectedDevice() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.deviceViewer.getSelection();
        return (IDevice)iStructuredSelection.getFirstElement();
    }

    public boolean isFireSelectionChangedEnabled() {
        return this.fireSelectionChangedListener;
    }

    public void setDeviceGroupComentLabel(String string) {
        this.deviceGroupComentLabel = string;
    }

    public void setDeviceGroupLabel(String string) {
        this.deviceGroupLabel = string;
    }

    public void setEnabled(boolean bl) {
        this.manageDevicesButton.setEnabled(bl);
        this.groupViewer.getCombo().setEnabled(bl);
        this.deviceViewer.getCombo().setEnabled(bl);
    }

    public void setSelectedDevice(IDevice iDevice) {
        IDevice iDevice2 = this.getSelectedDevice();
        if (!this.areDevicesEqual(iDevice, iDevice2)) {
            if (iDevice != null) {
                this.setViewerSelection((Viewer)this.groupViewer, iDevice.getSDKName());
                this.setViewerSelection((Viewer)this.deviceViewer, iDevice);
            } else {
                this.groupViewer.setSelection(null);
                this.deviceViewer.setSelection(null);
            }
        }
    }

    public void setSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionChangedListener = iSelectionChangedListener;
    }

    private void addRegistryListener() {
        this.registryListener = new IDeviceRegistryListener(){

            public void deviceAdded(IDevice iDevice) {
                DeviceSelector.this.setInitialState();
                if (DeviceSelector.this.viewer != null && !DeviceSelector.this.viewer.getControl().isDisposed()) {
                    DeviceSelector.this.viewer.refresh();
                }
                if (DeviceSelector.this.deviceNamesViewer != null && !DeviceSelector.this.deviceNamesViewer.getControl().isDisposed()) {
                    DeviceSelector.this.deviceNamesViewer.refresh();
                }
            }

            public void deviceRemoved(IDevice iDevice) {
                IMIDPDevice iMIDPDevice = (IMIDPDevice)DeviceSelector.this.getSelectedDevice();
                if (iMIDPDevice != null && iMIDPDevice == iDevice) {
                    DeviceSelector.this.setInitialState();
                }
                if (DeviceSelector.this.viewer != null && !DeviceSelector.this.viewer.getControl().isDisposed()) {
                    DeviceSelector.this.viewer.refresh();
                }
                if (DeviceSelector.this.deviceNamesViewer != null && !DeviceSelector.this.deviceNamesViewer.getControl().isDisposed()) {
                    DeviceSelector.this.deviceNamesViewer.refresh();
                }
            }
        };
        MTJCore.getDeviceRegistry().addRegistryListener(this.registryListener);
    }

    private boolean areDevicesEqual(IDevice iDevice, IDevice iDevice2) {
        boolean bl = false;
        if (iDevice == null && iDevice2 == null) {
            bl = true;
        } else if (iDevice != null && iDevice2 != null) {
            bl = iDevice.equals(iDevice2);
        }
        return bl;
    }

    private boolean areDevicesRegistered() throws PersistenceException {
        return MTJCore.getDeviceRegistry().getDeviceCount() > 0;
    }

    private ComboViewer createDeviceGroupsViewer(Composite composite, int n) {
        this.viewer = new ComboViewer(composite, n);
        this.viewer.setContentProvider((IContentProvider)new DeviceGroupsContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DeviceGroupNameLabelProvider());
        this.viewer.setSorter((ViewerSorter)new LabelProviderViewerSorter());
        this.viewer.setInput(new Object());
        return this.viewer;
    }

    private void createDeviceManagementControls(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, true));
        GridData gridData = new GridData();
        gridData.verticalAlignment = 0x1000000;
        composite2.setLayoutData((Object)gridData);
        this.manageDevicesButton = new Button(composite2, 8);
        this.manageDevicesButton.setText(MTJUIMessages.DeviceSelector_manageDevicesButton_label);
        this.manageDevicesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Shell shell = selectionEvent.widget.getDisplay().getActiveShell();
                PreferenceManager preferenceManager = PlatformUI.getWorkbench().getPreferenceManager();
                PreferenceDialog preferenceDialog = new PreferenceDialog(shell, preferenceManager);
                preferenceDialog.setSelectedNode("org.eclipse.mtj.ui.preferences.deviceManagementPreferencePage");
                preferenceDialog.open();
            }
        });
    }

    private ComboViewer createDeviceNamesViewer(Composite composite, int n) {
        this.deviceNamesViewer = new ComboViewer(composite, n);
        this.deviceNamesViewer.setContentProvider((IContentProvider)new DeviceContentProvider());
        this.deviceNamesViewer.setLabelProvider((IBaseLabelProvider)new DeviceLabelProvider());
        this.deviceNamesViewer.setSorter((ViewerSorter)new LabelProviderViewerSorter());
        return this.deviceNamesViewer;
    }

    private void createSelectionControls(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(1808));
        new Label(composite2, 0).setText(MTJUIMessages.DeviceSelector_4);
        this.groupViewer = this.createDeviceGroupsViewer(composite2, 8);
        this.groupViewer.getCombo().setLayoutData((Object)new GridData(768));
        this.groupViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                DeviceSelector.this.deviceGroupChanged();
                if (DeviceSelector.this.selectionChangedListener != null && DeviceSelector.this.fireSelectionChangedListener) {
                    DeviceSelector.this.selectionChangedListener.selectionChanged(selectionChangedEvent);
                }
            }
        });
        new Label(composite2, 0).setText(MTJUIMessages.DeviceSelector_device_label);
        this.deviceViewer = this.createDeviceNamesViewer(composite2, 8);
        this.deviceViewer.getCombo().setLayoutData((Object)new GridData(768));
        this.deviceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                if (DeviceSelector.this.selectionChangedListener != null && DeviceSelector.this.fireSelectionChangedListener) {
                    DeviceSelector.this.selectionChangedListener.selectionChanged(selectionChangedEvent);
                }
            }
        });
    }

    private void deviceGroupChanged() {
        this.groupViewer.refresh();
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.groupViewer.getSelection();
        String string = (String)iStructuredSelection.getFirstElement();
        this.deviceViewer.setInput((Object)string);
        try {
            List list = MTJCore.getDeviceRegistry().getDevices(string);
            if (list != null && list.size() > 0) {
                this.deviceViewer.getCombo().select(0);
            }
        }
        catch (PersistenceException persistenceException) {
            MTJLogger.log((int)2, (String)(String.valueOf(MTJUIMessages.DeviceSelector_deviceGroupChanged_error_retrieving_devices) + string), (Throwable)persistenceException);
        }
    }

    private IDevice getDeviceToSelect() throws PersistenceException {
        IDevice iDevice = null;
        if (this.areDevicesRegistered()) {
            iDevice = this.getSelectedDevice();
            if (iDevice == null) {
                iDevice = MTJCore.getDeviceRegistry().getDefaultDevice();
            }
            if (iDevice == null) {
                List list = MTJCore.getDeviceRegistry().getAllDevices();
                iDevice = (IDevice)list.get(0);
            }
        }
        return iDevice;
    }

    private void setCompositeLayout(Composite composite, Composite composite2) {
        int n = 1;
        Layout layout = composite.getLayout();
        if (layout instanceof GridLayout) {
            n = ((GridLayout)layout).numColumns;
        }
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = n;
        composite2.setLayoutData((Object)gridData);
        composite2.setLayout((Layout)new GridLayout(2, false));
    }

    private void setInitialState() {
        try {
            IDevice iDevice = this.getDeviceToSelect();
            this.setSelectedDevice(iDevice);
        }
        catch (PersistenceException persistenceException) {
            MTJLogger.log((int)2, (String)MTJUIMessages.DeviceSelector_setInitialState_error_retrieving_devices, (Throwable)persistenceException);
        }
    }

    private void setViewerSelection(Viewer viewer, Object object) {
        StructuredSelection structuredSelection = new StructuredSelection(object);
        viewer.setSelection((ISelection)structuredSelection, true);
    }

    private class DeviceContentProvider
    implements IStructuredContentProvider {
        private DeviceContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            Object[] objectArray = DeviceSelector.this.NO_ELEMENTS;
            if (object != null) {
                String string = (String)object;
                try {
                    List list = MTJCore.getDeviceRegistry().getDevices(string);
                    if (list != null) {
                        objectArray = list.toArray(new Object[0]);
                    }
                }
                catch (PersistenceException persistenceException) {
                    MTJLogger.log((int)2, (String)MTJUIMessages.DeviceSelector_DeviceContentProvider_error_getElements, (Throwable)persistenceException);
                }
            }
            return objectArray;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private class DeviceGroupNameLabelProvider
    extends LabelProvider {
        private DeviceGroupNameLabelProvider() {
        }

        public String getText(Object object) {
            return (String)object;
        }
    }

    private class DeviceGroupsContentProvider
    implements IStructuredContentProvider {
        private DeviceGroupsContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            Object[] objectArray = DeviceSelector.this.NO_ELEMENTS;
            try {
                List list = MTJCore.getDeviceRegistry().getSDKNames();
                objectArray = list.toArray(new Object[list.size()]);
            }
            catch (PersistenceException persistenceException) {
                MTJLogger.log((int)2, (String)MTJUIMessages.DeviceSelector_DeviceGroupsContentProvider_error_getElements, (Throwable)persistenceException);
            }
            return objectArray;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private class DeviceLabelProvider
    extends LabelProvider {
        private DeviceLabelProvider() {
        }

        public String getText(Object object) {
            IDevice iDevice = (IDevice)object;
            return iDevice.getName();
        }
    }
}

