/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.dialog;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SigningPasswordsDialog
extends TitleAreaDialog {
    private String dialogMessage;
    private String keyPassword;
    private Text keyPasswordText;
    private String keystorePassword;
    private Text keystorePasswordText;
    private Button okButton;

    public SigningPasswordsDialog(Shell shell, IProject iProject) {
        super(shell);
        try {
            IProjectDescription iProjectDescription = iProject.getDescription();
            String string = iProjectDescription.getName();
            this.dialogMessage = NLS.bind((String)MTJUIMessages.SigningPasswordsDialog_message1, (Object)string);
        }
        catch (CoreException coreException) {
            this.dialogMessage = MTJUIMessages.SigningPasswordsDialog_message2;
        }
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeyPassword(String string) {
        this.keyPassword = string;
    }

    public void setKeystorePassword(String string) {
        this.keystorePassword = string;
    }

    private GridData buildGridData(int n, boolean bl, int n2) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = n;
        gridData.grabExcessHorizontalSpace = bl;
        gridData.horizontalSpan = n2;
        return gridData;
    }

    private void updateButtons() {
        if (this.okButton == null || this.keystorePasswordText == null || this.keyPasswordText == null) {
            return;
        }
        String string = this.keystorePasswordText.getText();
        if (string == null) {
            this.okButton.setEnabled(false);
            return;
        }
        if (string.length() == 0) {
            this.okButton.setEnabled(false);
            return;
        }
        string = this.keyPasswordText.getText();
        if (string == null) {
            this.okButton.setEnabled(false);
            return;
        }
        if (string.length() == 0) {
            this.okButton.setEnabled(false);
            return;
        }
        this.okButton.setEnabled(true);
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.okButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateButtons();
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.setTitle(MTJUIMessages.SigningPasswordsDialog_title);
        this.setMessage(this.dialogMessage, 1);
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite((Composite)super.createDialogArea(composite), 0);
        composite2.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout(2, false);
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(MTJUIMessages.SigningPasswordsDialog_keystore_password_label);
        this.keystorePasswordText = new Text(composite2, 0x400804);
        this.keystorePasswordText.setLayoutData((Object)this.buildGridData(4, true, 1));
        if (this.keystorePassword != null) {
            this.keystorePasswordText.setText(this.keystorePassword);
        }
        label = new Label(composite2, 0);
        label.setText(MTJUIMessages.SigningPasswordsDialog_kew_password_label);
        this.keyPasswordText = new Text(composite2, 0x400804);
        this.keyPasswordText.setLayoutData((Object)this.buildGridData(4, true, 1));
        if (this.keyPassword != null) {
            this.keyPasswordText.setText(this.keyPassword);
        }
        this.keystorePasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                SigningPasswordsDialog.this.updateButtons();
            }
        });
        this.keyPasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                SigningPasswordsDialog.this.updateButtons();
            }
        });
        this.updateButtons();
        return composite2;
    }

    protected void okPressed() {
        this.keystorePassword = this.keystorePasswordText.getText();
        this.keyPassword = this.keyPasswordText.getText();
        super.okPressed();
    }
}

