/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditorContributor;
import org.eclipse.mtj.internal.ui.editor.MTJProjectionSourcePage;
import org.eclipse.mtj.internal.ui.editor.MTJSourcePage;
import org.eclipse.mtj.internal.ui.editor.actions.FormatAction;
import org.eclipse.mtj.internal.ui.editor.actions.HyperlinkAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.TextEditorActionContributor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;

public class MTJFormTextEditorContributor
extends MTJFormEditorContributor {
    private RetargetTextEditorAction fCorrectionAssist;
    private HyperlinkAction fHyperlinkAction;
    private FormatAction formatAction;
    private RetargetTextEditorAction fContentAssist;
    private TextEditorActionContributor fSourceContributor = this.createSourceContributor();
    private SubActionBars fSourceActionBars;

    public void setFormatAction(FormatAction formatAction) {
        this.formatAction = formatAction;
    }

    public MTJFormTextEditorContributor(String string) {
        super(string);
        if (this.supportsCorrectionAssist()) {
            this.fCorrectionAssist = new RetargetTextEditorAction(MTJSourcePage.getBundleForConstructedKeys(), "CorrectionAssistProposal.");
            this.fCorrectionAssist.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals");
        }
        if (this.supportsHyperlinking()) {
            this.fHyperlinkAction = new HyperlinkAction();
            this.fHyperlinkAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.editor");
        }
        if (this.supportsFormatAction()) {
            // empty if block
        }
        if (this.supportsContentAssist()) {
            this.fContentAssist = new RetargetTextEditorAction(MTJSourcePage.getBundleForConstructedKeys(), "ContentAssistProposal.");
            this.fContentAssist.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        }
    }

    public boolean supportsCorrectionAssist() {
        return false;
    }

    public boolean supportsContentAssist() {
        return false;
    }

    public boolean supportsFormatAction() {
        return false;
    }

    public boolean supportsHyperlinking() {
        return false;
    }

    public IEditorActionBarContributor getSourceContributor() {
        return this.fSourceContributor;
    }

    public void init(IActionBars iActionBars) {
        super.init(iActionBars);
        this.fSourceActionBars = new SubActionBars(iActionBars);
        this.fSourceContributor.init((IActionBars)this.fSourceActionBars);
    }

    public void dispose() {
        this.fSourceActionBars.dispose();
        this.fSourceContributor.dispose();
        super.dispose();
    }

    protected void setSourceActionBarsActive(boolean bl) {
        IActionBars iActionBars = this.getActionBars();
        iActionBars.clearGlobalActionHandlers();
        iActionBars.updateActionBars();
        if (bl) {
            this.fSourceActionBars.activate();
            Map map = this.fSourceActionBars.getGlobalActionHandlers();
            if (map != null) {
                Set set = map.keySet();
                for (String string : set) {
                    iActionBars.setGlobalActionHandler(string, (IAction)map.get(string));
                }
            }
        } else {
            this.fSourceActionBars.deactivate();
            this.registerGlobalActionHandlers();
        }
        iActionBars.setGlobalActionHandler("org.eclipse.mtj.ui.actions.Open", (IAction)(bl ? this.fHyperlinkAction : null));
        iActionBars.setGlobalActionHandler("org.eclipse.mtj.ui.actions.Format", (IAction)(bl ? this.formatAction : null));
        iActionBars.setGlobalActionHandler(ActionFactory.REVERT.getId(), this.getRevertAction());
        iActionBars.updateActionBars();
    }

    private void registerGlobalActionHandlers() {
        this.registerGlobalAction(ActionFactory.DELETE.getId());
        this.registerGlobalAction(ActionFactory.UNDO.getId());
        this.registerGlobalAction(ActionFactory.REDO.getId());
        this.registerGlobalAction(ActionFactory.CUT.getId());
        this.registerGlobalAction(ActionFactory.COPY.getId());
        this.registerGlobalAction(ActionFactory.PASTE.getId());
        this.registerGlobalAction(ActionFactory.SELECT_ALL.getId());
        this.registerGlobalAction(ActionFactory.FIND.getId());
    }

    private void registerGlobalAction(String string) {
        IAction iAction = this.getGlobalAction(string);
        this.getActionBars().setGlobalActionHandler(string, iAction);
    }

    public void setActivePage(IEditorPart iEditorPart) {
        if (this.mtjFormEditor == null) {
            return;
        }
        IFormPage iFormPage = this.formPage;
        this.formPage = this.mtjFormEditor.getActivePageInstance();
        if (this.formPage == null) {
            return;
        }
        this.updateQuickOutlineMenuEntry();
        this.updateActions();
        if (iFormPage != null && !iFormPage.isEditor() && !this.formPage.isEditor()) {
            this.getActionBars().updateActionBars();
            return;
        }
        boolean bl = this.formPage instanceof MTJSourcePage;
        if (bl && this.formPage.equals(iFormPage)) {
            return;
        }
        this.fSourceContributor.setActiveEditor((IEditorPart)this.formPage);
        this.setSourceActionBarsActive(bl);
    }

    private void updateQuickOutlineMenuEntry() {
        IActionBars iActionBars = this.getActionBars();
        IMenuManager iMenuManager = iActionBars.getMenuManager();
        IMenuManager iMenuManager2 = iMenuManager.findMenuUsingPath("navigate");
        if (iMenuManager2 == null) {
            return;
        }
        iMenuManager2.remove("org.eclipse.mtj.ui.quickOutline");
        if (!(this.formPage instanceof MTJProjectionSourcePage)) {
            return;
        }
        MTJProjectionSourcePage mTJProjectionSourcePage = (MTJProjectionSourcePage)this.formPage;
        if (!mTJProjectionSourcePage.isQuickOutlineEnabled()) {
            return;
        }
        IAction iAction = mTJProjectionSourcePage.getAction("org.eclipse.mtj.ui.quickOutline");
        if (iAction == null) {
            return;
        }
        try {
            iMenuManager2.insertAfter("showIn", iAction);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    protected TextEditorActionContributor createSourceContributor() {
        return new MTJTextEditorActionContributor();
    }

    protected HyperlinkAction getHyperlinkAction() {
        return this.fHyperlinkAction;
    }

    protected FormatAction getFormatAction() {
        return this.formatAction;
    }

    class MTJTextEditorActionContributor
    extends TextEditorActionContributor {
        MTJTextEditorActionContributor() {
        }

        public void contributeToMenu(IMenuManager iMenuManager) {
            super.contributeToMenu(iMenuManager);
            IMenuManager iMenuManager2 = iMenuManager.findMenuUsingPath("edit");
            if (iMenuManager2 != null) {
                iMenuManager2.add((IContributionItem)new Separator("group.open"));
                iMenuManager2.add((IContributionItem)new Separator("group.generate"));
                iMenuManager2.add((IContributionItem)new Separator("additions"));
                if (MTJFormTextEditorContributor.this.fCorrectionAssist != null) {
                    iMenuManager2.appendToGroup("group.generate", (IAction)MTJFormTextEditorContributor.this.fCorrectionAssist);
                }
                if (MTJFormTextEditorContributor.this.fContentAssist != null) {
                    iMenuManager2.appendToGroup("group.generate", (IAction)MTJFormTextEditorContributor.this.fContentAssist);
                }
            }
        }

        public void contributeToToolBar(IToolBarManager iToolBarManager) {
            super.contributeToToolBar(iToolBarManager);
            if (MTJFormTextEditorContributor.this.fHyperlinkAction != null) {
                iToolBarManager.add((IAction)MTJFormTextEditorContributor.this.fHyperlinkAction);
            }
        }

        public void setActiveEditor(IEditorPart iEditorPart) {
            ITextEditor iTextEditor;
            super.setActiveEditor(iEditorPart);
            IActionBars iActionBars = this.getActionBars();
            IStatusLineManager iStatusLineManager = iActionBars.getStatusLineManager();
            iStatusLineManager.setMessage(null);
            iStatusLineManager.setErrorMessage(null);
            ITextEditor iTextEditor2 = iTextEditor = iEditorPart instanceof ITextEditor ? (ITextEditor)iEditorPart : null;
            if (MTJFormTextEditorContributor.this.fCorrectionAssist != null) {
                MTJFormTextEditorContributor.this.fCorrectionAssist.setAction(this.getAction(iTextEditor, "QuickAssist"));
            }
            if (MTJFormTextEditorContributor.this.fHyperlinkAction != null) {
                MTJFormTextEditorContributor.this.fHyperlinkAction.setTextEditor(iTextEditor);
            }
            if (MTJFormTextEditorContributor.this.formatAction != null) {
                MTJFormTextEditorContributor.this.formatAction.setTextEditor(iTextEditor);
            }
            if (MTJFormTextEditorContributor.this.fContentAssist != null) {
                MTJFormTextEditorContributor.this.fContentAssist.setAction(this.getAction(iTextEditor, "ContentAssist"));
            }
        }
    }
}

