/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.views.markers.MarkerViewUtil;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectMarkerRulerAction
extends ResourceAction
implements IUpdate {
    private ResourceBundle fBundle;
    private String fPrefix;
    private IVerticalRulerInfo fRuler;
    private ITextEditor fTextEditor;

    public SelectMarkerRulerAction(ResourceBundle resourceBundle, String string, ITextEditor iTextEditor, IVerticalRulerInfo iVerticalRulerInfo) {
        super(resourceBundle, string);
        this.fRuler = iVerticalRulerInfo;
        this.fTextEditor = iTextEditor;
        this.fBundle = resourceBundle;
        this.fPrefix = string;
    }

    public void run() {
        IMarker iMarker = this.chooseMarker(this.getMarkers());
        if (iMarker == null) {
            return;
        }
        IWorkbenchPage iWorkbenchPage = this.fTextEditor.getSite().getPage();
        MarkerViewUtil.showMarker((IWorkbenchPage)iWorkbenchPage, (IMarker)iMarker, (boolean)false);
        this.gotoMarker(iMarker);
    }

    public void update() {
        this.setEnabled(this.hasMarkers());
    }

    private void gotoMarker(IMarker iMarker) {
        int n;
        AbstractMarkerAnnotationModel abstractMarkerAnnotationModel;
        IEditorInput iEditorInput;
        IGotoMarker iGotoMarker = (IGotoMarker)this.fTextEditor.getAdapter(IGotoMarker.class);
        if (iGotoMarker != null) {
            iGotoMarker.gotoMarker(iMarker);
            return;
        }
        int n2 = MarkerUtilities.getCharStart((IMarker)iMarker);
        int n3 = MarkerUtilities.getCharEnd((IMarker)iMarker);
        boolean bl = n2 < 0 || n3 < 0;
        IDocumentProvider iDocumentProvider = this.fTextEditor.getDocumentProvider();
        IAnnotationModel iAnnotationModel = iDocumentProvider.getAnnotationModel((Object)(iEditorInput = this.fTextEditor.getEditorInput()));
        if (iAnnotationModel instanceof AbstractMarkerAnnotationModel) {
            abstractMarkerAnnotationModel = (AbstractMarkerAnnotationModel)iAnnotationModel;
            Position position = abstractMarkerAnnotationModel.getMarkerPosition(iMarker);
            if (position != null && !position.isDeleted()) {
                n2 = position.getOffset();
                n3 = position.getOffset() + position.getLength();
            }
            if (position != null && position.isDeleted()) {
                return;
            }
        }
        abstractMarkerAnnotationModel = iDocumentProvider.getDocument((Object)iEditorInput);
        if (bl) {
            try {
                int n4;
                if (n2 >= 0) {
                    n4 = abstractMarkerAnnotationModel.getLineOfOffset(n2);
                } else {
                    n4 = MarkerUtilities.getLineNumber((IMarker)iMarker);
                    --n4;
                }
                n3 = n2 + abstractMarkerAnnotationModel.getLineLength(n4) - 1;
            }
            catch (BadLocationException badLocationException) {
                return;
            }
        }
        if (n3 - 1 < (n = abstractMarkerAnnotationModel.getLength()) && n2 < n) {
            this.fTextEditor.selectAndReveal(n2, n3 - n2);
        }
    }

    private boolean includesLine(Position position, IDocument iDocument, int n) {
        if (position != null) {
            try {
                int n2 = iDocument.getLineOfOffset(position.getOffset());
                if (n == n2) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    private void logException(IStatus iStatus) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
        ILog iLog = Platform.getLog((Bundle)bundle);
        iLog.log(iStatus);
    }

    protected IMarker chooseMarker(List<IMarker> list) {
        AbstractMarkerAnnotationModel abstractMarkerAnnotationModel = this.getAnnotationModel();
        IAnnotationAccessExtension iAnnotationAccessExtension = this.getAnnotationAccessExtension();
        IMarker iMarker = null;
        int n = 0;
        for (IMarker iMarker2 : list) {
            MarkerAnnotation markerAnnotation = abstractMarkerAnnotationModel.getMarkerAnnotation(iMarker2);
            if (markerAnnotation == null) continue;
            if (iAnnotationAccessExtension == null) {
                iMarker = iMarker2;
                break;
            }
            int n2 = iAnnotationAccessExtension.getLayer((Annotation)markerAnnotation);
            if (n2 == n) {
                if (iMarker != null) continue;
                iMarker = iMarker2;
                continue;
            }
            if (n2 <= n) continue;
            n = n2;
            iMarker = iMarker2;
        }
        return iMarker;
    }

    protected IAnnotationAccessExtension getAnnotationAccessExtension() {
        Object object = this.fTextEditor.getAdapter(IAnnotationAccess.class);
        if (object instanceof IAnnotationAccessExtension) {
            return (IAnnotationAccessExtension)object;
        }
        return null;
    }

    protected AbstractMarkerAnnotationModel getAnnotationModel() {
        IDocumentProvider iDocumentProvider = this.fTextEditor.getDocumentProvider();
        IAnnotationModel iAnnotationModel = iDocumentProvider.getAnnotationModel((Object)this.fTextEditor.getEditorInput());
        if (iAnnotationModel instanceof AbstractMarkerAnnotationModel) {
            return (AbstractMarkerAnnotationModel)iAnnotationModel;
        }
        return null;
    }

    protected IDocument getDocument() {
        IDocumentProvider iDocumentProvider = this.fTextEditor.getDocumentProvider();
        return iDocumentProvider.getDocument((Object)this.fTextEditor.getEditorInput());
    }

    protected List<IMarker> getMarkers() {
        Bundle bundle;
        Iterator iterator;
        Object object;
        IMarker[] iMarkerArray;
        IResource iResource = this.getResource();
        if (iResource == null || !iResource.exists()) {
            return Collections.emptyList();
        }
        IDocument iDocument = this.getDocument();
        if (iDocument == null) {
            return Collections.emptyList();
        }
        AbstractMarkerAnnotationModel abstractMarkerAnnotationModel = this.getAnnotationModel();
        if (abstractMarkerAnnotationModel == null) {
            return Collections.emptyList();
        }
        try {
            iMarkerArray = iResource.findMarkers(null, true, 0);
        }
        catch (CoreException coreException) {
            this.handleCoreException(coreException, "SelectMarkerRulerAction.getMarker");
            return Collections.emptyList();
        }
        if (iMarkerArray.length == 0) {
            return Collections.emptyList();
        }
        int n = this.fRuler.getLineOfLastMouseButtonActivity();
        if (n == -1) {
            return Collections.emptyList();
        }
        try {
            object = iDocument.getLineInformation(n);
            iterator = abstractMarkerAnnotationModel.getAnnotationIterator(object.getOffset(), object.getLength() + 1, true, true);
        }
        catch (BadLocationException badLocationException) {
            bundle = Platform.getBundle((String)"org.eclipse.ui");
            Platform.getLog((Bundle)bundle).log((IStatus)new Status(4, "org.eclipse.ui", 0, badLocationException.getLocalizedMessage(), (Throwable)badLocationException));
            iterator = abstractMarkerAnnotationModel.getAnnotationIterator();
        }
        object = null;
        while (iterator.hasNext()) {
            Position position;
            bundle = (Annotation)iterator.next();
            if (!(bundle instanceof MarkerAnnotation) || !this.includesLine(position = abstractMarkerAnnotationModel.getPosition((Annotation)bundle), iDocument, n)) continue;
            if (object == null) {
                object = new ArrayList(10);
            }
            object.add(((MarkerAnnotation)bundle).getMarker());
        }
        if (object == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(object);
    }

    protected IResource getResource() {
        IEditorInput iEditorInput = this.fTextEditor.getEditorInput();
        IResource iResource = (IResource)iEditorInput.getAdapter(IFile.class);
        if (iResource == null) {
            iResource = (IResource)iEditorInput.getAdapter(IResource.class);
        }
        return iResource;
    }

    protected void handleCoreException(CoreException coreException, String string) {
        Object object = string != null ? new Status(4, "org.eclipse.ui", 0, string, (Throwable)coreException) : coreException.getStatus();
        this.logException((IStatus)object);
        Shell shell = this.fTextEditor.getSite().getShell();
        String string2 = SelectMarkerRulerAction.getString((ResourceBundle)this.fBundle, (String)(String.valueOf(this.fPrefix) + "error.dialog.title"), (String)(String.valueOf(this.fPrefix) + "error.dialog.title"));
        String string3 = SelectMarkerRulerAction.getString((ResourceBundle)this.fBundle, (String)(String.valueOf(this.fPrefix) + "error.dialog.message"), (String)(String.valueOf(this.fPrefix) + "error.dialog.message"));
        ErrorDialog.openError((Shell)shell, (String)string2, (String)string3, (IStatus)coreException.getStatus());
    }

    protected boolean hasMarkers() {
        Iterator iterator;
        IRegion iRegion;
        IMarker[] iMarkerArray;
        IResource iResource = this.getResource();
        if (iResource == null || !iResource.exists()) {
            return false;
        }
        IDocument iDocument = this.getDocument();
        if (iDocument == null) {
            return false;
        }
        AbstractMarkerAnnotationModel abstractMarkerAnnotationModel = this.getAnnotationModel();
        if (abstractMarkerAnnotationModel == null) {
            return false;
        }
        try {
            iMarkerArray = iResource.findMarkers(null, true, 0);
        }
        catch (CoreException coreException) {
            this.handleCoreException(coreException, "SelectMarkerRulerAction.getMarker");
            return false;
        }
        if (iMarkerArray.length == 0) {
            return false;
        }
        int n = this.fRuler.getLineOfLastMouseButtonActivity();
        if (n == -1) {
            return false;
        }
        try {
            iRegion = iDocument.getLineInformation(n);
            iterator = abstractMarkerAnnotationModel.getAnnotationIterator(iRegion.getOffset(), iRegion.getLength() + 1, true, true);
        }
        catch (BadLocationException badLocationException) {
            this.logException((IStatus)new Status(4, "org.eclipse.ui", 0, badLocationException.getLocalizedMessage(), (Throwable)badLocationException));
            iterator = abstractMarkerAnnotationModel.getAnnotationIterator();
        }
        while (iterator.hasNext()) {
            Position position;
            iRegion = (Annotation)iterator.next();
            if (!(iRegion instanceof MarkerAnnotation) || !this.includesLine(position = abstractMarkerAnnotationModel.getPosition((Annotation)iRegion), iDocument, n)) continue;
            return true;
        }
        return false;
    }

    protected boolean includesRulerLine(Position position, IDocument iDocument) {
        if (position != null) {
            try {
                int n = iDocument.getLineOfOffset(position.getOffset());
                int n2 = this.fRuler.getLineOfLastMouseButtonActivity();
                if (n2 == n) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }
}

