/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor.text;

import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.mtj.internal.ui.editor.MTJSourcePage;
import org.eclipse.mtj.internal.ui.editor.text.MTJWordFinder;
import org.eclipse.mtj.internal.ui.editors.l10n.L10nXMLTextHover;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class SourceInformationProvider
implements IInformationProvider,
IInformationProviderExtension2,
IPartListener {
    public static final int NO_IMP = 0;
    public static final int F_XML_IMP = 1;
    private IInformationControlCreator fPresenterControlCreator;
    protected String fCurrentPerspective;
    protected ITextHover fImplementation;
    protected int fImpType;
    protected MTJSourcePage fSourcePage;

    public SourceInformationProvider(MTJSourcePage mTJSourcePage, IInformationControlCreator iInformationControlCreator, int n) {
        this.fSourcePage = mTJSourcePage;
        this.fPresenterControlCreator = iInformationControlCreator;
        this.fImpType = n;
        if (this.fSourcePage != null && this.fImpType != 0) {
            this.fSourcePage.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener)this);
            this.update();
        }
    }

    public String getInformation(ITextViewer iTextViewer, IRegion iRegion) {
        String string;
        if (this.fImplementation != null && (string = this.fImplementation.getHoverInfo(iTextViewer, iRegion)) != null && string.trim().length() > 0) {
            return string;
        }
        return null;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return this.fPresenterControlCreator;
    }

    public IRegion getSubject(ITextViewer iTextViewer, int n) {
        if (iTextViewer != null) {
            return MTJWordFinder.findWord(iTextViewer.getDocument(), n);
        }
        return null;
    }

    public void partActivated(IWorkbenchPart iWorkbenchPart) {
        this.update();
    }

    public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
        this.update();
    }

    public void partClosed(IWorkbenchPart iWorkbenchPart) {
        if (this.fSourcePage != null && iWorkbenchPart == this.fSourcePage.getEditor() && this.fImpType != 0) {
            this.fSourcePage.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener)this);
        }
    }

    public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
    }

    public void partOpened(IWorkbenchPart iWorkbenchPart) {
    }

    protected void update() {
        IPerspectiveDescriptor iPerspectiveDescriptor;
        IWorkbenchPage iWorkbenchPage = this.fSourcePage.getSite().getWorkbenchWindow().getActivePage();
        if (iWorkbenchPage != null && (iPerspectiveDescriptor = iWorkbenchPage.getPerspective()) != null) {
            String string = iPerspectiveDescriptor.getId();
            if (this.fCurrentPerspective == null || this.fCurrentPerspective != string) {
                this.fCurrentPerspective = string;
                switch (this.fImpType) {
                    case 1: {
                        this.fImplementation = new L10nXMLTextHover(this.fSourcePage);
                    }
                }
            }
        }
    }
}

