/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.l10n.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.l10n.L10nObject;
import org.eclipse.mtj.internal.ui.MTJUIMessages;

public class L10nRemoveObjectAction
extends Action {
    private L10nObject[] l10nObjects;
    private L10nObject objectToSelect;

    public L10nRemoveObjectAction() {
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.setText(MTJUIMessages.L10nRemoveObjectAction_text);
        this.l10nObjects = null;
        this.objectToSelect = null;
    }

    public L10nObject getNextSelection() {
        return this.objectToSelect;
    }

    public void run() {
        if (this.l10nObjects == null) {
            return;
        }
        int n = 0;
        while (n < this.l10nObjects.length) {
            L10nObject l10nObject;
            if (this.l10nObjects[n] != null && this.l10nObjects[n].canBeRemoved() && (l10nObject = this.l10nObjects[n].getParent()) != null && l10nObject.canBeParent()) {
                this.determineNextSelection(l10nObject, n);
                l10nObject.removeChildNode((IDocumentElementNode)this.l10nObjects[n], true);
            }
            ++n;
        }
    }

    public void setToRemove(L10nObject l10nObject) {
        this.l10nObjects = new L10nObject[]{l10nObject};
    }

    public void setToRemove(L10nObject[] l10nObjectArray) {
        this.l10nObjects = l10nObjectArray;
    }

    private void determineNextSelection(L10nObject l10nObject, int n) {
        this.objectToSelect = l10nObject.getNextSibling(this.l10nObjects[n]);
        if (this.objectToSelect == null) {
            this.objectToSelect = l10nObject.getPreviousSibling(this.l10nObjects[n]);
            if (this.objectToSelect == null) {
                this.objectToSelect = l10nObject;
            }
        }
    }
}

