/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.parts;

import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.mtj.internal.ui.parts.SharedPartWithButtons;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class StructuredViewerPart
extends SharedPartWithButtons {
    private Point fMinSize;
    private StructuredViewer fViewer;

    public StructuredViewerPart(String[] stringArray) {
        super(stringArray);
    }

    public Control getControl() {
        return this.fViewer.getControl();
    }

    public StructuredViewer getViewer() {
        return this.fViewer;
    }

    public void setMinimumSize(int n, int n2) {
        this.fMinSize = new Point(n, n2);
        if (this.fViewer != null) {
            this.applyMinimumSize();
        }
    }

    private void applyMinimumSize() {
        if (this.fMinSize != null) {
            GridData gridData = (GridData)this.fViewer.getControl().getLayoutData();
            gridData.widthHint = this.fMinSize.x;
            gridData.heightHint = this.fMinSize.y;
        }
    }

    protected void createMainControl(Composite composite, int n, int n2, FormToolkit formToolkit) {
        this.fViewer = this.createStructuredViewer(composite, n, formToolkit);
        Control control = this.fViewer.getControl();
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = n2;
        control.setLayoutData((Object)gridData);
        this.applyMinimumSize();
    }

    protected abstract StructuredViewer createStructuredViewer(Composite var1, int var2, FormToolkit var3);

    protected void updateEnabledState() {
        this.getControl().setEnabled(this.isEnabled());
        super.updateEnabledState();
    }
}

