/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.util;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;

public class PixelConverter {
    private final FontMetrics fFontMetrics;

    public PixelConverter(Control control) {
        this(control.getFont());
    }

    public PixelConverter(Font font) {
        GC gC = new GC((Drawable)font.getDevice());
        gC.setFont(font);
        this.fFontMetrics = gC.getFontMetrics();
        gC.dispose();
    }

    public int convertHeightInCharsToPixels(int n) {
        return Dialog.convertHeightInCharsToPixels((FontMetrics)this.fFontMetrics, (int)n);
    }

    public int convertHorizontalDLUsToPixels(int n) {
        return Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.fFontMetrics, (int)n);
    }

    public int convertVerticalDLUsToPixels(int n) {
        return Dialog.convertVerticalDLUsToPixels((FontMetrics)this.fFontMetrics, (int)n);
    }

    public int convertWidthInCharsToPixels(int n) {
        return Dialog.convertWidthInCharsToPixels((FontMetrics)this.fFontMetrics, (int)n);
    }
}

