package world;


public class PrepaidPhone {
	private static int RATE = 15;

	private int credit;
	private boolean isTalking = false;
	private boolean stopRequested = false;
	
	public void talk(int duration) {
		this.stopRequested = false;
		this.isTalking = true;
		try {
			for (int i=duration; i>0; i--) {
				if (stopRequested) {
					System.out.println("hang up on stop request");
					break;
				} else if (credit - RATE < 0) {
					System.out.println("Phone ran out of credits");
					break;
				} else {
					credit -= RATE;
				}
				System.out.println("blah");
				try {
					Thread.sleep(1000);
				} catch (InterruptedException ie) {
					break;
				}
			}
		} finally {
			this.isTalking = false;
		}
	}
	
	public void load(int amount) {
		if (this.isTalking)
			throw new RuntimeException("Cannot load during talking");
		this.credit += amount;
		System.out.println("Phone loaded with "+this.credit);
	}

	public int getCredit() {
		return credit;
	}
	
	void requestStop() {
		this.stopRequested = true;
	}
}
