/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public abstract class NameReference
extends Reference
implements InvocationSite {
    public Binding binding;
    public TypeBinding actualReceiverType;
    public Expression.DecapsulationState baseclassDecapsulation = Expression.DecapsulationState.NONE;

    public void setBaseclassDecapsulation(Expression.DecapsulationState state) {
        this.baseclassDecapsulation = state;
    }

    public Expression.DecapsulationState getBaseclassDecapsulation() {
        return this.baseclassDecapsulation;
    }

    public void tagReportedBaseclassDecapsulation() {
        this.baseclassDecapsulation = Expression.DecapsulationState.REPORTED;
    }

    protected boolean checkBaseclassDecapsulation(Scope scope) {
        if (this.binding instanceof ProblemReferenceBinding && this.binding.problemId() == 2 && this.getBaseclassDecapsulation().isAllowed()) {
            TypeBinding closestMatch = ((ProblemReferenceBinding)this.binding).closestMatch();
            if (closestMatch == null) {
                return false;
            }
            this.binding = closestMatch;
            if (this.binding.kind() == 4) {
                this.resolvedType = (TypeBinding)this.binding;
            }
            return true;
        }
        return false;
    }

    public NameReference() {
        this.bits |= 7;
    }

    public FieldBinding fieldBinding() {
        return (FieldBinding)this.binding;
    }

    public FieldBinding lastFieldBinding() {
        if ((this.bits & 7) == 1) {
            return this.fieldBinding();
        }
        return null;
    }

    public boolean isSuperAccess() {
        return false;
    }

    public boolean isTypeAccess() {
        return this.binding == null || this.binding instanceof ReferenceBinding;
    }

    public boolean isTypeReference() {
        return this.binding instanceof ReferenceBinding;
    }

    public void setActualReceiverType(ReferenceBinding receiverType) {
        if (receiverType == null) {
            return;
        }
        this.actualReceiverType = receiverType;
    }

    public void setDepth(int depth) {
        this.bits &= 0xFFFFE01F;
        if (depth > 0) {
            this.bits |= (depth & 0xFF) << 5;
        }
    }

    public void setFieldIndex(int index) {
    }

    public abstract String unboundReferenceErrorName();

    public void resolveFinished() {
    }
}

